/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle.sorting;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.jawr.web.exception.BundlingProcessException;
import net.jawr.web.resource.bundle.factory.util.PathNormalizer;

public class SortFileParser {
    private Reader reader;
    private Collection<String> availableResources;
    private String dirName;

    public SortFileParser(Reader reader, Collection<String> availableResources, String dirName) {
        this.reader = reader;
        this.availableResources = availableResources;
        this.dirName = dirName;
    }

    public List<String> getSortedResources() {
        ArrayList<String> resources = new ArrayList<String>();
        BufferedReader bf = new BufferedReader(this.reader);
        try {
            String res;
            block2: while ((res = bf.readLine()) != null) {
                String name = PathNormalizer.normalizePath(res.trim());
                for (String available : this.availableResources) {
                    if (!PathNormalizer.normalizePath(available).equals(name)) continue;
                    if (name.endsWith(".js") || name.endsWith(".css")) {
                        resources.add(PathNormalizer.joinPaths(this.dirName, name));
                    } else {
                        resources.add(PathNormalizer.joinPaths(this.dirName, name + "/"));
                    }
                    this.availableResources.remove(available);
                    continue block2;
                }
            }
        }
        catch (IOException e) {
            throw new BundlingProcessException("Unexpected IOException reading sort file", e);
        }
        return resources;
    }
}

