/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.handler.reader;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.Set;
import net.jawr.web.config.JawrConfig;
import net.jawr.web.exception.BundlingProcessException;
import net.jawr.web.resource.handler.reader.ResourceBrowser;
import net.jawr.web.resource.handler.reader.StreamResourceReader;
import net.jawr.web.resource.handler.reader.TextResourceReader;
import net.jawr.web.util.FileUtils;
import net.jawr.web.util.StringUtils;

public class FileSystemResourceReader
implements TextResourceReader,
StreamResourceReader,
ResourceBrowser {
    private String baseDir;
    private Charset charset;

    public FileSystemResourceReader(JawrConfig config) {
        this(config.getProperty("jawr.basecontext.directory"), config);
    }

    public FileSystemResourceReader(String baseDir, JawrConfig config) {
        File baseDirFile;
        this.baseDir = baseDir;
        if (StringUtils.isEmpty(this.baseDir)) {
            throw new BundlingProcessException("The 'jawr.basecontext.directory' is not set. Please provide a value or remove it if it's not used.");
        }
        if (this.baseDir != null && this.baseDir.startsWith("file://")) {
            this.baseDir = this.baseDir.substring("file://".length());
        }
        if (!(baseDirFile = new File(this.baseDir)).exists()) {
            throw new BundlingProcessException("The base context directory '" + this.baseDir + " doesn't exists. Please check your configuration.");
        }
        if (!baseDirFile.isDirectory()) {
            throw new BundlingProcessException("The base context directory '" + this.baseDir + " is not a directory. Please check your configuration.");
        }
        this.charset = config.getResourceCharset();
    }

    @Override
    public Reader getResource(String resourceName) {
        return this.getResource(resourceName, false);
    }

    @Override
    public Reader getResource(String resourceName, boolean processingBundle) {
        Reader rd = null;
        FileInputStream fis = (FileInputStream)this.getResourceAsStream(resourceName);
        if (fis != null) {
            FileChannel inchannel = fis.getChannel();
            rd = Channels.newReader(inchannel, this.charset.newDecoder(), -1);
        }
        return rd;
    }

    @Override
    public InputStream getResourceAsStream(String resourceName) {
        return this.getResourceAsStream(resourceName, false);
    }

    @Override
    public InputStream getResourceAsStream(String resourceName, boolean processingBundle) {
        FileInputStream is = null;
        try {
            File resource = new File(this.baseDir, resourceName);
            is = new FileInputStream(resource);
        }
        catch (FileNotFoundException e) {
            // empty catch block
        }
        return is;
    }

    @Override
    public Set<String> getResourceNames(String path) {
        path = path.replace('/', File.separatorChar);
        File resource = new File(this.baseDir, path);
        return FileUtils.getResourceNames(resource);
    }

    @Override
    public boolean isDirectory(String dirPath) {
        String path = dirPath.replace('/', File.separatorChar);
        return new File(this.baseDir, path).isDirectory();
    }
}

