/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.handler.reader;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.ServletContext;
import net.jawr.web.JawrConstant;
import net.jawr.web.config.JawrConfig;
import net.jawr.web.exception.ResourceNotFoundException;
import net.jawr.web.resource.FileNameUtils;
import net.jawr.web.resource.bundle.factory.util.ClassLoaderResourceUtils;
import net.jawr.web.resource.bundle.generator.GeneratorRegistry;
import net.jawr.web.resource.bundle.generator.ResourceGenerator;
import net.jawr.web.resource.handler.reader.FileSystemResourceReader;
import net.jawr.web.resource.handler.reader.ResourceBrowser;
import net.jawr.web.resource.handler.reader.ResourceReader;
import net.jawr.web.resource.handler.reader.ResourceReaderHandler;
import net.jawr.web.resource.handler.reader.ServletContextAware;
import net.jawr.web.resource.handler.reader.ServletContextResourceReader;
import net.jawr.web.resource.handler.reader.StreamResourceReader;
import net.jawr.web.resource.handler.reader.TextResourceReader;
import net.jawr.web.resource.handler.reader.WorkingDirectoryLocationAware;
import net.jawr.web.servlet.util.MIMETypesSupport;
import net.jawr.web.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletContextResourceReaderHandler
implements ResourceReaderHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServletContextResourceReaderHandler.class);
    private ServletContext servletContext;
    private String workingDirectory;
    private GeneratorRegistry generatorRegistry;
    private List<TextResourceReader> resourceReaders = new ArrayList<TextResourceReader>();
    private List<StreamResourceReader> streamResourceReaders = new ArrayList<StreamResourceReader>();
    private List<ResourceBrowser> resourceInfoProviders = new ArrayList<ResourceBrowser>();
    private List<String> allowedExtensions = new ArrayList<String>();

    public ServletContextResourceReaderHandler(ServletContext servletContext, JawrConfig jawrConfig, GeneratorRegistry generatorRegistry) throws IOException {
        String tempWorkingDirectory = ((File)servletContext.getAttribute("javax.servlet.context.tempdir")).getCanonicalPath();
        if (jawrConfig.getUseBundleMapping() && StringUtils.isNotEmpty(jawrConfig.getJawrWorkingDirectory())) {
            tempWorkingDirectory = jawrConfig.getJawrWorkingDirectory();
        }
        this.servletContext = servletContext;
        this.generatorRegistry = generatorRegistry;
        this.generatorRegistry.setResourceReaderHandler(this);
        if (tempWorkingDirectory.startsWith("file://")) {
            tempWorkingDirectory = tempWorkingDirectory.substring("file://".length());
        }
        this.allowedExtensions.addAll(JawrConstant.DEFAULT_RESOURCE_EXTENSIONS);
        if ("binary".equals(jawrConfig.getResourceType())) {
            for (Object key : MIMETypesSupport.getSupportedProperties(JawrConfig.class).keySet()) {
                if (this.allowedExtensions.contains((String)key)) continue;
                this.allowedExtensions.add((String)key);
            }
        } else {
            this.allowedExtensions.add(jawrConfig.getResourceType());
        }
        this.workingDirectory = tempWorkingDirectory;
        ServletContextResourceReader rd = (ServletContextResourceReader)ClassLoaderResourceUtils.buildObjectInstance(jawrConfig.getServletContextResourceReaderClass());
        rd.init(servletContext, jawrConfig);
        this.addResourceReaderToEnd(rd);
        String baseContextDir = jawrConfig.getProperty("jawr.basecontext.directory");
        if (StringUtils.isNotEmpty(baseContextDir)) {
            boolean baseContextDirHighPriority;
            FileSystemResourceReader fileRd = new FileSystemResourceReader(jawrConfig);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("The base directory context is set to " + baseContextDir);
            }
            if (baseContextDirHighPriority = Boolean.valueOf(jawrConfig.getProperty("jawr.basecontext.directory.high.priority")).booleanValue()) {
                this.addResourceReaderToStart(fileRd);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Jawr will search in priority in the base directory context before searching in the war content.");
                }
            } else {
                this.addResourceReaderToEnd(fileRd);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Jawr will search in priority in the war content before searching in the base directory context.");
                }
            }
        }
    }

    @Override
    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    @Override
    public void setWorkingDirectory(String workingDir) {
        this.workingDirectory = workingDir;
    }

    private void initReader(Object obj) {
        if (obj instanceof WorkingDirectoryLocationAware) {
            ((WorkingDirectoryLocationAware)obj).setWorkingDirectory(this.workingDirectory);
        }
        if (obj instanceof ServletContextAware) {
            ((ServletContextAware)obj).setServletContext(this.servletContext);
        }
        if (obj instanceof ResourceBrowser) {
            this.resourceInfoProviders.add(0, (ResourceBrowser)obj);
        }
    }

    @Override
    public void addResourceReaderToEnd(ResourceReader rd) {
        if (rd instanceof TextResourceReader) {
            this.resourceReaders.add((TextResourceReader)rd);
        }
        if (rd instanceof StreamResourceReader) {
            this.streamResourceReaders.add((StreamResourceReader)rd);
        }
        this.initReader(rd);
    }

    @Override
    public void addResourceReaderToStart(ResourceReader rd) {
        if (rd instanceof TextResourceReader) {
            this.resourceReaders.add(0, (TextResourceReader)rd);
        }
        if (rd instanceof StreamResourceReader) {
            this.streamResourceReaders.add(0, (StreamResourceReader)rd);
        }
        this.initReader(rd);
    }

    @Override
    public Reader getResource(String resourceName) throws ResourceNotFoundException {
        return this.getResource(resourceName, false);
    }

    @Override
    public Reader getResource(String resourceName, boolean processingBundle) throws ResourceNotFoundException {
        return this.getResource(resourceName, processingBundle, new ArrayList());
    }

    @Override
    public Reader getResource(String resourceName, boolean processingBundle, List<Class<?>> excludedReader) throws ResourceNotFoundException {
        Reader rd = null;
        String resourceExtension = FileNameUtils.getExtension(resourceName);
        boolean generatedPath = this.generatorRegistry.isPathGenerated(resourceName);
        if (generatedPath || this.allowedExtensions.contains(resourceExtension.toLowerCase())) {
            for (TextResourceReader rsReader : this.resourceReaders) {
                if (this.isInstanceOf(rsReader, excludedReader) || rsReader instanceof ResourceGenerator && !((ResourceGenerator)((Object)rsReader)).getResolver().matchPath(resourceName)) continue;
                try {
                    rd = rsReader.getResource(resourceName, processingBundle);
                }
                catch (Exception e) {
                    throw new ResourceNotFoundException(resourceName, e);
                }
                if (rd == null) continue;
                break;
            }
        } else {
            LOGGER.warn("The resource '" + resourceName + "' will not be read as its extension is not an allowed one.");
        }
        if (rd == null) {
            throw new ResourceNotFoundException(resourceName);
        }
        return rd;
    }

    private boolean isInstanceOf(Object rd, List<Class<?>> interfaces) {
        boolean result = false;
        for (Class<?> class1 : interfaces) {
            if (!class1.isInstance(rd)) continue;
            result = true;
            break;
        }
        return result;
    }

    @Override
    public InputStream getResourceAsStream(String resourceName) throws ResourceNotFoundException {
        return this.getResourceAsStream(resourceName, false);
    }

    @Override
    public InputStream getResourceAsStream(String resourceName, boolean processingBundle) throws ResourceNotFoundException {
        this.generatorRegistry.loadGeneratorIfNeeded(resourceName);
        InputStream is = null;
        String resourceExtension = FileNameUtils.getExtension(resourceName);
        boolean generatedPath = this.generatorRegistry.isPathGenerated(resourceName);
        if (generatedPath || this.allowedExtensions.contains(resourceExtension.toLowerCase())) {
            for (StreamResourceReader rsReader : this.streamResourceReaders) {
                if ((!(rsReader instanceof ResourceGenerator) || ((ResourceGenerator)((Object)rsReader)).getResolver().matchPath(resourceName)) && (is = rsReader.getResourceAsStream(resourceName)) != null) break;
            }
        } else {
            LOGGER.warn("The resource '" + resourceName + "' will not be read as its extension is not an allowed one.");
        }
        if (is == null) {
            throw new ResourceNotFoundException(resourceName);
        }
        return is;
    }

    @Override
    public Set<String> getResourceNames(String dirName) {
        TreeSet<String> resourceNames = new TreeSet<String>();
        for (ResourceBrowser rsBrowser : this.resourceInfoProviders) {
            if (this.generatorRegistry.isPathGenerated(dirName)) {
                ResourceGenerator rsGeneratorBrowser;
                if (!(rsBrowser instanceof ResourceGenerator) || !(rsGeneratorBrowser = (ResourceGenerator)((Object)rsBrowser)).getResolver().matchPath(dirName)) continue;
                resourceNames.addAll(rsBrowser.getResourceNames(dirName));
                break;
            }
            if (rsBrowser instanceof ResourceGenerator) continue;
            resourceNames.addAll(rsBrowser.getResourceNames(dirName));
            break;
        }
        return resourceNames;
    }

    @Override
    public boolean isDirectory(String resourceName) {
        boolean result = false;
        Iterator<ResourceBrowser> iterator = this.resourceInfoProviders.iterator();
        while (iterator.hasNext() && !result) {
            ResourceBrowser rsBrowser = iterator.next();
            if (this.generatorRegistry.isPathGenerated(resourceName)) {
                ResourceGenerator rsGeneratorBrowser;
                if (!(rsBrowser instanceof ResourceGenerator) || !(rsGeneratorBrowser = (ResourceGenerator)((Object)rsBrowser)).getResolver().matchPath(resourceName)) continue;
                result = rsBrowser.isDirectory(resourceName);
                continue;
            }
            if (rsBrowser instanceof ResourceGenerator) continue;
            result = rsBrowser.isDirectory(resourceName);
        }
        return result;
    }
}

