/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.servlet;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.jawr.web.context.ThreadLocalJawrContext;
import net.jawr.web.exception.InvalidPathException;
import net.jawr.web.exception.ResourceNotFoundException;
import net.jawr.web.resource.BinaryResourcesHandler;
import net.jawr.web.resource.bundle.CheckSumUtils;
import net.jawr.web.resource.bundle.IOUtils;
import net.jawr.web.resource.bundle.factory.util.PathNormalizer;
import net.jawr.web.resource.bundle.factory.util.PropertiesConfigHelper;
import net.jawr.web.resource.bundle.generator.GeneratorRegistry;
import net.jawr.web.resource.handler.bundle.ResourceBundleHandler;
import net.jawr.web.resource.handler.reader.ResourceReaderHandler;
import net.jawr.web.servlet.JawrRequestHandler;
import net.jawr.web.servlet.util.MIMETypesSupport;
import net.jawr.web.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JawrBinaryResourceRequestHandler
extends JawrRequestHandler {
    private static final long serialVersionUID = -8342090032443416738L;
    private static final Logger LOGGER = LoggerFactory.getLogger(JawrBinaryResourceRequestHandler.class);
    private static Pattern cacheBusterPattern = Pattern.compile("((([a-zA-Z0-9]+)_)?cb)[a-zA-Z0-9]+(/.*)$");
    private static final int GENERATED_BINARY_WEB_RESOURCE_PREFIX_INDEX = 3;
    private static final String CACHE_BUSTER_STANDARD_BINARY_WEB_RESOURCE_REPLACE_PATTERN = "$4";
    private static final String CACHE_BUSTER_GENERATED_BINARY_WEB_RESOURCE_REPLACE_PATTERN = "$3:$4";
    private ResourceReaderHandler rsReaderHandler;
    private ResourceBundleHandler rsBundleHandler;
    private BinaryResourcesHandler binaryRsHandler;
    private Properties bundleMapping;
    protected Map<Object, Object> binaryMimeTypeMap = MIMETypesSupport.getSupportedProperties(this);

    public JawrBinaryResourceRequestHandler(ServletContext context, ServletConfig config) throws ServletException {
        super(context, config);
        this.resourceType = "binary";
    }

    public JawrBinaryResourceRequestHandler(ServletContext context, Map<String, Object> initParams, Properties configProps) throws ServletException {
        super(context, initParams, configProps);
        this.resourceType = "binary";
    }

    @Override
    protected void initializeJawrConfig(Properties props) throws ServletException {
        if (this.binaryMimeTypeMap == null) {
            this.binaryMimeTypeMap = MIMETypesSupport.getSupportedProperties(this);
        }
        this.generatorRegistry = new GeneratorRegistry(this.resourceType);
        if (null != this.jawrConfig) {
            this.jawrConfig.invalidate();
        }
        this.jawrConfig = this.createJawrConfig(props);
        this.jawrConfig.setContext(this.servletContext);
        this.jawrConfig.setGeneratorRegistry(this.generatorRegistry);
        String mapping = (String)this.initParameters.get("mapping");
        if (null != mapping) {
            this.jawrConfig.setServletMapping(mapping);
        }
        this.initIllegalBundleRequestHandler();
        this.rsReaderHandler = this.initResourceReaderHandler();
        this.rsBundleHandler = this.initResourceBundleHandler();
        PropertiesConfigHelper propertiesHelper = new PropertiesConfigHelper(props, this.resourceType);
        for (String generatorClass : propertiesHelper.getCommonPropertyAsSet("custom.generators")) {
            this.generatorRegistry.registerGenerator(generatorClass);
        }
        this.bundleMapping = this.jawrConfig.getUseBundleMapping() ? this.rsBundleHandler.getJawrBundleMapping() : new Properties();
        this.binaryRsHandler = new BinaryResourcesHandler(this.jawrConfig, this.rsReaderHandler, this.rsBundleHandler);
        this.initMapping(this.binaryRsHandler);
        this.servletContext.setAttribute("net.jawr.web.resource.bundle.BINARY_CONTEXT_ATTRIBUTE", (Object)this.binaryRsHandler);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Configuration read. Current config:");
            LOGGER.debug(this.jawrConfig.toString());
        }
        if (this.jawrConfig.isDebugModeOn()) {
            LOGGER.warn("Jawr initialized in DEVELOPMENT MODE. Do NOT use this mode in production or integration servers. ");
        }
    }

    private void initMapping(BinaryResourcesHandler binaryRsHandler) {
        if (this.jawrConfig.getUseBundleMapping() && this.rsBundleHandler.isExistingMappingFile()) {
            for (Map.Entry<Object, Object> entry : this.bundleMapping.entrySet()) {
                binaryRsHandler.addMapping((String)entry.getKey(), entry.getValue().toString());
            }
        } else {
            String binaryResourcesDefinition = this.jawrConfig.getBinaryResourcesDefinition();
            if (binaryResourcesDefinition != null) {
                StringTokenizer tokenizer = new StringTokenizer(binaryResourcesDefinition, ",");
                while (tokenizer.hasMoreTokens()) {
                    String pathMapping = tokenizer.nextToken();
                    if (this.generatorRegistry.isGeneratedBinaryResource(pathMapping) && this.hasBinaryFileExtension(pathMapping)) {
                        this.addBinaryResourcePath(binaryRsHandler, pathMapping);
                        continue;
                    }
                    if (pathMapping.endsWith("/")) {
                        this.addItemsFromDir(binaryRsHandler, pathMapping, false);
                        continue;
                    }
                    if (pathMapping.endsWith("/**")) {
                        this.addItemsFromDir(binaryRsHandler, pathMapping.substring(0, pathMapping.lastIndexOf("**")), true);
                        continue;
                    }
                    if (this.hasBinaryFileExtension(pathMapping)) {
                        this.addBinaryResourcePath(binaryRsHandler, pathMapping);
                        continue;
                    }
                    LOGGER.warn("Wrong mapping [" + pathMapping + "] for image bundle. Please check configuration. ");
                }
            }
        }
        if (this.jawrConfig.getUseBundleMapping() && !this.rsBundleHandler.isExistingMappingFile()) {
            this.rsBundleHandler.storeJawrBundleMapping(this.bundleMapping);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Finish creation of map for image bundle");
        }
    }

    private void addBinaryResourcePath(BinaryResourcesHandler binRsHandler, String resourcePath) {
        try {
            String resultPath = CheckSumUtils.getCacheBustedUrl(resourcePath, this.rsReaderHandler, this.jawrConfig);
            binRsHandler.addMapping(resourcePath, resultPath);
            this.bundleMapping.put(resourcePath, resultPath);
        }
        catch (IOException e) {
            LOGGER.error("An exception occurs while defining the mapping for the file : " + resourcePath, (Throwable)e);
        }
        catch (ResourceNotFoundException e) {
            LOGGER.error("Impossible to define the checksum for the resource '" + resourcePath + "'. Unable to retrieve the content of the file.");
        }
    }

    private boolean hasBinaryFileExtension(String path) {
        boolean result = false;
        int extFileIdx = path.lastIndexOf(".");
        if (extFileIdx != -1 && extFileIdx + 1 < path.length()) {
            String extension = path.substring(extFileIdx + 1);
            result = this.binaryMimeTypeMap.containsKey(extension);
        }
        return result;
    }

    private void addItemsFromDir(BinaryResourcesHandler binRsHandler, String dirName, boolean addSubDirs) {
        Set<String> resources = this.rsReaderHandler.getResourceNames(dirName);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Adding " + resources.size() + " resources from path [" + dirName + "] to binary bundle");
        }
        GeneratorRegistry generatorRegistry = binRsHandler.getConfig().getGeneratorRegistry();
        ArrayList<String> folders = new ArrayList<String>();
        boolean generatedPath = generatorRegistry.isPathGenerated(dirName);
        for (String resourceName : resources) {
            String resourcePath = PathNormalizer.joinPaths(dirName, resourceName, generatedPath);
            if (this.hasBinaryFileExtension(resourceName)) {
                this.addBinaryResourcePath(binRsHandler, resourcePath);
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("Added to item path list:" + PathNormalizer.asPath(resourcePath));
                continue;
            }
            if (!addSubDirs) continue;
            try {
                if (!this.rsReaderHandler.isDirectory(resourcePath)) continue;
                folders.add(resourceName);
            }
            catch (InvalidPathException e) {
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("Enable to define if the following resource is a directory : " + PathNormalizer.asPath(resourcePath));
            }
        }
        if (addSubDirs) {
            for (String folderName : folders) {
                this.addItemsFromDir(binRsHandler, PathNormalizer.joinPaths(dirName, folderName), true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processRequest(String requestedPath, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            if (this.jawrConfig.getRefreshKey().length() > 0 && null != request.getParameter("refreshKey") && this.jawrConfig.getRefreshKey().equals(request.getParameter("refreshKey"))) {
                this.configChanged(this.propertiesSource.getConfigProperties());
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Request received for path:" + requestedPath);
            }
            if (this.handleSpecificRequest(requestedPath, requestedPath, request, response)) {
                return;
            }
            boolean validBundle = this.isValidBundle(requestedPath);
            response.setContentType(this.getContentType(requestedPath, request));
            boolean responseHeaderWritten = false;
            if (!this.jawrConfig.isDebugModeOn()) {
                if (validBundle && (null != request.getHeader("If-Modified-Since") || null != request.getHeader("If-None-Match"))) {
                    response.setStatus(304);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Returning 'not modified' header. ");
                    }
                    return;
                }
                if (validBundle) {
                    this.setResponseHeaders(response);
                } else {
                    responseHeaderWritten = this.illegalBundleRequestHandler.writeResponseHeader(requestedPath, request, response);
                    if (!responseHeaderWritten) {
                        this.setResponseHeaders(response);
                    }
                }
            }
            String filePath = this.getRealFilePath(requestedPath);
            try {
                if (this.isValidRequestedPath(filePath) && (validBundle || this.illegalBundleRequestHandler.canWriteContent(requestedPath, request))) {
                    this.writeContent(response, filePath);
                } else if (!responseHeaderWritten) {
                    LOGGER.error("Unable to load the image for the request URI : " + request.getRequestURI());
                    response.sendError(404);
                }
            }
            catch (Exception ex) {
                LOGGER.error("Unable to load the image for the request URI : " + request.getRequestURI(), (Throwable)ex);
                response.sendError(404);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("request succesfully attended");
            }
        }
        finally {
            ThreadLocalJawrContext.reset();
        }
    }

    @Override
    protected boolean isValidBundle(String requestedPath) {
        boolean validBundle = true;
        if (!this.jawrConfig.isDebugModeOn() && this.jawrConfig.isStrictMode()) {
            validBundle = this.binaryRsHandler.containsValidBundleHashcode(requestedPath);
        }
        return validBundle;
    }

    @Override
    protected boolean handleSpecificRequest(String requestedPath, String contentType, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        boolean processed = false;
        if (requestedPath == null) {
            response.sendError(404);
            processed = true;
        } else if (contentType == null) {
            response.sendError(404);
            processed = true;
        }
        return processed;
    }

    @Override
    protected String getContentType(String filePath, HttpServletRequest request) {
        String requestUri = request.getRequestURI();
        String extension = this.getExtension(filePath);
        if (extension == null) {
            LOGGER.error("No extension found for the request URI : " + requestUri);
            return null;
        }
        String contentType = (String)this.binaryMimeTypeMap.get(extension);
        if (contentType == null) {
            LOGGER.error("No image extension match the extension '" + extension + "' for the request URI : " + requestUri);
            return null;
        }
        return contentType;
    }

    @Override
    protected boolean isValidRequestedPath(String requestedPath) {
        boolean result = true;
        if (requestedPath.startsWith("/WEB-INF/") || requestedPath.startsWith("/META-INF/")) {
            result = false;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeContent(HttpServletResponse response, String fileName) throws IOException {
        ServletOutputStream os = response.getOutputStream();
        InputStream is = null;
        String resourceName = fileName;
        if (!this.jawrConfig.getGeneratorRegistry().isGeneratedBinaryResource(resourceName) && !resourceName.startsWith("/")) {
            resourceName = "/" + resourceName;
        }
        try {
            is = this.rsReaderHandler.getResourceAsStream(resourceName);
        }
        catch (ResourceNotFoundException e) {
            // empty catch block
        }
        if (is == null) {
            response.setStatus(404);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Received a request for a non existing binary resource: " + resourceName);
            }
            return;
        }
        try {
            IOUtils.copy(is, (OutputStream)os);
        }
        catch (EOFException eofex) {
            LOGGER.debug("Browser cut off response", (Throwable)eofex);
        }
        finally {
            IOUtils.close(is);
        }
    }

    private String getRealFilePath(String fileName) {
        String realFilePath = fileName;
        if (realFilePath.startsWith("/")) {
            realFilePath = realFilePath.substring(1);
        }
        Matcher matcher = cacheBusterPattern.matcher(realFilePath);
        StringBuffer result = new StringBuffer();
        if (matcher.find()) {
            matcher.appendReplacement(result, StringUtils.isEmpty(matcher.group(3)) ? CACHE_BUSTER_STANDARD_BINARY_WEB_RESOURCE_REPLACE_PATTERN : CACHE_BUSTER_GENERATED_BINARY_WEB_RESOURCE_REPLACE_PATTERN);
            return result.toString();
        }
        return realFilePath;
    }
}

