/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.servlet;

import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.jawr.web.cache.CacheManagerFactory;
import net.jawr.web.config.ConfigPropertyResolver;
import net.jawr.web.config.JawrConfig;
import net.jawr.web.config.jmx.JawrApplicationConfigManager;
import net.jawr.web.config.jmx.JawrConfigManager;
import net.jawr.web.config.jmx.JmxUtils;
import net.jawr.web.context.ThreadLocalJawrContext;
import net.jawr.web.exception.BundleDependencyException;
import net.jawr.web.exception.BundlingProcessException;
import net.jawr.web.exception.DuplicateBundlePathException;
import net.jawr.web.exception.ResourceNotFoundException;
import net.jawr.web.resource.BinaryResourcesHandler;
import net.jawr.web.resource.FileNameUtils;
import net.jawr.web.resource.bundle.IOUtils;
import net.jawr.web.resource.bundle.factory.PropertiesBasedBundlesHandlerFactory;
import net.jawr.web.resource.bundle.factory.PropsConfigPropertiesSource;
import net.jawr.web.resource.bundle.factory.util.ClassLoaderResourceUtils;
import net.jawr.web.resource.bundle.factory.util.ConfigChangeListener;
import net.jawr.web.resource.bundle.factory.util.ConfigChangeListenerThread;
import net.jawr.web.resource.bundle.factory.util.ConfigPropertiesSource;
import net.jawr.web.resource.bundle.factory.util.PathNormalizer;
import net.jawr.web.resource.bundle.factory.util.PropsFilePropertiesSource;
import net.jawr.web.resource.bundle.factory.util.ServletContextAware;
import net.jawr.web.resource.bundle.generator.GeneratorRegistry;
import net.jawr.web.resource.bundle.handler.ClientSideHandlerScriptRequestHandler;
import net.jawr.web.resource.bundle.handler.ResourceBundlesHandler;
import net.jawr.web.resource.handler.bundle.ResourceBundleHandler;
import net.jawr.web.resource.handler.bundle.ServletContextResourceBundleHandler;
import net.jawr.web.resource.handler.reader.ResourceReaderHandler;
import net.jawr.web.resource.handler.reader.ServletContextResourceReaderHandler;
import net.jawr.web.servlet.IllegalBundleRequestHandler;
import net.jawr.web.servlet.IllegalBundleRequestHandlerImpl;
import net.jawr.web.servlet.RendererRequestUtils;
import net.jawr.web.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JawrRequestHandler
implements ConfigChangeListener,
Serializable {
    private static final long serialVersionUID = 5762937687546882131L;
    private static final Logger LOGGER = LoggerFactory.getLogger(JawrRequestHandler.class);
    protected static final String CACHE_CONTROL_HEADER = "Cache-Control";
    protected static final String CACHE_CONTROL_VALUE = "public, max-age=315360000, post-check=315360000, pre-check=315360000";
    protected static final String LAST_MODIFIED_HEADER = "Last-Modified";
    protected static final String IF_MODIFIED_SINCE_HEADER = "If-Modified-Since";
    protected static final String IF_NONE_MATCH_HEADER = "If-None-Match";
    protected static final String LAST_MODIFIED_VALUE = "Sun, 06 Nov 2005 12:00:00 GMT";
    protected static final String ETAG_HEADER = "ETag";
    protected static final String ETAG_VALUE = "2740050219";
    protected static final String EXPIRES_HEADER = "Expires";
    protected static final String CONFIG_RELOAD_INTERVAL = "jawr.config.reload.interval";
    public static final String GENERATION_PARAM = "generationConfigParam";
    public static final String CLIENTSIDE_HANDLER_REQ_PATH = "/jawr_loader.js";
    private static final Pattern GENERATED_BINARY_RESOURCE_PATTERN = Pattern.compile("(url\\(([\"' ]*))(([a-zA-Z]+)(?! (http|data)):(/)?)([^\\)\"']*)([\"']?\\))");
    protected ResourceBundlesHandler bundlesHandler;
    protected ResourceReaderHandler rsReaderHandler;
    protected String contentType;
    protected String resourceType;
    protected ServletContext servletContext;
    protected Map<String, Object> initParameters;
    protected ConfigChangeListenerThread configChangeListenerThread;
    protected GeneratorRegistry generatorRegistry;
    protected JawrConfig jawrConfig;
    protected ConfigPropertiesSource propertiesSource;
    protected ConfigPropertyResolver configPropResolver;
    protected Properties overrideProperties;
    protected ClientSideHandlerScriptRequestHandler clientSideScriptRequestHandler;
    protected IllegalBundleRequestHandler illegalBundleRequestHandler;

    public JawrRequestHandler(ServletContext context, ServletConfig config) throws ServletException {
        this.initParameters = new HashMap<String, Object>();
        Enumeration params = config.getInitParameterNames();
        while (params.hasMoreElements()) {
            String param = (String)params.nextElement();
            this.initParameters.put(param, config.getInitParameter(param));
        }
        this.initParameters.put("handlerName", config.getServletName());
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Initializing jawr config for servlet named " + config.getServletName());
        }
        this.initRequestHandler(context, null);
    }

    public JawrRequestHandler(ServletContext context, Map<String, Object> initParams, Properties configProps) throws ServletException {
        this.initParameters = initParams;
        this.initRequestHandler(context, configProps);
    }

    private void initRequestHandler(ServletContext context, Properties configProps) throws ServletException {
        long initialTime = System.currentTimeMillis();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Initializing jawr config for request handler named " + this.getInitParameter("handlerName"));
        }
        this.servletContext = context;
        this.overrideProperties = configProps;
        this.resourceType = this.getInitParameter("type");
        String string = this.resourceType = null == this.resourceType ? "js" : this.resourceType;
        if (this.resourceType.equals("img")) {
            throw new BundlingProcessException("The resource type 'img' is not supported since the version 3.6. You should use the type 'binary' instead.");
        }
        if (!(this.resourceType.equals("js") || this.resourceType.equals("css") || this.resourceType.equals("binary"))) {
            throw new BundlingProcessException("Unknown resource Type:" + this.resourceType);
        }
        ConfigPropertiesSource propsSrc = this.initConfigPropertiesSource(context, configProps);
        Properties props = propsSrc.getConfigProperties();
        if (this.overrideProperties != null) {
            props.putAll((Map<?, ?>)this.overrideProperties);
        }
        this.propertiesSource = propsSrc;
        this.initConfigPropertyResolver(context);
        this.initializeJawrContext(props);
        if (!ThreadLocalJawrContext.isBundleProcessingAtBuildTime() && null != props.getProperty(CONFIG_RELOAD_INTERVAL)) {
            int interval = Integer.valueOf(props.getProperty(CONFIG_RELOAD_INTERVAL));
            LOGGER.warn("Jawr started with configuration auto reloading on. Be aware that a daemon thread will be checking for changes to configuration every " + interval + " seconds.");
            this.configChangeListenerThread = new ConfigChangeListenerThread(propsSrc, this.overrideProperties, this, (long)interval);
            this.configChangeListenerThread.start();
        }
        if (LOGGER.isInfoEnabled()) {
            long totaltime = System.currentTimeMillis() - initialTime;
            LOGGER.info("Init method succesful. jawr started in " + totaltime / 1000L + " seconds....");
        }
        ThreadLocalJawrContext.reset();
    }

    protected void initializeJawrContext(Properties props) throws ServletException {
        this.initializeJawrConfig(props);
        this.initializeApplicationCacheManager();
        JawrApplicationConfigManager appConfigMgr = this.initApplicationConfigManager();
        JmxUtils.initJMXBean(appConfigMgr, this.servletContext, this.resourceType, props.getProperty("jawr.jmx.mbean.prefix"));
    }

    private void initializeApplicationCacheManager() {
        CacheManagerFactory.resetCacheManager(this.jawrConfig, this.resourceType);
    }

    private JawrApplicationConfigManager initApplicationConfigManager() {
        JawrApplicationConfigManager appConfigMgr = (JawrApplicationConfigManager)this.servletContext.getAttribute("net.jawr.web.jmx.JAWR_APPLICATION_CONFIG_MANAGER");
        if (appConfigMgr == null) {
            appConfigMgr = new JawrApplicationConfigManager();
            this.servletContext.setAttribute("net.jawr.web.jmx.JAWR_APPLICATION_CONFIG_MANAGER", (Object)appConfigMgr);
        }
        JawrConfigManager configMgr = new JawrConfigManager(this, this.jawrConfig.getConfigProperties());
        if (this.resourceType.equals("js")) {
            appConfigMgr.setJsMBean(configMgr);
        } else if (this.resourceType.equals("css")) {
            appConfigMgr.setCssMBean(configMgr);
        } else {
            appConfigMgr.setBinaryMBean(configMgr);
        }
        return appConfigMgr;
    }

    private void initConfigPropertyResolver(ServletContext context) {
        String configPropertyResolverClass = this.getInitParameter("configPropertyResolverClass");
        this.configPropResolver = null;
        if (null != configPropertyResolverClass) {
            this.configPropResolver = (ConfigPropertyResolver)ClassLoaderResourceUtils.buildObjectInstance(configPropertyResolverClass);
            if (this.configPropResolver instanceof ServletContextAware) {
                ((ServletContextAware)((Object)this.configPropResolver)).setServletContext(context);
            }
        }
    }

    private ConfigPropertiesSource initConfigPropertiesSource(ServletContext context, Properties configProps) throws ServletException {
        String configLocation = this.getInitParameter("configLocation");
        String configPropsSourceClass = this.getInitParameter("configPropertiesSourceClass");
        if (null == configProps && null == configLocation && null == configPropsSourceClass) {
            throw new ServletException("Neither configLocation nor configPropertiesSourceClass init params were set. You must set at least the configLocation param. Please check your web.xml file");
        }
        ConfigPropertiesSource propsSrc = null;
        if (null != configPropsSourceClass) {
            propsSrc = (ConfigPropertiesSource)ClassLoaderResourceUtils.buildObjectInstance(configPropsSourceClass);
            if (propsSrc instanceof ServletContextAware) {
                ((ServletContextAware)((Object)propsSrc)).setServletContext(context);
            }
        } else {
            propsSrc = configLocation == null && configProps != null ? new PropsConfigPropertiesSource(configProps) : new PropsFilePropertiesSource();
        }
        if (propsSrc instanceof PropsFilePropertiesSource) {
            ((PropsFilePropertiesSource)propsSrc).setConfigLocation(configLocation);
        }
        return propsSrc;
    }

    private String getInitParameter(String paramName) {
        return (String)this.initParameters.get(paramName);
    }

    protected void initializeJawrConfig(Properties props) throws ServletException {
        BinaryResourcesHandler binaryRsHandler;
        this.generatorRegistry = new GeneratorRegistry(this.resourceType);
        if (null != this.jawrConfig) {
            this.jawrConfig.invalidate();
        }
        this.createJawrConfig(props);
        this.jawrConfig.setContext(this.servletContext);
        this.jawrConfig.setGeneratorRegistry(this.generatorRegistry);
        this.contentType = "text/";
        this.contentType = this.contentType + ("js".equals(this.resourceType) ? "javascript" : "css");
        this.contentType = this.contentType + "; charset=" + this.jawrConfig.getResourceCharset().name();
        String mapping = (String)this.initParameters.get("mapping");
        if (null != mapping) {
            this.jawrConfig.setServletMapping(mapping);
        }
        if (this.jawrConfig.isCssClasspathImageHandledByClasspathCss() && this.resourceType.equals("css") && (binaryRsHandler = (BinaryResourcesHandler)this.servletContext.getAttribute("net.jawr.web.resource.bundle.BINARY_CONTEXT_ATTRIBUTE")) == null) {
            LOGGER.error("You are using the CSS classpath image feature, but the JAWR Binary servlet is not yet initialized.\nThe JAWR Binary servlet must be initialized before the JAWR CSS servlet.\nPlease check you web application configuration.");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Configuration read. Current config:");
            LOGGER.debug(this.jawrConfig.toString());
        }
        this.initIllegalBundleRequestHandler();
        this.rsReaderHandler = this.initResourceReaderHandler();
        ResourceBundleHandler rsBundleHandler = this.initResourceBundleHandler();
        PropertiesBasedBundlesHandlerFactory factory = new PropertiesBasedBundlesHandlerFactory(props, this.resourceType, this.rsReaderHandler, rsBundleHandler, this.jawrConfig);
        try {
            this.bundlesHandler = factory.buildResourceBundlesHandler();
        }
        catch (DuplicateBundlePathException e) {
            throw new ServletException((Throwable)e);
        }
        catch (BundleDependencyException e) {
            throw new ServletException((Throwable)e);
        }
        if (this.resourceType.equals("js")) {
            this.servletContext.setAttribute("net.jawr.web.resource.bundle.JS_CONTEXT_ATTRIBUTE", (Object)this.bundlesHandler);
        } else {
            this.servletContext.setAttribute("net.jawr.web.resource.bundle.CSS_CONTEXT_ATTRIBUTE", (Object)this.bundlesHandler);
        }
        this.clientSideScriptRequestHandler = new ClientSideHandlerScriptRequestHandler(this.bundlesHandler, this.jawrConfig);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("content type set to: " + this.contentType);
        }
        if (this.jawrConfig.isDebugModeOn()) {
            LOGGER.warn("Jawr initialized in DEVELOPMENT MODE. Do NOT use this mode in production or integration servers. ");
        }
    }

    protected void initIllegalBundleRequestHandler() {
        String illegalBundleRequestandlerClassName = this.jawrConfig.getProperty("jawr.illegal.bundle.request.handler");
        this.illegalBundleRequestHandler = illegalBundleRequestandlerClassName != null ? (IllegalBundleRequestHandler)ClassLoaderResourceUtils.buildObjectInstance(illegalBundleRequestandlerClassName) : new IllegalBundleRequestHandlerImpl();
    }

    protected ResourceReaderHandler initResourceReaderHandler() {
        ServletContextResourceReaderHandler rsHandler = null;
        if (this.servletContext != null) {
            try {
                rsHandler = new ServletContextResourceReaderHandler(this.servletContext, this.jawrConfig, this.generatorRegistry);
            }
            catch (IOException e) {
                throw new BundlingProcessException(e);
            }
        }
        return rsHandler;
    }

    protected ResourceBundleHandler initResourceBundleHandler() {
        ServletContextResourceBundleHandler rsHandler = null;
        rsHandler = this.jawrConfig.getUseBundleMapping() && StringUtils.isNotEmpty(this.jawrConfig.getJawrWorkingDirectory()) ? new ServletContextResourceBundleHandler(this.servletContext, this.jawrConfig.getJawrWorkingDirectory(), this.jawrConfig.getResourceCharset(), this.jawrConfig.getGeneratorRegistry(), this.resourceType) : new ServletContextResourceBundleHandler(this.servletContext, this.jawrConfig.getResourceCharset(), this.jawrConfig.getGeneratorRegistry(), this.resourceType);
        return rsHandler;
    }

    protected JawrConfig createJawrConfig(Properties props) {
        this.jawrConfig = new JawrConfig(this.resourceType, props, this.configPropResolver);
        if (ThreadLocalJawrContext.isBundleProcessingAtBuildTime()) {
            this.jawrConfig.setUseBundleMapping(true);
            this.jawrConfig.setJawrWorkingDirectory(null);
        }
        return this.jawrConfig;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            String requestedPath = "".equals(this.jawrConfig.getServletMapping()) ? request.getServletPath() : request.getPathInfo();
            this.processRequest(requestedPath, request, response);
        }
        catch (Exception e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("ServletException : ", (Throwable)e);
            }
            throw new ServletException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processRequest(String requestedPath, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            String contentType;
            ThreadLocalJawrContext.setJawrConfigMgrObjectName(JmxUtils.getJawrConfigMBeanObjectName(request.getContextPath(), this.resourceType, this.jawrConfig.getProperty("jawr.jmx.mbean.prefix")));
            ThreadLocalJawrContext.setRequest(request.getRequestURL().toString());
            RendererRequestUtils.setRequestDebuggable(request, this.jawrConfig);
            if (this.jawrConfig.getRefreshKey().length() > 0 && null != request.getParameter("refreshKey") && this.jawrConfig.getRefreshKey().equals(request.getParameter("refreshKey"))) {
                this.configChanged(this.propertiesSource.getConfigProperties());
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Request received for path:" + requestedPath);
            }
            if (this.handleSpecificRequest(requestedPath, contentType = this.getContentType(requestedPath, request), request, response)) {
                return;
            }
            boolean validBundle = this.isValidBundle(requestedPath);
            this.processRequest(requestedPath, request, response, contentType, validBundle);
        }
        finally {
            ThreadLocalJawrContext.reset();
        }
    }

    protected boolean handleSpecificRequest(String requestedPath, String contentType, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        boolean processed = false;
        if (CLIENTSIDE_HANDLER_REQ_PATH.equals(requestedPath)) {
            this.clientSideScriptRequestHandler.handleClientSideHandlerRequest(request, response);
            processed = true;
        } else if ("css".equals(this.resourceType) && !"css".equals(this.getExtension(requestedPath)) && null == this.bundlesHandler.resolveBundleForPath(requestedPath)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Path '" + requestedPath + "' does not belong to a bundle. Forwarding request to the server. ");
            }
            request.getRequestDispatcher(requestedPath).forward((ServletRequest)request, (ServletResponse)response);
            processed = true;
        }
        return processed;
    }

    protected boolean isValidBundle(String requestedPath) {
        boolean validBundle = true;
        if (!this.jawrConfig.isDebugModeOn() && this.jawrConfig.isStrictMode()) {
            validBundle = this.bundlesHandler.containsValidBundleHashcode(requestedPath);
        }
        return validBundle;
    }

    protected void processRequest(String requestedPath, HttpServletRequest request, HttpServletResponse response, String contentType, boolean validBundle) throws IOException {
        boolean writeResponseHeader = false;
        if (this.jawrConfig.isDebugModeOn() && null != request.getParameter(GENERATION_PARAM)) {
            requestedPath = request.getParameter(GENERATION_PARAM);
        }
        if (!this.jawrConfig.isDebugModeOn()) {
            if (validBundle && (null != request.getHeader(IF_MODIFIED_SINCE_HEADER) || null != request.getHeader(IF_NONE_MATCH_HEADER))) {
                response.setStatus(304);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Returning 'not modified' header. ");
                }
                return;
            }
            if (validBundle) {
                this.setResponseHeaders(response);
            } else {
                writeResponseHeader = this.illegalBundleRequestHandler.writeResponseHeader(requestedPath, request, response);
                if (!writeResponseHeader) {
                    this.setResponseHeaders(response);
                }
            }
        }
        try {
            if (validBundle || this.illegalBundleRequestHandler.canWriteContent(requestedPath, request)) {
                response.setContentType(contentType);
                this.writeContent(requestedPath, request, response);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("request succesfully attended");
                }
            } else if (!writeResponseHeader) {
                this.logBundleNotFound(requestedPath);
                response.sendError(404);
            }
        }
        catch (EOFException eofex) {
            LOGGER.debug("Browser cut off response", (Throwable)eofex);
        }
        catch (ResourceNotFoundException e) {
            this.logBundleNotFound(requestedPath);
            response.setStatus(404);
            return;
        }
    }

    private void logBundleNotFound(String requestedPath) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Received a request for a non existing bundle: " + requestedPath);
        }
    }

    protected String getContentType(String requestedPath, HttpServletRequest request) {
        return this.contentType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void writeContent(String requestedPath, HttpServletRequest request, HttpServletResponse response) throws IOException, ResourceNotFoundException {
        int idx = requestedPath.indexOf("/gzip_");
        if (idx != -1) {
            requestedPath = "/" + requestedPath.substring(idx + "/gzip_".length(), requestedPath.length());
            if (!this.isValidRequestedPath(requestedPath)) throw new ResourceNotFoundException(requestedPath);
            response.setHeader("Content-Encoding", "gzip");
            this.bundlesHandler.streamBundleTo(requestedPath, (OutputStream)response.getOutputStream());
            return;
        } else {
            BinaryResourcesHandler imgRsHandler = (BinaryResourcesHandler)this.servletContext.getAttribute("net.jawr.web.resource.bundle.BINARY_CONTEXT_ATTRIBUTE");
            if (imgRsHandler != null && this.jawrConfig.isDebugModeOn() && this.resourceType.equals("css")) {
                this.handleGeneratedCssInDebugMode(requestedPath, request, response, imgRsHandler);
                return;
            } else {
                if (!this.isValidRequestedPath(requestedPath)) throw new ResourceNotFoundException(requestedPath);
                PrintWriter out = response.getWriter();
                this.bundlesHandler.writeBundleTo(requestedPath, out);
            }
        }
    }

    private void handleGeneratedCssInDebugMode(String requestedPath, HttpServletRequest request, HttpServletResponse response, BinaryResourcesHandler binaryRsHandler) throws ResourceNotFoundException, IOException {
        StringWriter writer = new StringWriter();
        Reader rd = this.rsReaderHandler.getResource(requestedPath);
        if (rd == null) {
            throw new ResourceNotFoundException(requestedPath);
        }
        IOUtils.copy(rd, (Writer)writer);
        String content = ((Object)writer).toString();
        String imageServletMapping = binaryRsHandler.getConfig().getServletMapping();
        if (imageServletMapping == null) {
            imageServletMapping = "";
        }
        String requestPath = this.getRequestPath(request);
        String relativeRootUrlPath = PathNormalizer.getRootRelativePath(requestPath);
        String replacementPattern = PathNormalizer.normalizePath("$1" + relativeRootUrlPath + imageServletMapping + "/$4_cbDebug/$7$8");
        Matcher matcher = GENERATED_BINARY_RESOURCE_PATTERN.matcher(content);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(result, replacementPattern);
        }
        matcher.appendTail(result);
        PrintWriter out = response.getWriter();
        ((Writer)out).write(result.toString());
    }

    protected boolean isValidRequestedPath(String requestedPath) {
        String extension;
        boolean result = true;
        if (!this.jawrConfig.isDebugModeOn() && requestedPath.startsWith("/WEB-INF/") || requestedPath.startsWith("/META-INF/")) {
            result = false;
        } else if (this.jawrConfig.isDebugModeOn() && !this.generatorRegistry.isPathGenerated(requestedPath) && !(extension = FileNameUtils.getExtension(requestedPath)).toLowerCase().equals(this.resourceType)) {
            result = false;
        }
        return result;
    }

    protected String getExtension(String requestedPath) {
        return FileNameUtils.getExtension(requestedPath);
    }

    private String getRequestPath(HttpServletRequest request) {
        String finalUrl = null;
        String servletPath = request.getServletPath();
        finalUrl = "".equals(this.jawrConfig.getServletMapping()) ? PathNormalizer.asPath(servletPath) : PathNormalizer.asPath(servletPath + request.getPathInfo());
        return finalUrl;
    }

    protected void setResponseHeaders(HttpServletResponse resp) {
        resp.setHeader(CACHE_CONTROL_HEADER, CACHE_CONTROL_VALUE);
        resp.setHeader(LAST_MODIFIED_HEADER, LAST_MODIFIED_VALUE);
        resp.setHeader(ETAG_HEADER, ETAG_VALUE);
        Calendar cal = Calendar.getInstance();
        cal.roll(1, 10);
        resp.setDateHeader(EXPIRES_HEADER, cal.getTimeInMillis());
    }

    public void destroy() {
        if (null != this.configChangeListenerThread) {
            this.configChangeListenerThread.stopPolling();
        }
        ThreadLocalJawrContext.reset();
    }

    @Override
    public synchronized void configChanged(Properties newConfig) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Reloading Jawr configuration");
        }
        try {
            ThreadLocalJawrContext.setJawrConfigMgrObjectName(JmxUtils.getMBeanObjectName(this.servletContext, this.resourceType, this.jawrConfig.getProperty("jawr.jmx.mbean.prefix")));
            Properties props = this.propertiesSource.getConfigProperties();
            if (this.overrideProperties != null) {
                props.putAll((Map<?, ?>)this.overrideProperties);
            }
            props.putAll((Map<?, ?>)newConfig);
            this.initializeJawrContext(props);
        }
        catch (Exception e) {
            throw new BundlingProcessException("Error reloading Jawr config: " + e.getMessage(), e);
        }
        finally {
            ThreadLocalJawrContext.reset();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Jawr configuration succesfully reloaded. ");
        }
    }
}

