/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.servlet.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import net.jawr.web.exception.BundlingProcessException;
import net.jawr.web.resource.bundle.IOUtils;
import net.jawr.web.resource.bundle.factory.util.ClassLoaderResourceUtils;

public class MIMETypesSupport {
    private static Properties supportedMIMETypes;
    private static final String MIME_PROPS_LOCATION = "net/jawr/web/resource/mimetypes.properties";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Map<Object, Object> getSupportedProperties(Object ref) {
        if (null != supportedMIMETypes) return supportedMIMETypes;
        Class<MIMETypesSupport> clazz = MIMETypesSupport.class;
        synchronized (MIMETypesSupport.class) {
            if (null != supportedMIMETypes) return supportedMIMETypes;
            InputStream is = null;
            try {
                is = ClassLoaderResourceUtils.getResourceAsStream(MIME_PROPS_LOCATION, ref);
                supportedMIMETypes = new Properties();
                supportedMIMETypes.load(is);
            }
            catch (FileNotFoundException e) {
                throw new BundlingProcessException("Error retrieving net/jawr/web/resource/mimetypes.properties. Please check your classloader settings");
            }
            catch (IOException e) {
                throw new BundlingProcessException("Error retrieving net/jawr/web/resource/mimetypes.properties. Please check your classloader settings");
            }
            finally {
                IOUtils.close(is);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return supportedMIMETypes;
        }
    }
}

