/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.taglib;

import java.io.IOException;
import java.io.Writer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import net.jawr.web.config.JawrConfig;
import net.jawr.web.context.ThreadLocalJawrContext;
import net.jawr.web.resource.bundle.handler.ResourceBundlesHandler;
import net.jawr.web.resource.bundle.renderer.BundleRenderer;
import net.jawr.web.resource.bundle.renderer.BundleRendererContext;
import net.jawr.web.servlet.RendererRequestUtils;
import net.jawr.web.util.StringUtils;

public abstract class AbstractResourceBundleTag
extends TagSupport {
    private static final long serialVersionUID = -9114179136913388470L;
    protected String src;
    protected String useRandomParam = null;

    public int doStartTag() throws JspException {
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        if (null == this.pageContext.getServletContext().getAttribute(this.getResourceHandlerAttributeName())) {
            throw new IllegalStateException("ResourceBundlesHandler not present in servlet context. Initialization of Jawr either failed or never occurred.");
        }
        ResourceBundlesHandler rsHandler = (ResourceBundlesHandler)this.pageContext.getServletContext().getAttribute(this.getResourceHandlerAttributeName());
        JawrConfig jawrConfig = rsHandler.getConfig();
        if (RendererRequestUtils.refreshConfigIfNeeded(request, jawrConfig)) {
            rsHandler = (ResourceBundlesHandler)this.pageContext.getServletContext().getAttribute(this.getResourceHandlerAttributeName());
            jawrConfig = rsHandler.getConfig();
        }
        Boolean useRandomFlag = null;
        if (StringUtils.isNotEmpty(this.useRandomParam)) {
            useRandomFlag = Boolean.valueOf(this.useRandomParam);
        }
        BundleRenderer renderer = this.createRenderer(rsHandler, useRandomFlag);
        RendererRequestUtils.setRequestDebuggable(request, jawrConfig);
        try {
            BundleRendererContext ctx = RendererRequestUtils.getBundleRendererContext(request, renderer);
            renderer.renderBundleLinks(this.src, ctx, (Writer)this.pageContext.getOut());
        }
        catch (IOException ex) {
            throw new JspException("Unexpected IOException when writing script tags for path " + this.src, (Throwable)ex);
        }
        finally {
            ThreadLocalJawrContext.reset();
        }
        return 0;
    }

    public void setSrc(String src) {
        this.src = src;
    }

    public void setUseRandomParam(String useRandomParam) {
        this.useRandomParam = useRandomParam;
    }

    protected abstract String getResourceHandlerAttributeName();

    protected abstract BundleRenderer createRenderer(ResourceBundlesHandler var1, Boolean var2);

    public void release() {
        this.src = null;
        this.useRandomParam = null;
        ThreadLocalJawrContext.reset();
    }
}

