/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.taglib;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import net.jawr.web.config.JawrConfig;
import net.jawr.web.exception.JawrLinkRenderingException;
import net.jawr.web.exception.ResourceNotFoundException;
import net.jawr.web.resource.BinaryResourcesHandler;
import net.jawr.web.resource.FileNameUtils;
import net.jawr.web.resource.bundle.CheckSumUtils;
import net.jawr.web.resource.bundle.IOUtils;
import net.jawr.web.resource.bundle.factory.util.PathNormalizer;
import net.jawr.web.servlet.RendererRequestUtils;
import net.jawr.web.servlet.util.MIMETypesSupport;
import net.jawr.web.util.Base64Encoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ImageTagUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImageTagUtils.class);
    private static final String BASE64_KEY_PREFIX = "base64#";
    private static final String DATA_PREFIX = "data:";

    public static String getImageUrl(String imgSrc, boolean base64, BinaryResourcesHandler binaryRsHandler, HttpServletRequest request, HttpServletResponse response) {
        String imgUrl = null;
        boolean isIE6orIE7 = RendererRequestUtils.isIE7orLess(request);
        imgUrl = !isIE6orIE7 && base64 ? ImageTagUtils.getBase64EncodedImage(imgSrc, binaryRsHandler, request) : ImageTagUtils.getImageUrl(imgSrc, binaryRsHandler, request, response);
        return imgUrl;
    }

    public static String getImageUrl(String imgSrc, BinaryResourcesHandler binaryRsHandler, HttpServletRequest request, HttpServletResponse response) {
        String imageServletMapping;
        if (binaryRsHandler == null) {
            throw new IllegalStateException("You are using a Jawr image tag while the Jawr Binary servlet has not been initialized. Initialization of Jawr Image servlet either failed or never occurred.");
        }
        String contextPath = request.getContextPath();
        imgSrc = ImageTagUtils.getFullImagePath(imgSrc, binaryRsHandler, request);
        String newUrl = binaryRsHandler.getCacheUrl(imgSrc);
        JawrConfig jawrConfig = binaryRsHandler.getConfig();
        if (newUrl == null) {
            try {
                newUrl = CheckSumUtils.getCacheBustedUrl(imgSrc, binaryRsHandler.getRsReaderHandler(), jawrConfig);
                binaryRsHandler.addMapping(imgSrc, newUrl);
            }
            catch (IOException e) {
                LOGGER.info("Unable to create the checksum for the image '" + imgSrc + "' while generating image tag.");
            }
            catch (ResourceNotFoundException e) {
                LOGGER.info("Unable to find the image '" + imgSrc + "' while generating image tag.");
            }
        }
        if (newUrl == null) {
            newUrl = imgSrc;
        }
        if ("".equals(imageServletMapping = jawrConfig.getServletMapping())) {
            if (newUrl.startsWith("/")) {
                newUrl = newUrl.substring(1);
            }
        } else {
            newUrl = PathNormalizer.joinDomainToPath(imageServletMapping, newUrl);
        }
        boolean sslRequest = RendererRequestUtils.isSslRequest(request);
        newUrl = RendererRequestUtils.getRenderedUrl(newUrl, jawrConfig, contextPath, sslRequest);
        return newUrl;
    }

    private static String getFullImagePath(String imgSrc, BinaryResourcesHandler binaryRsHandler, HttpServletRequest request) {
        int idx;
        String contextPath = request.getContextPath();
        if (!binaryRsHandler.getConfig().getGeneratorRegistry().isGeneratedBinaryResource(imgSrc) && !imgSrc.startsWith("/") && (idx = (imgSrc = PathNormalizer.concatWebPath(request.getRequestURI(), imgSrc)).indexOf(contextPath)) > -1) {
            imgSrc = imgSrc.substring(idx + contextPath.length());
        }
        return imgSrc;
    }

    public static String getImageUrl(String imgSrc, PageContext pageContext) {
        BinaryResourcesHandler imgRsHandler = (BinaryResourcesHandler)pageContext.getServletContext().getAttribute("net.jawr.web.resource.bundle.BINARY_CONTEXT_ATTRIBUTE");
        if (null == imgRsHandler) {
            throw new JawrLinkRenderingException("You are using a Jawr image tag while the Jawr Image servlet has not been initialized. Initialization of Jawr Image servlet either failed or never occurred.");
        }
        HttpServletResponse response = (HttpServletResponse)pageContext.getResponse();
        HttpServletRequest request = (HttpServletRequest)pageContext.getRequest();
        return ImageTagUtils.getImageUrl(imgSrc, imgRsHandler, request, response);
    }

    public static String getBase64EncodedImage(String imgSrc, BinaryResourcesHandler binaryRsHandler, HttpServletRequest request) {
        String encodedResult = null;
        if (null == binaryRsHandler) {
            throw new JawrLinkRenderingException("You are using a Jawr image tag while the Jawr Image servlet has not been initialized. Initialization of Jawr Image servlet either failed or never occurred.");
        }
        imgSrc = ImageTagUtils.getFullImagePath(imgSrc, binaryRsHandler, request);
        encodedResult = binaryRsHandler.getCacheUrl(BASE64_KEY_PREFIX + imgSrc);
        if (encodedResult == null) {
            try {
                String fileExtension = FileNameUtils.getExtension(imgSrc);
                String fileMimeType = (String)MIMETypesSupport.getSupportedProperties(ImageTagUtils.class).get(fileExtension);
                InputStream is = binaryRsHandler.getRsReaderHandler().getResourceAsStream(imgSrc);
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                IOUtils.copy(is, out, true);
                byte[] data = out.toByteArray();
                encodedResult = new String(Base64Encoder.encode(data));
                encodedResult = DATA_PREFIX + fileMimeType + ";base64," + encodedResult;
                binaryRsHandler.addMapping(BASE64_KEY_PREFIX + imgSrc, encodedResult);
            }
            catch (ResourceNotFoundException e) {
                LOGGER.warn("Unable to find the image '" + imgSrc + "' while generating image tag.");
            }
            catch (IOException e) {
                LOGGER.warn("Unable to copy the image '" + imgSrc + "' while generating image tag.");
            }
        }
        return encodedResult;
    }
}

