/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.taglib.jsf;

import java.io.IOException;
import java.io.Writer;
import javax.faces.component.UIOutput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.servlet.http.HttpServletRequest;
import net.jawr.web.config.JawrConfig;
import net.jawr.web.context.ThreadLocalJawrContext;
import net.jawr.web.resource.bundle.handler.ResourceBundlesHandler;
import net.jawr.web.resource.bundle.renderer.BundleRenderer;
import net.jawr.web.resource.bundle.renderer.BundleRendererContext;
import net.jawr.web.servlet.RendererRequestUtils;

public abstract class AbstractResourceBundleTag
extends UIOutput {
    protected BundleRenderer renderer;
    protected String useRandomParam = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void encodeBegin(FacesContext context) throws IOException {
        this.useRandomParam = (String)this.getAttributes().get("useRandomParam");
        String src = (String)this.getAttributes().get("src");
        ResponseWriter writer = context.getResponseWriter();
        HttpServletRequest request = (HttpServletRequest)context.getExternalContext().getRequest();
        ResourceBundlesHandler bundler = this.getResourceBundlesHandler(context);
        if (null == src) {
            throw new IllegalStateException("The src attribute is mandatory for this Jawr tag. ");
        }
        if (RendererRequestUtils.refreshConfigIfNeeded(request, bundler.getConfig())) {
            bundler = this.getResourceBundlesHandler(context);
        }
        if (null == this.renderer || !this.renderer.getBundler().getConfig().isValid()) {
            this.renderer = this.createRenderer(context);
        }
        RendererRequestUtils.setRequestDebuggable(request, this.renderer.getBundler().getConfig());
        try {
            BundleRendererContext ctx = RendererRequestUtils.getBundleRendererContext(request, this.renderer);
            this.renderer.renderBundleLinks(src, ctx, (Writer)writer);
        }
        finally {
            ThreadLocalJawrContext.reset();
        }
        super.encodeBegin(context);
    }

    protected boolean getUseRandomParamFlag(JawrConfig config) {
        boolean useRandomParamFlag = config.isDebugUseRandomParam();
        if (this.useRandomParam != null) {
            useRandomParamFlag = Boolean.parseBoolean(this.useRandomParam);
        }
        return useRandomParamFlag;
    }

    protected abstract BundleRenderer createRenderer(FacesContext var1);

    protected ResourceBundlesHandler getResourceBundlesHandler(FacesContext context) {
        Object handler = context.getExternalContext().getApplicationMap().get(this.getResourceBundlesHandlerAttributeName());
        if (null == handler) {
            throw new IllegalStateException("ResourceBundlesHandler not present in servlet context. Initialization of Jawr either failed or never occurred.");
        }
        ResourceBundlesHandler rsHandler = (ResourceBundlesHandler)handler;
        return rsHandler;
    }

    protected abstract String getResourceBundlesHandlerAttributeName();
}

