/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.util.bom;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.security.InvalidParameterException;
import net.jawr.web.util.bom.BOM;

public class UnicodeBOMReader
extends Reader {
    private final PushbackReader in;
    private final Charset charset;
    private final BOM bom;
    private boolean skipped = false;

    public UnicodeBOMReader(Reader reader, String strCharset) throws IOException {
        this(reader, Charset.forName(strCharset));
    }

    public UnicodeBOMReader(Reader reader, Charset pCharset) throws IOException {
        if (reader == null) {
            throw new InvalidParameterException("invalid reader: null is not allowed");
        }
        if (pCharset == null) {
            throw new InvalidParameterException("invalid charset: null is not allowed");
        }
        this.in = new PushbackReader(reader, 4);
        this.charset = pCharset;
        char[] chBom = new char[4];
        int read = this.in.read(chBom);
        CharBuffer cbuf = CharBuffer.wrap(chBom);
        ByteBuffer bbuf = this.charset.encode(cbuf);
        byte[] bom = bbuf.array();
        switch (read) {
            case 4: {
                if (bom[0] == -1 && bom[1] == -2 && bom[2] == 0 && bom[3] == 0) {
                    this.bom = BOM.UTF_32_LE;
                    break;
                }
                if (bom[0] == 0 && bom[1] == 0 && bom[2] == -2 && bom[3] == -1) {
                    this.bom = BOM.UTF_32_BE;
                    break;
                }
            }
            case 3: {
                if (bom[0] == -17 && bom[1] == -69 && bom[2] == -65) {
                    this.bom = BOM.UTF_8;
                    break;
                }
            }
            case 2: {
                if (bom[0] == -1 && bom[1] == -2) {
                    this.bom = BOM.UTF_16_LE;
                    break;
                }
                if (bom[0] == -2 && bom[1] == -1) {
                    this.bom = BOM.UTF_16_BE;
                    break;
                }
            }
            default: {
                this.bom = BOM.NONE;
            }
        }
        if (read > 0) {
            this.in.unread(chBom, 0, read);
        }
    }

    public final BOM getBOM() {
        return this.bom;
    }

    public final synchronized UnicodeBOMReader skipBOM() throws IOException {
        if (!this.skipped) {
            ByteBuffer bbuf = ByteBuffer.wrap(this.bom.getBytes());
            CharBuffer cbuf = this.charset.decode(bbuf);
            char[] bom = cbuf.array();
            int length = 0;
            for (int i = 0; i < bom.length && bom[i] != '\u0000'; ++i) {
                ++length;
            }
            this.in.skip(length);
            this.skipped = true;
        }
        return this;
    }

    public boolean hasBOM() {
        return !this.bom.equals(BOM.NONE);
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        return this.in.read(cbuf, off, len);
    }

    @Override
    public int read(CharBuffer target) throws IOException {
        return this.in.read(target);
    }

    @Override
    public int read() throws IOException {
        return this.in.read();
    }

    @Override
    public int read(char[] cbuf) throws IOException {
        return this.in.read(cbuf);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.in.skip(n);
    }

    @Override
    public boolean ready() throws IOException {
        return this.in.ready();
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        this.in.mark(readAheadLimit);
    }

    @Override
    public void reset() throws IOException {
        this.in.reset();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }
}

