/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.util.js;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import net.jawr.web.exception.BundlingProcessException;
import net.jawr.web.resource.bundle.IOUtils;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class RhinoEngine {
    private final ScriptableObject scope;

    public RhinoEngine() {
        Context context = Context.enter();
        context.setOptimizationLevel(-1);
        this.scope = context.initStandardObjects();
    }

    private void initContext() {
        if (Context.getCurrentContext() == null) {
            Context.enter();
        }
    }

    private Context getContext() {
        this.initContext();
        return Context.getCurrentContext();
    }

    public ScriptableObject getScope() {
        return this.scope;
    }

    public Object evaluate(String scriptName, Reader reader) {
        try {
            Object object = this.getContext().evaluateReader((Scriptable)this.scope, reader, scriptName, 0, null);
            return object;
        }
        catch (IOException e) {
            throw new BundlingProcessException("Error while evaluating script : " + scriptName, e);
        }
        finally {
            if (Context.getCurrentContext() != null) {
                Context.exit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object evaluate(String scriptName, String script) {
        try {
            Object object = this.getContext().evaluateString((Scriptable)this.scope, script, scriptName, 0, null);
            return object;
        }
        finally {
            if (Context.getCurrentContext() != null) {
                Context.exit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object evaluateString(Scriptable currentScope, String source, String scriptName) {
        try {
            Object object = this.getContext().evaluateString(currentScope, source, scriptName, 0, null);
            return object;
        }
        finally {
            if (Context.getCurrentContext() != null) {
                Context.exit();
            }
        }
    }

    public Object evaluate(String scriptName, InputStream stream) {
        try {
            Object object = this.getContext().evaluateReader((Scriptable)this.scope, (Reader)new InputStreamReader(stream), scriptName, 1, null);
            return object;
        }
        catch (IOException e) {
            throw new BundlingProcessException("Error while evaluating script : " + scriptName, e);
        }
        finally {
            IOUtils.close(stream);
        }
    }

    public RhinoEngine evaluateInChain(String scriptName, InputStream stream) {
        this.evaluate(scriptName, stream);
        return this;
    }

    public Scriptable newObject() {
        Scriptable obj = this.getContext().newObject((Scriptable)this.scope);
        obj.setParentScope((Scriptable)this.scope);
        return obj;
    }
}

