/**
 * Copyright 2010-2012 Ibrahim Chaehoi
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of the License at
 * 
 * 	http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software distributed under the
 * License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package net.jawr.web.resource.bundle.postprocess.impl.css.base64;

/**
 * This inner class contains a base64 encoded representation of a resource
 * 
 * @author Gerben Jorna
 * @author Ibrahim Chaehoi
 */
public class Base64EncodedResource {

	/** The id */
	private String id;
	
	/** The resource mime type */
	private String type;

	/** The base64 encoded representation of the resource */
	private StringBuffer base64Encoding;
	
	public String getId() {
		return id;
	}
	
	public void setId(String id) {
		this.id = id;
	}
	
	public void setId(int id) {
		setId("img" + Integer.toString(id));
	}
	
	public String getType() {
		return type;
	}
	
	public void setType(String type) {
		this.type = type;
	}
	
	public StringBuffer getBase64Encoding() {
		return base64Encoding;
	}
	
	public void setBase64Encoding(StringBuffer base64Encoding) {
		this.base64Encoding = base64Encoding;
	}
}
