/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.cache;

import net.jawr.web.cache.BasicCacheManager;
import net.jawr.web.cache.JawrCacheManager;
import net.jawr.web.config.JawrConfig;
import net.jawr.web.resource.bundle.factory.util.ClassLoaderResourceUtils;

public class CacheManagerFactory {
    private static final String CACHE_ATTR_PREFIX = "JAWR.";
    private static final String CACHE_ATTR_SUFFIX = ".CACHE.MANAGER";
    private static final String CACHE_PROPERTY_NAME = "jawr.cache.manager";

    public static JawrCacheManager getCacheManager(JawrConfig config, String resourceType) {
        String cacheMgrAttributeName = CACHE_ATTR_PREFIX + resourceType.toUpperCase() + CACHE_ATTR_SUFFIX;
        JawrCacheManager cacheManager = (JawrCacheManager)config.getContext().getAttribute(cacheMgrAttributeName);
        if (cacheManager == null) {
            String cacheManagerClass = config.getProperty(CACHE_PROPERTY_NAME, BasicCacheManager.class.getName());
            cacheManager = (JawrCacheManager)ClassLoaderResourceUtils.buildObjectInstance(cacheManagerClass, new Object[]{config});
            config.getContext().setAttribute(cacheMgrAttributeName, (Object)cacheManager);
        }
        return cacheManager;
    }

    public static synchronized JawrCacheManager resetCacheManager(JawrConfig config, String resourceType) {
        String cacheMgrAttributeName = CACHE_ATTR_PREFIX + resourceType.toUpperCase() + CACHE_ATTR_SUFFIX;
        JawrCacheManager cacheManager = (JawrCacheManager)config.getContext().getAttribute(cacheMgrAttributeName);
        if (cacheManager != null) {
            cacheManager.clear();
            config.getContext().removeAttribute(cacheMgrAttributeName);
        }
        return CacheManagerFactory.getCacheManager(config, resourceType);
    }
}

