/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.config.jmx;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.jawr.web.config.jmx.JawrApplicationConfigManagerMBean;
import net.jawr.web.config.jmx.JawrConfigManagerMBean;
import net.jawr.web.exception.JmxConfigException;
import net.jawr.web.util.PropertyUtils;

public class JawrApplicationConfigManager
implements JawrApplicationConfigManagerMBean {
    private static final String CHARSET_NAME = "charsetName";
    private static final String DEBUG_MODE_ON = "debugModeOn";
    private static final String DEBUG_OVERRIDE_KEY = "debugOverrideKey";
    private static final String GZIP_RESOURCES_FOR_IE_SIX_ON = "gzipResourcesForIESixOn";
    private static final String GZIP_RESOURCES_MODE_ON = "gzipResourcesModeOn";
    private static final String CONTEXT_PATH_OVERRIDE = "contextPathOverride";
    private static final String CONTEXT_PATH_SSL_OVERRIDE = "contextPathSslOverride";
    private static final String USE_CONTEXT_PATH_OVERRIDE_IN_DEBUG_MODE = "useContextPathOverrideInDebugMode";
    private static final String JAWR_WORKING_DIRECTORY = "jawrWorkingDirectory";
    private static final String USE_BUNDLE_MAPPING = "useBundleMapping";
    private static final String NOT_IDENTICAL_VALUES = "Value for this property are not identical";
    private static final String ERROR_VALUE = "An error occured while retrieving the value for this property";
    private JawrConfigManagerMBean jsMBean;
    private JawrConfigManagerMBean cssMBean;
    private JawrConfigManagerMBean binaryMBean;
    private final Set<String> debugSessionIdSet = new HashSet<String>();

    public void setJsMBean(JawrConfigManagerMBean jsMBean) {
        this.jsMBean = jsMBean;
    }

    public void setCssMBean(JawrConfigManagerMBean cssMBean) {
        this.cssMBean = cssMBean;
    }

    public void setBinaryMBean(JawrConfigManagerMBean binaryMBean) {
        this.binaryMBean = binaryMBean;
    }

    private List<JawrConfigManagerMBean> getInitializedConfigurationManagers() {
        ArrayList<JawrConfigManagerMBean> mBeans = new ArrayList<JawrConfigManagerMBean>();
        if (this.jsMBean != null) {
            mBeans.add(this.jsMBean);
        }
        if (this.cssMBean != null) {
            mBeans.add(this.cssMBean);
        }
        if (this.binaryMBean != null) {
            mBeans.add(this.binaryMBean);
        }
        return mBeans;
    }

    @Override
    public String getCharsetName() {
        return this.getStringValue(CHARSET_NAME);
    }

    @Override
    public String getDebugOverrideKey() {
        return this.getStringValue(DEBUG_OVERRIDE_KEY);
    }

    @Override
    public String getDebugModeOn() {
        return this.getStringValue(DEBUG_MODE_ON);
    }

    @Override
    public String getGzipResourcesForIESixOn() {
        return this.getStringValue(GZIP_RESOURCES_FOR_IE_SIX_ON);
    }

    @Override
    public String getGzipResourcesModeOn() {
        return this.getStringValue(GZIP_RESOURCES_MODE_ON);
    }

    @Override
    public String getContextPathOverride() {
        return this.getStringValue(CONTEXT_PATH_OVERRIDE);
    }

    @Override
    public String getContextPathSslOverride() {
        return this.getStringValue(CONTEXT_PATH_SSL_OVERRIDE);
    }

    @Override
    public String getUseContextPathOverrideInDebugMode() {
        return this.getStringValue(USE_CONTEXT_PATH_OVERRIDE_IN_DEBUG_MODE);
    }

    @Override
    public String getJawrWorkingDirectory() {
        return this.getStringValue(JAWR_WORKING_DIRECTORY);
    }

    @Override
    public String getUseBundleMapping() {
        return this.getStringValue(USE_BUNDLE_MAPPING);
    }

    @Override
    public void setCharsetName(String charsetName) {
        this.setStringValue(CHARSET_NAME, charsetName);
    }

    @Override
    public void setDebugModeOn(String debugMode) {
        this.setBooleanValue(DEBUG_MODE_ON, debugMode);
    }

    @Override
    public void setDebugOverrideKey(String debugOverrideKey) {
        this.setStringValue(DEBUG_OVERRIDE_KEY, debugOverrideKey);
    }

    @Override
    public void setGzipResourcesForIESixOn(String gzipResourcesForIESixOn) {
        this.setBooleanValue(GZIP_RESOURCES_FOR_IE_SIX_ON, gzipResourcesForIESixOn);
    }

    @Override
    public void setGzipResourcesModeOn(String gzipResourcesModeOn) {
        this.setBooleanValue(GZIP_RESOURCES_MODE_ON, gzipResourcesModeOn);
    }

    @Override
    public void setContextPathOverride(String contextPathOverride) {
        this.setStringValue(CONTEXT_PATH_OVERRIDE, contextPathOverride);
    }

    @Override
    public void setContextPathSslOverride(String contextPathSslOverride) {
        this.setStringValue(CONTEXT_PATH_SSL_OVERRIDE, contextPathSslOverride);
    }

    @Override
    public void setUseContextPathOverrideInDebugMode(String useContextPathOverrideInDebugMode) {
        this.setBooleanValue(USE_CONTEXT_PATH_OVERRIDE_IN_DEBUG_MODE, useContextPathOverrideInDebugMode);
    }

    @Override
    public void setJawrWorkingDirectory(String jawrWorkingDirectory) {
        this.setStringValue(JAWR_WORKING_DIRECTORY, jawrWorkingDirectory);
    }

    @Override
    public void setUseBundleMapping(String useBundleMapping) {
        this.setBooleanValue(USE_BUNDLE_MAPPING, useBundleMapping);
    }

    @Override
    public void refreshConfig() {
        if (this.jsMBean != null) {
            this.jsMBean.refreshConfig();
        }
        if (this.cssMBean != null) {
            this.cssMBean.refreshConfig();
        }
        if (this.binaryMBean != null) {
            this.binaryMBean.refreshConfig();
        }
    }

    @Override
    public void rebuildDirtyBundles() {
        if (this.jsMBean != null) {
            this.jsMBean.rebuildDirtyBundles();
        }
        if (this.cssMBean != null) {
            this.cssMBean.rebuildDirtyBundles();
        }
        if (this.binaryMBean != null) {
            this.binaryMBean.rebuildDirtyBundles();
        }
    }

    @Override
    public void addDebugSessionId(String sessionId) {
        this.debugSessionIdSet.add(sessionId);
    }

    @Override
    public void removeDebugSessionId(String sessionId) {
        this.debugSessionIdSet.remove(sessionId);
    }

    @Override
    public void removeAllDebugSessionId() {
        this.debugSessionIdSet.clear();
    }

    @Override
    public boolean isDebugSessionId(String sessionId) {
        return this.debugSessionIdSet.contains(sessionId);
    }

    public JawrConfigManagerMBean getConfigMgr(String resourceType) {
        JawrConfigManagerMBean configMgr = null;
        if (resourceType.equals("js")) {
            configMgr = this.jsMBean;
        } else if (resourceType.equals("css")) {
            configMgr = this.cssMBean;
        } else if (resourceType.equals("binary")) {
            configMgr = this.binaryMBean;
        }
        return configMgr;
    }

    public String getStringValue(String property) {
        List<JawrConfigManagerMBean> mBeans = this.getInitializedConfigurationManagers();
        try {
            if (mBeans.size() == 3) {
                if (this.areEquals(PropertyUtils.getProperty(this.jsMBean, property), PropertyUtils.getProperty(this.cssMBean, property), PropertyUtils.getProperty(this.binaryMBean, property))) {
                    return PropertyUtils.getProperty(this.jsMBean, property);
                }
                return NOT_IDENTICAL_VALUES;
            }
            if (mBeans.size() == 2) {
                JawrConfigManagerMBean mBean1 = mBeans.get(0);
                JawrConfigManagerMBean mBean2 = mBeans.get(1);
                if (this.areEquals(PropertyUtils.getProperty(mBean1, property), PropertyUtils.getProperty(mBean2, property))) {
                    return PropertyUtils.getProperty(mBean1, property);
                }
                return NOT_IDENTICAL_VALUES;
            }
            JawrConfigManagerMBean mBean1 = mBeans.get(0);
            return PropertyUtils.getProperty(mBean1, property);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            return ERROR_VALUE;
        }
    }

    public void setStringValue(String property, String value) {
        try {
            if (this.jsMBean != null) {
                PropertyUtils.setProperty(this.jsMBean, property, value);
            }
            if (this.cssMBean != null) {
                PropertyUtils.setProperty(this.cssMBean, property, value);
            }
            if (this.binaryMBean != null) {
                PropertyUtils.setProperty(this.binaryMBean, property, value);
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new JmxConfigException("Exception while setting the string value", e);
        }
    }

    public void setBooleanValue(String property, String value) {
        try {
            if (this.jsMBean != null) {
                PropertyUtils.setProperty(this.jsMBean, property, Boolean.valueOf(value));
            }
            if (this.cssMBean != null) {
                PropertyUtils.setProperty(this.cssMBean, property, Boolean.valueOf(value));
            }
            if (this.binaryMBean != null) {
                PropertyUtils.setProperty(this.binaryMBean, property, Boolean.valueOf(value));
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new JmxConfigException("Exception while setting the boolean value", e);
        }
    }

    public boolean areEquals(String str1, String str2) {
        return str1 == null && str2 == null || str1 != null && str2 != null && str1.equals(str2);
    }

    public boolean areEquals(String str1, String str2, String str3) {
        return str1 == null && str2 == null && str3 == null || str1 != null && str2 != null && str3 != null && str1.equals(str2) && str2.equals(str3);
    }
}

