/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.config.jmx;

import java.util.List;
import java.util.Properties;
import net.jawr.web.config.jmx.JawrConfigManagerMBean;
import net.jawr.web.servlet.JawrRequestHandler;

public class JawrConfigManager
implements JawrConfigManagerMBean {
    private final JawrRequestHandler requestHandler;
    private final Properties configProperties;

    public JawrConfigManager(JawrRequestHandler requestHandler, Properties properties) {
        this.requestHandler = requestHandler;
        this.configProperties = (Properties)properties.clone();
    }

    @Override
    public String getContextPathOverride() {
        return this.configProperties.getProperty("jawr.url.contextpath.override");
    }

    @Override
    public String getContextPathSslOverride() {
        return this.configProperties.getProperty("jawr.url.contextpath.ssl.override");
    }

    @Override
    public boolean getUseContextPathOverrideInDebugMode() {
        return Boolean.parseBoolean(this.configProperties.getProperty("jawr.url.contextpath.override.used.in.debug.mode"));
    }

    @Override
    public String getDebugOverrideKey() {
        return this.configProperties.getProperty("jawr.debug.overrideKey");
    }

    @Override
    public String getDwrMapping() {
        return this.configProperties.getProperty("jawr.dwr.mapping");
    }

    @Override
    public String getBinaryResourcesDefinition() {
        return this.configProperties.getProperty("jawr.binary.resources");
    }

    @Override
    public String getBinaryHashAlgorithm() {
        return this.configProperties.getProperty("jawr.binary.hash.algorithm");
    }

    @Override
    public boolean isDebugModeOn() {
        return Boolean.parseBoolean(this.configProperties.getProperty("jawr.debug.on"));
    }

    @Override
    public boolean isGzipResourcesForIESixOn() {
        return Boolean.parseBoolean(this.configProperties.getProperty("jawr.gzip.ie6.on"));
    }

    @Override
    public boolean isGzipResourcesModeOn() {
        return Boolean.parseBoolean(this.configProperties.getProperty("jawr.gzip.on"));
    }

    @Override
    public boolean isCssClasspathImageHandledByClasspathCss() {
        return Boolean.parseBoolean(this.configProperties.getProperty("jawr.css.classpath.handle.image"));
    }

    @Override
    public String getJawrWorkingDirectory() {
        return this.configProperties.getProperty("jawr.working.directory");
    }

    @Override
    public boolean isUseBundleMapping() {
        return Boolean.parseBoolean(this.configProperties.getProperty("jawr.use.bundle.mapping"));
    }

    @Override
    public void setCharsetName(String charsetName) {
        this.configProperties.setProperty("jawr.charset.name", charsetName);
    }

    @Override
    public String getCharsetName() {
        return this.configProperties.getProperty("jawr.charset.name");
    }

    @Override
    public void setContextPathOverride(String contextPathOverride) {
        this.configProperties.setProperty("jawr.url.contextpath.override", contextPathOverride);
    }

    @Override
    public void setContextPathSslOverride(String contextPathOverride) {
        this.configProperties.setProperty("jawr.url.contextpath.ssl.override", contextPathOverride);
    }

    @Override
    public void setUseContextPathOverrideInDebugMode(boolean useContextPathOverrideInDebugMode) {
        this.configProperties.setProperty("jawr.url.contextpath.override.used.in.debug.mode", Boolean.toString(useContextPathOverrideInDebugMode));
    }

    @Override
    public void setCssLinkFlavor(String cssLinkFlavor) {
        this.configProperties.setProperty("jawr.csslinks.flavor", cssLinkFlavor);
    }

    @Override
    public String getCssLinkFlavor() {
        return this.configProperties.getProperty("jawr.csslinks.flavor");
    }

    @Override
    public void setDebugModeOn(boolean debugMode) {
        this.configProperties.setProperty("jawr.debug.on", Boolean.toString(debugMode));
    }

    @Override
    public void setDebugOverrideKey(String debugOverrideKey) {
        this.configProperties.setProperty("jawr.debug.overrideKey", debugOverrideKey);
    }

    @Override
    public void setDwrMapping(String dwrMapping) {
        this.configProperties.setProperty("jawr.dwr.mapping", dwrMapping);
    }

    @Override
    public void setGzipResourcesForIESixOn(boolean gzipResourcesForIESixOn) {
        this.configProperties.setProperty("jawr.gzip.ie6.on", Boolean.toString(gzipResourcesForIESixOn));
    }

    @Override
    public void setGzipResourcesModeOn(boolean gzipResourcesModeOn) {
        this.configProperties.setProperty("jawr.gzip.on", Boolean.toString(gzipResourcesModeOn));
    }

    @Override
    public void setBinaryResourcesDefinition(String imageResourcesDefinition) {
        this.configProperties.setProperty("jawr.binary.resources", imageResourcesDefinition);
    }

    @Override
    public void setBinaryHashAlgorithm(String imageHashAlgorithm) {
        this.configProperties.setProperty("jawr.binary.hash.algorithm", imageHashAlgorithm);
    }

    @Override
    public void setCssClasspathImageHandledByClasspathCss(boolean useClasspathCssImgServlet) {
        this.configProperties.setProperty("jawr.css.classpath.handle.image", Boolean.toString(useClasspathCssImgServlet));
    }

    @Override
    public void setJawrWorkingDirectory(String jawrWorkingDirectory) {
        this.configProperties.setProperty("jawr.working.directory", jawrWorkingDirectory);
    }

    @Override
    public void setUseBundleMapping(boolean usBundleMapping) {
        this.configProperties.setProperty("jawr.use.bundle.mapping", Boolean.toString(usBundleMapping));
    }

    @Override
    public void refreshConfig() {
        this.requestHandler.configChanged(this.configProperties);
    }

    @Override
    public void rebuildDirtyBundles() {
        this.requestHandler.rebuildDirtyBundles();
    }

    @Override
    public List<String> getDirtyBundleNames() {
        return this.requestHandler.getDirtyBundleNames();
    }
}

