/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.minification;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.jawr.web.resource.bundle.factory.util.RegexUtil;

public class CSSMinifier {
    private static final String COMMENT_REGEX = "(/\\*(?!(!))[^*]*\\*+([^/][^*]*\\*+)*/)";
    private static final String LICENCE_REGEX = "(/\\*(?=(!))[^*]*\\*+([^/][^*]*\\*+)*/)";
    private static final String QUOTED_CONTENT_REGEX = "([\"']).*?\\1";
    private static final String STRING_PLACEHOLDER = "______'JAWR_STRING'______";
    private static final String LICENCE_PLACEHOLDER = "______'LICENCE'______";
    private static final String RULES_REGEX = "([^\\{\\}]*)(\\{[^\\{\\}]*})";
    private static final String NEW_LINE_TABS_REGEX = "\\r|\\n|\\t|\\f";
    private static final String SPACES_REGEX = "(?ims)(\\s*\\{\\s*)|(\\s+\\-\\s+)|(\\s+\\+\\s+)|(\\s+\\*\\s+)|(\\s+\\/\\s+)|(\\s*\\}\\s*)|((?<!\\sand)\\s*\\(\\s*)|(\\s*;\\s*)|(\\s*:\\s*)|(\\s*\\))|( +)";
    private static final Pattern COMMENTS_PATTERN = Pattern.compile("(/\\*(?!(!))[^*]*\\*+([^/][^*]*\\*+)*/)", 32);
    private static final Pattern LICENCE_PATTERN = Pattern.compile("(/\\*(?=(!))[^*]*\\*+([^/][^*]*\\*+)*/)", 32);
    private static final Pattern SPACES_PATTERN = Pattern.compile("(?ims)(\\s*\\{\\s*)|(\\s+\\-\\s+)|(\\s+\\+\\s+)|(\\s+\\*\\s+)|(\\s+\\/\\s+)|(\\s*\\}\\s*)|((?<!\\sand)\\s*\\(\\s*)|(\\s*;\\s*)|(\\s*:\\s*)|(\\s*\\))|( +)", 32);
    private static final Pattern QUOTED_CONTENT_PATTERN = Pattern.compile("([\"']).*?\\1", 32);
    private static final Pattern RULES_PATTERN = Pattern.compile("([^\\{\\}]*)(\\{[^\\{\\}]*})", 32);
    private static final Pattern NEW_LINES_TAB_PATTERN = Pattern.compile("\\r|\\n|\\t|\\f", 32);
    private static final Pattern STRING_PLACEHOLDER_PATTERN = Pattern.compile("______'JAWR_STRING'______", 32);
    private static final Pattern LICENCE_PLACEHOLDER_PATTERN = Pattern.compile("______'LICENCE'______", 32);
    private static final String SPACE = " ";
    private static final String BRACKET_OPEN = "{";
    private static final String BRACKET_CLOSE = "}";
    private static final String PAREN_OPEN = "(";
    private static final String PAREN_CLOSE = ")";
    private static final String PLUS_OPERATOR = "+";
    private static final String PLUS_OPERATOR_REPLACEMENT = " + ";
    private static final String MINUS_OPERATOR = "-";
    private static final String MINUS_OPERATOR_REPLACEMENT = " - ";
    private static final String MULTIPLICATION_OPERATOR = "*";
    private static final String MULTIPLICATION_OPERATOR_REPLACEMENT = " * ";
    private static final String DIVISION_OPERATOR = "/";
    private static final String DIVISION_OPERATOR_REPLACEMENT = " / ";
    private static final String COLON = ":";
    private static final String SEMICOLON = ";";
    private boolean keepLicence;

    public CSSMinifier() {
        this(false);
    }

    public CSSMinifier(boolean keepLicence) {
        this.keepLicence = keepLicence;
    }

    public StringBuffer minifyCSS(StringBuffer data) {
        String compressed = COMMENTS_PATTERN.matcher(data.toString()).replaceAll("");
        final ArrayList licences = new ArrayList();
        Matcher licenceMatcher = LICENCE_PATTERN.matcher(compressed);
        compressed = new MatcherProcessorCallback(){

            @Override
            String matchCallback(Matcher matcher) {
                String match = matcher.group();
                String replacement = "";
                if (CSSMinifier.this.keepLicence) {
                    licences.add(match);
                    replacement = CSSMinifier.LICENCE_PLACEHOLDER;
                }
                return replacement;
            }
        }.processWithMatcher(licenceMatcher);
        final ArrayList strings = new ArrayList();
        Matcher stringMatcher = QUOTED_CONTENT_PATTERN.matcher(compressed);
        compressed = new MatcherProcessorCallback(){

            @Override
            String matchCallback(Matcher matcher) {
                String match = matcher.group();
                strings.add(match);
                return CSSMinifier.STRING_PLACEHOLDER;
            }
        }.processWithMatcher(stringMatcher);
        Matcher rulesmatcher = RULES_PATTERN.matcher(compressed);
        compressed = new MatcherProcessorCallback(){

            @Override
            String matchCallback(Matcher matcher) {
                String match = matcher.group(1);
                String spaced = NEW_LINES_TAB_PATTERN.matcher(match).replaceAll(CSSMinifier.SPACE).trim();
                return spaced + matcher.group(2);
            }
        }.processWithMatcher(rulesmatcher);
        compressed = NEW_LINES_TAB_PATTERN.matcher(compressed).replaceAll(SPACE);
        Matcher matcher = SPACES_PATTERN.matcher(compressed);
        compressed = new MatcherProcessorCallback(){

            @Override
            String matchCallback(Matcher matcher) {
                String replacement = CSSMinifier.SPACE;
                String match = matcher.group();
                if (match.contains(CSSMinifier.PLUS_OPERATOR)) {
                    replacement = CSSMinifier.PLUS_OPERATOR_REPLACEMENT;
                } else if (match.contains(CSSMinifier.MINUS_OPERATOR)) {
                    replacement = CSSMinifier.MINUS_OPERATOR_REPLACEMENT;
                } else if (match.contains(CSSMinifier.MULTIPLICATION_OPERATOR)) {
                    replacement = CSSMinifier.MULTIPLICATION_OPERATOR_REPLACEMENT;
                } else if (match.contains(CSSMinifier.DIVISION_OPERATOR)) {
                    replacement = CSSMinifier.DIVISION_OPERATOR_REPLACEMENT;
                } else if (match.contains(CSSMinifier.PLUS_OPERATOR)) {
                    replacement = CSSMinifier.PLUS_OPERATOR_REPLACEMENT;
                } else if (match.contains(CSSMinifier.BRACKET_OPEN)) {
                    replacement = CSSMinifier.BRACKET_OPEN;
                } else if (match.contains(CSSMinifier.BRACKET_CLOSE)) {
                    replacement = CSSMinifier.BRACKET_CLOSE;
                } else if (match.contains(CSSMinifier.PAREN_OPEN)) {
                    replacement = CSSMinifier.PAREN_OPEN;
                } else if (match.contains(CSSMinifier.COLON)) {
                    replacement = CSSMinifier.COLON;
                } else if (match.contains(CSSMinifier.SEMICOLON)) {
                    replacement = CSSMinifier.SEMICOLON;
                } else if (match.contains(CSSMinifier.PAREN_CLOSE)) {
                    replacement = CSSMinifier.PAREN_CLOSE;
                }
                return replacement;
            }
        }.processWithMatcher(matcher);
        Matcher restoreStringMatcher = STRING_PLACEHOLDER_PATTERN.matcher(compressed);
        final Iterator itStr = strings.iterator();
        compressed = new MatcherProcessorCallback(){

            @Override
            String matchCallback(Matcher matcher) {
                String replacement = (String)itStr.next();
                return replacement;
            }
        }.processWithMatcher(restoreStringMatcher);
        Matcher restoreLicenceMatcher = LICENCE_PLACEHOLDER_PATTERN.matcher(compressed);
        final Iterator itLicence = licences.iterator();
        compressed = new MatcherProcessorCallback(){

            @Override
            String matchCallback(Matcher matcher) {
                String replacement = (String)itLicence.next();
                return replacement;
            }
        }.processWithMatcher(restoreLicenceMatcher);
        return new StringBuffer(compressed);
    }

    public abstract class MatcherProcessorCallback {
        String processWithMatcher(Matcher matcher) {
            StringBuffer sb = new StringBuffer();
            while (matcher.find()) {
                matcher.appendReplacement(sb, RegexUtil.adaptReplacementToMatcher(this.matchCallback(matcher)));
            }
            matcher.appendTail(sb);
            return sb.toString();
        }

        abstract String matchCallback(Matcher var1);
    }
}

