/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.jawr.web.config.JawrConfig;
import net.jawr.web.exception.ResourceNotFoundException;
import net.jawr.web.resource.bundle.CheckSumUtils;
import net.jawr.web.resource.bundle.factory.util.PathNormalizer;
import net.jawr.web.resource.bundle.handler.BundleHashcodeType;
import net.jawr.web.resource.handler.bundle.ResourceBundleHandler;
import net.jawr.web.resource.handler.reader.ResourceReaderHandler;

public class BinaryResourcesHandler {
    private final Map<String, String> binaryResourcePathMap = new ConcurrentHashMap<String, String>();
    private final JawrConfig jawrConfig;
    private final ResourceReaderHandler rsHandler;
    private final ResourceBundleHandler rsBundleHandler;

    public BinaryResourcesHandler(JawrConfig config, ResourceReaderHandler rsHandler, ResourceBundleHandler rsBundleHandler) {
        this.jawrConfig = config;
        this.rsHandler = rsHandler;
        this.rsBundleHandler = rsBundleHandler;
    }

    public JawrConfig getConfig() {
        return this.jawrConfig;
    }

    public ResourceReaderHandler getRsReaderHandler() {
        return this.rsHandler;
    }

    public ResourceBundleHandler getRsBundleHandler() {
        return this.rsBundleHandler;
    }

    public Map<String, String> getBinaryPathMap() {
        return this.binaryResourcePathMap;
    }

    public void addMapping(String binaryUrl, String cacheUrl) {
        this.binaryResourcePathMap.put(binaryUrl, cacheUrl);
    }

    public String getCacheUrl(String binaryUrl) {
        return this.binaryResourcePathMap.get(binaryUrl);
    }

    public void clear() {
        this.binaryResourcePathMap.clear();
    }

    public BundleHashcodeType getBundleHashcodeType(String requestedPath) {
        if (this.binaryResourcePathMap.containsValue(requestedPath)) {
            return BundleHashcodeType.VALID_HASHCODE;
        }
        BundleHashcodeType bundleHashcodeType = BundleHashcodeType.UNKNOW_BUNDLE;
        String[] resourceInfo = PathNormalizer.extractBinaryResourceInfo(requestedPath);
        String binaryRequest = resourceInfo[0];
        if (resourceInfo[1] != null) {
            try {
                String cacheBustedPath = CheckSumUtils.getCacheBustedUrl(binaryRequest, this.getRsReaderHandler(), this.jawrConfig);
                this.addMapping(binaryRequest, cacheBustedPath);
                bundleHashcodeType = requestedPath.equals(cacheBustedPath) ? BundleHashcodeType.VALID_HASHCODE : BundleHashcodeType.INVALID_HASHCODE;
            }
            catch (IOException | ResourceNotFoundException e) {
                // empty catch block
            }
        }
        return bundleHashcodeType;
    }
}

