/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle;

import java.util.List;
import net.jawr.web.resource.bundle.InclusionPattern;
import net.jawr.web.resource.bundle.JoinableResourceBundle;
import net.jawr.web.resource.bundle.JoinableResourceBundleImpl;
import net.jawr.web.resource.bundle.generator.GeneratorRegistry;
import net.jawr.web.resource.bundle.mappings.BundlePathMappingBuilder;
import net.jawr.web.resource.bundle.mappings.CompositeBundlePathMappingBuilder;
import net.jawr.web.resource.handler.reader.ResourceReaderHandler;

public class CompositeResourceBundle
extends JoinableResourceBundleImpl {
    private final List<JoinableResourceBundle> childBundles;

    public CompositeResourceBundle(String id, String name, List<JoinableResourceBundle> childBundles, InclusionPattern inclusionPattern, ResourceReaderHandler resourceHandler, String bundlePrefix, String fileExtension, GeneratorRegistry generatorRegistry) {
        super(id, name, bundlePrefix, fileExtension, inclusionPattern, resourceHandler, generatorRegistry);
        this.childBundles = childBundles;
        this.bundlePathMappingBuilder = this.createBundlePathMappingBuilder(fileExtension, resourceHandler, generatorRegistry);
        this.bundlePathMapping = this.bundlePathMappingBuilder.build(null);
        for (JoinableResourceBundle child : this.childBundles) {
            if (null == child.getBundlePostProcessor()) {
                child.setBundlePostProcessor(this.getBundlePostProcessor());
            }
            if (null != child.getUnitaryPostProcessor()) continue;
            child.setUnitaryPostProcessor(this.getUnitaryPostProcessor());
        }
    }

    @Override
    protected BundlePathMappingBuilder createBundlePathMappingBuilder(String fileExtension, ResourceReaderHandler resourceReaderHandler, GeneratorRegistry generatorRegistry) {
        return new CompositeBundlePathMappingBuilder(this, fileExtension, generatorRegistry, resourceReaderHandler);
    }

    @Override
    public boolean isComposite() {
        return true;
    }

    public List<JoinableResourceBundle> getChildBundles() {
        return this.childBundles;
    }

    @Override
    public String toString() {
        return "CompositeResourceBundleImpl [id=" + this.getId() + ", name=" + this.getName() + "]";
    }
}

