/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import net.jawr.web.resource.bundle.InclusionPattern;
import net.jawr.web.resource.bundle.JoinableResourceBundle;
import net.jawr.web.resource.bundle.factory.util.PathNormalizer;
import net.jawr.web.resource.bundle.generator.GeneratorRegistry;
import net.jawr.web.resource.bundle.iterator.BundlePath;
import net.jawr.web.resource.bundle.mappings.BundlePathMapping;
import net.jawr.web.resource.bundle.mappings.BundlePathMappingBuilder;
import net.jawr.web.resource.bundle.mappings.FilePathMapping;
import net.jawr.web.resource.bundle.mappings.PathMapping;
import net.jawr.web.resource.bundle.postprocess.ResourceBundlePostProcessor;
import net.jawr.web.resource.bundle.variant.VariantSet;
import net.jawr.web.resource.bundle.variant.VariantUtils;
import net.jawr.web.resource.handler.reader.ResourceReaderHandler;
import net.jawr.web.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JoinableResourceBundleImpl
implements JoinableResourceBundle {
    private static final Logger LOGGER = LoggerFactory.getLogger(JoinableResourceBundleImpl.class);
    private String name;
    private String id;
    private InclusionPattern inclusionPattern;
    private GeneratorRegistry generatorRegistry;
    protected BundlePathMappingBuilder bundlePathMappingBuilder;
    protected BundlePathMapping bundlePathMapping;
    private boolean dirty;
    private String bundlePrefix;
    private String urlPrefix;
    private String explorerConditionalExpression;
    private String alternateProductionURL;
    private String debugURL;
    private Map<String, String> prefixMap;
    protected Map<String, VariantSet> variants;
    protected List<String> variantKeys;
    protected List<JoinableResourceBundle> dependencies;
    private ResourceBundlePostProcessor unitaryPostProcessor;
    private ResourceBundlePostProcessor bundlePostProcessor;

    public JoinableResourceBundleImpl(String id, String name, String bundlePrefix, String fileExtension, InclusionPattern inclusionPattern, ResourceReaderHandler resourceReaderHandler, GeneratorRegistry generatorRegistry) {
        this.inclusionPattern = inclusionPattern;
        this.generatorRegistry = generatorRegistry;
        this.id = generatorRegistry.isPathGenerated(id) ? id : PathNormalizer.asPath(id);
        this.name = name;
        if (bundlePrefix != null) {
            this.bundlePrefix = PathNormalizer.asDirPath(bundlePrefix);
        }
        this.bundlePathMappingBuilder = this.createBundlePathMappingBuilder(fileExtension, resourceReaderHandler, generatorRegistry);
        this.bundlePathMapping = new BundlePathMapping(this);
        this.prefixMap = new ConcurrentHashMap<String, String>();
    }

    public JoinableResourceBundleImpl(String id, String name, String bundlePrefix, String fileExtension, InclusionPattern inclusionPattern, List<String> pathMappings, ResourceReaderHandler resourceReaderHandler, GeneratorRegistry generatorRegistry) {
        this(id, name, bundlePrefix, fileExtension, inclusionPattern, resourceReaderHandler, generatorRegistry);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Adding mapped files for bundle " + id);
        }
        this.bundlePathMappingBuilder = this.createBundlePathMappingBuilder(fileExtension, resourceReaderHandler, generatorRegistry);
        this.bundlePathMapping = this.bundlePathMappingBuilder.build(pathMappings);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Added " + this.bundlePathMapping.getItemPathList().size() + " files and " + this.bundlePathMapping.getLicensesPathList().size() + " licenses for the bundle " + id);
        }
    }

    protected BundlePathMappingBuilder createBundlePathMappingBuilder(String fileExtension, ResourceReaderHandler resourceReaderHandler, GeneratorRegistry generatorRegistry) {
        return new BundlePathMappingBuilder(this, fileExtension, generatorRegistry, resourceReaderHandler);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getBundlePrefix() {
        return this.bundlePrefix;
    }

    @Override
    public boolean isComposite() {
        return false;
    }

    @Override
    public ResourceBundlePostProcessor getUnitaryPostProcessor() {
        return this.unitaryPostProcessor;
    }

    @Override
    public void setUnitaryPostProcessor(ResourceBundlePostProcessor unitaryPostProcessor) {
        this.unitaryPostProcessor = unitaryPostProcessor;
    }

    @Override
    public ResourceBundlePostProcessor getBundlePostProcessor() {
        return this.bundlePostProcessor;
    }

    @Override
    public void setBundlePostProcessor(ResourceBundlePostProcessor bundlePostProcessor) {
        this.bundlePostProcessor = bundlePostProcessor;
    }

    @Override
    public String getExplorerConditionalExpression() {
        return this.explorerConditionalExpression;
    }

    public void setExplorerConditionalExpression(String explorerConditionalExpression) {
        this.explorerConditionalExpression = explorerConditionalExpression;
    }

    @Override
    public void setVariants(Map<String, VariantSet> variantSets) {
        if (variantSets != null) {
            this.variants = new TreeMap<String, VariantSet>(variantSets);
            this.variantKeys = VariantUtils.getAllVariantKeys(this.variants);
        }
    }

    @Override
    public Map<String, VariantSet> getVariants() {
        return this.variants;
    }

    @Override
    public List<String> getVariantKeys() {
        return this.variantKeys;
    }

    @Override
    public String getAlternateProductionURL() {
        return this.alternateProductionURL;
    }

    public void setAlternateProductionURL(String alternateProductionURL) {
        this.alternateProductionURL = alternateProductionURL;
    }

    @Override
    public String getDebugURL() {
        return this.debugURL;
    }

    public void setDebugURL(String debugURL) {
        this.debugURL = debugURL;
    }

    @Override
    public boolean belongsToBundle(String itemPath) {
        boolean belongsToBundle = false;
        for (BundlePath path : this.bundlePathMapping.getItemPathList()) {
            if (!path.getPath().equals(itemPath)) continue;
            belongsToBundle = true;
            break;
        }
        if (!belongsToBundle) {
            for (BundlePath path : this.bundlePathMapping.getItemDebugPathList()) {
                if (!path.getPath().equals(itemPath)) continue;
                belongsToBundle = true;
                break;
            }
        }
        return belongsToBundle;
    }

    @Override
    public InclusionPattern getInclusionPattern() {
        return this.inclusionPattern;
    }

    @Override
    public void setMappings(List<String> pathMappings) {
        this.bundlePathMapping = this.bundlePathMappingBuilder.build(pathMappings);
    }

    @Override
    public List<PathMapping> getMappings() {
        return this.bundlePathMapping.getPathMappings();
    }

    @Override
    public List<BundlePath> getItemPathList() {
        return this.bundlePathMapping.getItemPathList();
    }

    @Override
    public List<BundlePath> getItemDebugPathList() {
        return this.bundlePathMapping.getItemDebugPathList();
    }

    @Override
    public List<FilePathMapping> getFilePathMappings() {
        return this.bundlePathMapping.getFilePathMappings();
    }

    @Override
    public List<FilePathMapping> getLinkedFilePathMappings() {
        return this.bundlePathMapping.getLinkedFilePathMappings();
    }

    @Override
    public void setLinkedFilePathMappings(List<FilePathMapping> mappings) {
        this.bundlePathMapping.setLinkedFilePathMappings(mappings);
    }

    @Override
    public List<BundlePath> getItemDebugPathList(Map<String, String> variants) {
        if (StringUtils.isNotEmpty(this.debugURL)) {
            return this.bundlePathMapping.getItemDebugPathList();
        }
        return this.getItemPathList(this.bundlePathMapping.getItemDebugPathList(), variants);
    }

    @Override
    public List<BundlePath> getItemPathList(Map<String, String> variants) {
        return this.getItemPathList(this.bundlePathMapping.getItemPathList(), variants);
    }

    private List<BundlePath> getItemPathList(List<BundlePath> itemList, Map<String, String> variants) {
        if (variants == null || variants.isEmpty()) {
            return itemList;
        }
        ArrayList<BundlePath> rets = new ArrayList<BundlePath>();
        for (BundlePath bundlePath : itemList) {
            String path = bundlePath.getPath();
            if (this.generatorRegistry.isPathGenerated(path)) {
                Set<String> variantTypes = this.generatorRegistry.getGeneratedResourceVariantTypes(path);
                String variantKey = VariantUtils.getVariantKey(variants, variantTypes);
                if (StringUtils.isNotEmpty(variantKey)) {
                    rets.add(new BundlePath(bundlePath.getBundlePrefix(), VariantUtils.getVariantBundleName(path, variantKey, true)));
                    continue;
                }
                rets.add(bundlePath);
                continue;
            }
            rets.add(bundlePath);
        }
        return rets;
    }

    @Override
    public void setDependencies(List<JoinableResourceBundle> dependencies) {
        this.dependencies = dependencies;
    }

    @Override
    public List<JoinableResourceBundle> getDependencies() {
        return this.dependencies;
    }

    @Override
    public Set<String> getLicensesPathList() {
        return this.bundlePathMapping.getLicensesPathList();
    }

    public void setLicensesPathList(Set<String> licencePathList) {
        this.bundlePathMapping.setLicensesPathList(licencePathList);
    }

    @Override
    public String getURLPrefix(Map<String, String> variants) {
        String key;
        if (null == this.urlPrefix) {
            throw new IllegalStateException("The bundleDataHashCode must be set before accessing the url prefix.");
        }
        if (variants != null && !variants.isEmpty() && StringUtils.isNotEmpty(key = this.getAvailableVariant(variants))) {
            return this.prefixMap.get(key) + "." + key + "/";
        }
        return this.urlPrefix + "/";
    }

    @Override
    public String getBundleDataHashCode(String variantKey) {
        if (StringUtils.isEmpty(variantKey)) {
            return this.urlPrefix;
        }
        return this.prefixMap.get(variantKey);
    }

    @Override
    public void setBundleDataHashCode(String variantKey, String bundleDataHashCode) {
        String prefix = bundleDataHashCode;
        if (StringUtils.isEmpty(variantKey)) {
            this.urlPrefix = prefix;
        } else {
            this.prefixMap.put(variantKey, prefix);
        }
    }

    private String getAvailableVariant(Map<String, String> curVariants) {
        String variantKey = null;
        if (this.variants != null) {
            Map<String, String> availableVariants = this.generatorRegistry.getAvailableVariantMap(this.variants, curVariants);
            variantKey = VariantUtils.getVariantKey(availableVariants);
        }
        return variantKey;
    }

    public String toString() {
        return "JoinableResourceBundleImpl [id=" + this.id + ", name=" + this.name + "]";
    }

    @Override
    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void resetBundleMapping() {
        this.variants = null;
        this.variantKeys = null;
        this.bundlePathMapping = this.bundlePathMappingBuilder.build();
    }
}

