/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.jawr.web.resource.bundle.CompositeResourceBundle;
import net.jawr.web.resource.bundle.InclusionPattern;
import net.jawr.web.resource.bundle.JoinableResourceBundle;
import net.jawr.web.resource.bundle.mappings.FilePathMapping;
import net.jawr.web.resource.bundle.mappings.PathMapping;
import net.jawr.web.resource.bundle.postprocess.ChainedResourceBundlePostProcessor;
import net.jawr.web.resource.bundle.variant.VariantSet;
import net.jawr.web.util.StringUtils;

public class JoinableResourceBundlePropertySerializer {
    public static final String LAST_MODIFIED_SEPARATOR = "#";

    public static void serializeInProperties(JoinableResourceBundle bundle, String type, Properties props) {
        Set<String> licensesPathList;
        List<JoinableResourceBundle> dependencies;
        List<FilePathMapping> filePathList;
        List<PathMapping> pathMappings;
        String bundleHashcode;
        Map<String, VariantSet> variants;
        String bundleName = bundle.getName();
        String prefix = "jawr." + type + "." + "bundle." + bundleName;
        InclusionPattern inclusion = bundle.getInclusionPattern();
        if (StringUtils.isNotEmpty(bundle.getId())) {
            props.put(prefix + ".id", bundle.getId());
        }
        if (StringUtils.isNotEmpty(bundle.getBundlePrefix())) {
            props.put(prefix + ".bundle.prefix", bundle.getBundlePrefix());
        }
        props.put(prefix + ".id", bundle.getId());
        if (inclusion.isGlobal()) {
            props.put(prefix + ".global", Boolean.toString(inclusion.isGlobal()));
        }
        if (inclusion.getInclusionOrder() != 0) {
            props.put(prefix + ".order", Integer.toString(inclusion.getInclusionOrder()));
        }
        if (inclusion.isIncludeOnlyOnDebug()) {
            props.put(prefix + ".debugonly", Boolean.toString(inclusion.isIncludeOnlyOnDebug()));
        }
        if (inclusion.isExcludeOnDebug()) {
            props.put(prefix + ".debugnever", Boolean.toString(inclusion.isExcludeOnDebug()));
        }
        if (StringUtils.isNotEmpty(bundle.getExplorerConditionalExpression())) {
            props.put(prefix + ".ieonly.condition", bundle.getExplorerConditionalExpression());
        }
        if (StringUtils.isNotEmpty(bundle.getAlternateProductionURL())) {
            props.put(prefix + ".productionURL", bundle.getAlternateProductionURL());
        }
        if (StringUtils.isNotEmpty(bundle.getDebugURL())) {
            props.put(prefix + ".debugURL", bundle.getDebugURL());
        }
        if (bundle.getBundlePostProcessor() != null) {
            props.put(prefix + ".bundlepostprocessors", JoinableResourceBundlePropertySerializer.getBundlePostProcessorsName((ChainedResourceBundlePostProcessor)bundle.getBundlePostProcessor()));
        }
        if (bundle.getUnitaryPostProcessor() != null) {
            props.put(prefix + ".filepostprocessors", JoinableResourceBundlePropertySerializer.getBundlePostProcessorsName((ChainedResourceBundlePostProcessor)bundle.getUnitaryPostProcessor()));
        }
        if ((variants = bundle.getVariants()) != null && !variants.isEmpty()) {
            String serializedVariants = JoinableResourceBundlePropertySerializer.serializeVariantSets(variants);
            if (StringUtils.isNotEmpty(serializedVariants)) {
                props.put(prefix + ".variants", serializedVariants);
            }
            List<String> variantKeys = bundle.getVariantKeys();
            for (String variantKey : variantKeys) {
                if (!StringUtils.isNotEmpty(variantKey)) continue;
                props.put(prefix + ".bundleHashcode." + variantKey, bundle.getBundleDataHashCode(variantKey));
            }
        }
        if ((bundleHashcode = bundle.getBundleDataHashCode(null)) != null) {
            props.put(prefix + ".bundleHashcode", bundleHashcode);
        }
        if ((pathMappings = bundle.getMappings()) != null && !pathMappings.isEmpty()) {
            props.put(prefix + ".mappings", JoinableResourceBundlePropertySerializer.getCommaSeparatedStringForPathMapping(pathMappings));
        }
        if ((filePathList = bundle.getFilePathMappings()) != null && !filePathList.isEmpty()) {
            props.put(prefix + ".mappings.files", JoinableResourceBundlePropertySerializer.getCommaSeparatedStringForFilePath(filePathList));
        }
        if ((filePathList = bundle.getLinkedFilePathMappings()) != null && !filePathList.isEmpty()) {
            props.put(prefix + ".mappings.linked.files", JoinableResourceBundlePropertySerializer.getCommaSeparatedStringForFilePath(filePathList));
        }
        if ((dependencies = bundle.getDependencies()) != null && !dependencies.isEmpty()) {
            List<String> dependenciesBundleName = JoinableResourceBundlePropertySerializer.getBundleNames(dependencies);
            props.put(prefix + ".dependencies", JoinableResourceBundlePropertySerializer.getCommaSeparatedString(dependenciesBundleName));
        }
        if ((licensesPathList = bundle.getLicensesPathList()) != null && !licensesPathList.isEmpty()) {
            props.put(prefix + ".licencePathList", JoinableResourceBundlePropertySerializer.getCommaSeparatedString(licensesPathList));
        }
        if (bundle.isComposite()) {
            props.put(prefix + ".composite", Boolean.TRUE.toString());
            List<JoinableResourceBundle> children = ((CompositeResourceBundle)bundle).getChildBundles();
            List<String> bundleNames = JoinableResourceBundlePropertySerializer.getBundleNames(children);
            props.put(prefix + ".child.names", JoinableResourceBundlePropertySerializer.getCommaSeparatedString(bundleNames));
            for (JoinableResourceBundle childBundle : children) {
                JoinableResourceBundlePropertySerializer.serializeInProperties(childBundle, type, props);
            }
        }
    }

    private static String serializeVariantSets(Map<String, VariantSet> map) {
        StringBuilder result = new StringBuilder();
        for (Map.Entry<String, VariantSet> entry : map.entrySet()) {
            result.append(entry.getKey()).append(":");
            VariantSet variantSet = entry.getValue();
            result.append(variantSet.getDefaultVariant()).append(":");
            result.append(JoinableResourceBundlePropertySerializer.getCommaSeparatedString(variantSet));
            result.append(";");
        }
        return result.toString();
    }

    private static List<String> getBundleNames(List<JoinableResourceBundle> bundles) {
        ArrayList<String> bundleNames = new ArrayList<String>();
        Iterator<JoinableResourceBundle> iterator = bundles.iterator();
        while (iterator.hasNext()) {
            bundleNames.add(iterator.next().getName());
        }
        return bundleNames;
    }

    private static String getCommaSeparatedString(Collection<String> coll) {
        StringBuilder buffer = new StringBuilder();
        Iterator<String> eltIterator = coll.iterator();
        while (eltIterator.hasNext()) {
            String elt = eltIterator.next();
            buffer.append(elt);
            if (!eltIterator.hasNext()) continue;
            buffer.append(",");
        }
        return buffer.toString();
    }

    private static String getCommaSeparatedStringForPathMapping(Collection<PathMapping> coll) {
        StringBuilder buffer = new StringBuilder();
        Iterator<PathMapping> eltIterator = coll.iterator();
        while (eltIterator.hasNext()) {
            PathMapping mapping = eltIterator.next();
            buffer.append(mapping.getPath());
            if (mapping.isRecursive()) {
                buffer.append("**");
            }
            if (!eltIterator.hasNext()) continue;
            buffer.append(",");
        }
        return buffer.toString();
    }

    private static String getCommaSeparatedStringForFilePath(Collection<FilePathMapping> mappings) {
        StringBuilder buffer = new StringBuilder();
        Iterator<FilePathMapping> eltIterator = mappings.iterator();
        while (eltIterator.hasNext()) {
            FilePathMapping mapping = eltIterator.next();
            buffer.append(mapping.getPath()).append(LAST_MODIFIED_SEPARATOR).append(mapping.getLastModified());
            if (!eltIterator.hasNext()) continue;
            buffer.append(",");
        }
        return buffer.toString();
    }

    private static String getBundlePostProcessorsName(ChainedResourceBundlePostProcessor processor) {
        String bundlePostProcessor = "";
        if (processor != null) {
            bundlePostProcessor = processor.getId();
        }
        return bundlePostProcessor;
    }
}

