/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle.css;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.jawr.web.resource.bundle.factory.util.PathNormalizer;

public class CssDebugUrlRewriter {
    private static final Pattern GENERATED_BINARY_RESOURCE_PATTERN = Pattern.compile("(url\\(([\"' ]*))(?!(http|https|data|mhtml))(([a-zA-Z]+):(/)?)([^\\)\"']*)([\"']?\\))");

    public static String rewriteGeneratedBinaryResourceDebugUrl(String requestPath, String content, String binaryServletMapping) {
        if (binaryServletMapping == null) {
            binaryServletMapping = "";
        }
        String relativeRootUrlPath = PathNormalizer.getRootRelativePath(requestPath);
        String replacementPattern = PathNormalizer.normalizePath("$1" + relativeRootUrlPath + binaryServletMapping + "/$5_cbDebug/$7$8");
        Matcher matcher = GENERATED_BINARY_RESOURCE_PATTERN.matcher(content);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(result, replacementPattern);
        }
        matcher.appendTail(result);
        return result.toString();
    }
}

