/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle.factory;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.jawr.web.config.JawrConfig;
import net.jawr.web.exception.BundleDependencyException;
import net.jawr.web.exception.BundlingProcessException;
import net.jawr.web.exception.DuplicateBundlePathException;
import net.jawr.web.resource.FileNameUtils;
import net.jawr.web.resource.bundle.CheckSumUtils;
import net.jawr.web.resource.bundle.CompositeResourceBundle;
import net.jawr.web.resource.bundle.DebugInclusion;
import net.jawr.web.resource.bundle.InclusionPattern;
import net.jawr.web.resource.bundle.JoinableResourceBundle;
import net.jawr.web.resource.bundle.JoinableResourceBundleImpl;
import net.jawr.web.resource.bundle.factory.FullMappingPropertiesBasedBundlesHandlerFactory;
import net.jawr.web.resource.bundle.factory.global.postprocessor.BasicGlobalPostprocessorChainFactory;
import net.jawr.web.resource.bundle.factory.global.postprocessor.GlobalPostProcessingContext;
import net.jawr.web.resource.bundle.factory.global.postprocessor.GlobalPostprocessorChainFactory;
import net.jawr.web.resource.bundle.factory.global.preprocessor.BasicGlobalPreprocessorChainFactory;
import net.jawr.web.resource.bundle.factory.global.preprocessor.GlobalPreprocessingContext;
import net.jawr.web.resource.bundle.factory.global.preprocessor.GlobalPreprocessorChainFactory;
import net.jawr.web.resource.bundle.factory.mapper.OrphanResourceBundlesMapper;
import net.jawr.web.resource.bundle.factory.mapper.ResourceBundleDirMapper;
import net.jawr.web.resource.bundle.factory.postprocessor.CSSPostProcessorChainFactory;
import net.jawr.web.resource.bundle.factory.postprocessor.JSPostProcessorChainFactory;
import net.jawr.web.resource.bundle.factory.postprocessor.PostProcessorChainFactory;
import net.jawr.web.resource.bundle.factory.util.PathNormalizer;
import net.jawr.web.resource.bundle.factory.util.ResourceBundleDefinition;
import net.jawr.web.resource.bundle.global.processor.GlobalProcessor;
import net.jawr.web.resource.bundle.handler.CachedResourceBundlesHandler;
import net.jawr.web.resource.bundle.handler.ResourceBundlesHandler;
import net.jawr.web.resource.bundle.handler.ResourceBundlesHandlerImpl;
import net.jawr.web.resource.bundle.lifecycle.BundlingProcessLifeCycleListener;
import net.jawr.web.resource.bundle.postprocess.ResourceBundlePostProcessor;
import net.jawr.web.resource.handler.bundle.ResourceBundleHandler;
import net.jawr.web.resource.handler.reader.ResourceReaderHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundlesHandlerFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(BundlesHandlerFactory.class);
    private boolean useCacheManager = true;
    private String baseDir = "";
    private String resourceType;
    private String fileExtension;
    private String globalPostProcessorKeys;
    private String unitPostProcessorKeys;
    private String globalCompositePostProcessorKeys;
    private String unitCompositePostProcessorKeys;
    private String resourceTypePreprocessorKeys;
    private String resourceTypePostprocessorKeys;
    private Set<ResourceBundleDefinition> bundleDefinitions;
    private Set<ResourceBundleDefinition> bundleDefinitionsWithDependencies;
    private ResourceReaderHandler resourceReaderHandler;
    private ResourceBundleHandler resourceBundleHandler;
    private PostProcessorChainFactory chainFactory;
    private GlobalPreprocessorChainFactory resourceTypePreprocessorChainFactory;
    private GlobalPostprocessorChainFactory resourceTypePostprocessorChainFactory;
    private boolean useSingleResourceFactory = false;
    private String singleFileBundleName;
    private boolean useDirMapperFactory = false;
    private Set<String> excludedDirMapperDirs;
    private final JawrConfig jawrConfig;
    private Map<String, String> customPostprocessors;
    private Map<String, String> customGlobalPreprocessors;
    private Map<String, String> customGlobalPostprocessors;
    private boolean scanForOrphans = true;

    public BundlesHandlerFactory(JawrConfig config) {
        this.jawrConfig = config;
    }

    public ResourceBundlesHandler buildResourceBundlesHandler() throws DuplicateBundlePathException, BundleDependencyException {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Building resources handler... ");
        }
        if (null == this.jawrConfig) {
            throw new IllegalStateException("Must set the JawrConfig for this factory before invoking buildResourceBundlesHandler(). ");
        }
        if (null == this.resourceReaderHandler) {
            throw new IllegalStateException("Must set the resourceHandler for this factory before invoking buildResourceBundlesHandler(). ");
        }
        if (this.useSingleResourceFactory && null == this.singleFileBundleName) {
            throw new IllegalStateException("Must set the singleFileBundleName when useSingleResourceFactory is set to true. Please check the documentation. ");
        }
        this.initCustomPostProcessors();
        ArrayList<JoinableResourceBundle> resourceBundles = new ArrayList<JoinableResourceBundle>();
        if (this.isProcessingBundleFromCacheMapping()) {
            this.initResourceBundlesFromFullMapping(resourceBundles);
        } else {
            this.initResourceBundles(resourceBundles);
        }
        ResourceBundlePostProcessor processor = null;
        processor = null == this.globalPostProcessorKeys ? this.chainFactory.buildDefaultProcessorChain() : this.chainFactory.buildPostProcessorChain(this.globalPostProcessorKeys);
        ResourceBundlePostProcessor unitProcessor = null;
        unitProcessor = null == this.unitPostProcessorKeys ? this.chainFactory.buildDefaultUnitProcessorChain() : this.chainFactory.buildPostProcessorChain(this.unitPostProcessorKeys);
        ResourceBundlePostProcessor compositeBundleProcessor = null;
        compositeBundleProcessor = null == this.globalCompositePostProcessorKeys ? this.chainFactory.buildDefaultCompositeProcessorChain() : this.chainFactory.buildPostProcessorChain(this.globalCompositePostProcessorKeys);
        ResourceBundlePostProcessor compositeUnitProcessor = null;
        compositeUnitProcessor = null == this.unitCompositePostProcessorKeys ? this.chainFactory.buildDefaultUnitCompositeProcessorChain() : this.chainFactory.buildPostProcessorChain(this.unitCompositePostProcessorKeys);
        if (null != this.customGlobalPreprocessors) {
            this.resourceTypePreprocessorChainFactory.setCustomGlobalProcessors(this.customGlobalPreprocessors);
        }
        GlobalProcessor<GlobalPreprocessingContext> resourceTypePreprocessor = null;
        resourceTypePreprocessor = null == this.resourceTypePreprocessorKeys ? this.resourceTypePreprocessorChainFactory.buildDefaultProcessorChain() : this.resourceTypePreprocessorChainFactory.buildProcessorChain(this.resourceTypePreprocessorKeys);
        if (null != this.customGlobalPostprocessors) {
            this.resourceTypePostprocessorChainFactory.setCustomGlobalProcessors(this.customGlobalPostprocessors);
        }
        GlobalProcessor<GlobalPostProcessingContext> resourceTypePostprocessor = null;
        resourceTypePostprocessor = null == this.resourceTypePostprocessorKeys ? this.resourceTypePostprocessorChainFactory.buildDefaultProcessorChain() : this.resourceTypePostprocessorChainFactory.buildProcessorChain(this.resourceTypePostprocessorKeys);
        ResourceBundlesHandler collector = new ResourceBundlesHandlerImpl(resourceBundles, this.resourceReaderHandler, this.resourceBundleHandler, this.jawrConfig, processor, unitProcessor, compositeBundleProcessor, compositeUnitProcessor, resourceTypePreprocessor, resourceTypePostprocessor);
        collector.setBundlingProcessLifeCycleListeners(this.getBundlingProcessLifeCycleListeners());
        if (this.useCacheManager && !this.jawrConfig.isDebugModeOn()) {
            collector = new CachedResourceBundlesHandler(collector);
        }
        collector.initAllBundles();
        return collector;
    }

    protected boolean isProcessingBundleFromCacheMapping() {
        boolean processBundleFromCacheMapping = false;
        if (this.jawrConfig.getUseBundleMapping() && this.resourceBundleHandler.isExistingMappingFile()) {
            Properties cachedMappingProperties = this.resourceBundleHandler.getJawrBundleMapping();
            String storedHashcode = cachedMappingProperties.getProperty("jawr.config.hashcode");
            String currentHashcode = null;
            try {
                currentHashcode = CheckSumUtils.getMD5Checksum(this.jawrConfig.getConfigProperties().toString());
            }
            catch (IOException e) {
                throw new BundlingProcessException("Unable to calculate checksum for current Jawr config");
            }
            if (currentHashcode.equals(storedHashcode)) {
                processBundleFromCacheMapping = true;
            }
        }
        return processBundleFromCacheMapping;
    }

    protected List<BundlingProcessLifeCycleListener> getBundlingProcessLifeCycleListeners() {
        ArrayList<BundlingProcessLifeCycleListener> lifeCycleListeners = new ArrayList<BundlingProcessLifeCycleListener>();
        List<BundlingProcessLifeCycleListener> generatorLifeCycleListeners = this.jawrConfig.getGeneratorRegistry().getBundlingProcessLifeCycleListeners();
        lifeCycleListeners.addAll(generatorLifeCycleListeners);
        lifeCycleListeners.addAll(this.resourceTypePreprocessorChainFactory.getBundlingProcessLifeCycleListeners());
        lifeCycleListeners.addAll(this.chainFactory.getBundlingProcessLifeCycleListeners());
        lifeCycleListeners.addAll(this.resourceTypePostprocessorChainFactory.getBundlingProcessLifeCycleListeners());
        return lifeCycleListeners;
    }

    protected void initCustomPostProcessors() {
        if (null != this.customPostprocessors) {
            this.chainFactory.setCustomPostprocessors(this.customPostprocessors);
        }
    }

    private void initResourceBundlesFromFullMapping(List<JoinableResourceBundle> resourceBundles) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Building bundles from the full bundle mapping. Only modified bundles will be processed.");
        }
        Properties mappingProperties = this.resourceBundleHandler.getJawrBundleMapping();
        FullMappingPropertiesBasedBundlesHandlerFactory factory = new FullMappingPropertiesBasedBundlesHandlerFactory(this.resourceType, this.resourceReaderHandler, this.jawrConfig.getGeneratorRegistry(), this.chainFactory);
        resourceBundles.addAll(factory.getResourceBundles(mappingProperties));
    }

    private void initResourceBundles(List<JoinableResourceBundle> resourceBundles) throws DuplicateBundlePathException, BundleDependencyException {
        this.bundleDefinitionsWithDependencies = new HashSet<ResourceBundleDefinition>();
        if (null != this.bundleDefinitions) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Adding custom bundle definitions. ");
            }
            for (ResourceBundleDefinition def : this.bundleDefinitions) {
                if (def.isComposite()) {
                    resourceBundles.add(this.buildCompositeResourcebundle(def));
                    continue;
                }
                resourceBundles.add(this.buildResourcebundle(def));
            }
        }
        if (!this.jawrConfig.getGeneratorRegistry().isPathGenerated(this.baseDir)) {
            this.baseDir = PathNormalizer.asDirPath(this.baseDir);
        }
        if (this.useDirMapperFactory) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Using ResourceBundleDirMapper. ");
            }
            ResourceBundleDirMapper dirFactory = new ResourceBundleDirMapper(this.baseDir, this.resourceReaderHandler, resourceBundles, this.fileExtension, this.excludedDirMapperDirs);
            Map<String, String> mappings = dirFactory.getBundleMapping();
            for (Map.Entry<String, String> entry : mappings.entrySet()) {
                resourceBundles.add(this.buildDirMappedResourceBundle(entry.getKey(), entry.getValue()));
            }
        }
        if (this.scanForOrphans) {
            OrphanResourceBundlesMapper orphanFactory = new OrphanResourceBundlesMapper(this.baseDir, this.resourceReaderHandler, this.jawrConfig.getGeneratorRegistry(), resourceBundles, this.fileExtension);
            List<String> orphans = orphanFactory.getOrphansList();
            if (this.useSingleResourceFactory) {
                if (!this.singleFileBundleName.endsWith(this.fileExtension)) {
                    this.singleFileBundleName = this.singleFileBundleName + this.fileExtension;
                }
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Building bundle of orphan resources with the name: " + this.singleFileBundleName);
                }
                resourceBundles.add(this.buildOrphansResourceBundle(this.singleFileBundleName, orphans));
            } else {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Creating mappings for orphan resources. ");
                }
                Iterator<String> it = orphans.iterator();
                while (it.hasNext()) {
                    resourceBundles.add(this.buildOrphanResourceBundle(it.next()));
                }
            }
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Skipping orphan file auto processing. ");
            if ("".equals(this.jawrConfig.getServletMapping())) {
                LOGGER.debug("Note that there is no specified mapping for Jawr (it has been seet to serve *.js or *.css requests). The orphan files will become unreachable through the server.");
            }
        }
        for (ResourceBundleDefinition definition : this.bundleDefinitionsWithDependencies) {
            JoinableResourceBundle bundle = this.getBundleFromName(definition.getBundleName(), resourceBundles);
            if (bundle == null) continue;
            bundle.setDependencies(this.getBundleDependencies(definition, resourceBundles));
        }
    }

    private JoinableResourceBundle getBundleFromName(String name, List<JoinableResourceBundle> bundles) {
        JoinableResourceBundle bundle = null;
        for (JoinableResourceBundle aBundle : bundles) {
            if (!aBundle.getName().equals(name)) continue;
            bundle = aBundle;
            break;
        }
        return bundle;
    }

    private JoinableResourceBundle buildCompositeResourcebundle(ResourceBundleDefinition def) throws BundleDependencyException {
        ArrayList<JoinableResourceBundle> childBundles = new ArrayList<JoinableResourceBundle>();
        for (ResourceBundleDefinition child : def.getChildren()) {
            JoinableResourceBundle childBundle = null;
            childBundle = child.isComposite() ? this.buildCompositeResourcebundle(child) : this.buildResourcebundle(child);
            childBundles.add(childBundle);
        }
        return this.buildCompositeResourcebundle(def, childBundles);
    }

    private JoinableResourceBundle buildCompositeResourcebundle(ResourceBundleDefinition definition, List<JoinableResourceBundle> childBundles) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Init composite bundle with id:" + definition.getBundleId());
        }
        this.validateBundleId(definition);
        InclusionPattern include = new InclusionPattern(definition.isGlobal(), definition.getInclusionOrder(), DebugInclusion.get(definition.isDebugOnly(), definition.isDebugNever()));
        CompositeResourceBundle composite = new CompositeResourceBundle(definition.getBundleId(), definition.getBundleName(), childBundles, include, this.resourceReaderHandler, definition.getBundlePrefix(), this.fileExtension, this.jawrConfig.getGeneratorRegistry());
        if (null != definition.getBundlePostProcessorKeys()) {
            composite.setBundlePostProcessor(this.chainFactory.buildPostProcessorChain(definition.getBundlePostProcessorKeys()));
        }
        if (null != definition.getUnitaryPostProcessorKeys()) {
            composite.setUnitaryPostProcessor(this.chainFactory.buildPostProcessorChain(definition.getUnitaryPostProcessorKeys()));
        }
        if (null != definition.getIeConditionalExpression()) {
            composite.setExplorerConditionalExpression(definition.getIeConditionalExpression());
        }
        if (null != definition.getAlternateProductionURL()) {
            composite.setAlternateProductionURL(definition.getAlternateProductionURL());
        }
        if (null != definition.getDependencies() && !definition.getDependencies().isEmpty()) {
            this.bundleDefinitionsWithDependencies.add(definition);
        }
        return composite;
    }

    private JoinableResourceBundle buildResourcebundle(ResourceBundleDefinition definition) throws BundleDependencyException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Init bundle with id:" + definition.getBundleId());
        }
        this.validateBundleId(definition);
        DebugInclusion inclusion = DebugInclusion.ALWAYS;
        if (definition.isDebugOnly()) {
            inclusion = DebugInclusion.ONLY;
        }
        if (definition.isDebugNever()) {
            inclusion = DebugInclusion.NEVER;
        }
        InclusionPattern include = new InclusionPattern(definition.isGlobal(), definition.getInclusionOrder(), inclusion);
        JoinableResourceBundleImpl newBundle = new JoinableResourceBundleImpl(definition.getBundleId(), definition.getBundleName(), definition.getBundlePrefix(), this.fileExtension, include, definition.getMappings(), this.resourceReaderHandler, this.jawrConfig.getGeneratorRegistry());
        if (null != definition.getBundlePostProcessorKeys()) {
            newBundle.setBundlePostProcessor(this.chainFactory.buildPostProcessorChain(definition.getBundlePostProcessorKeys()));
        }
        if (null != definition.getUnitaryPostProcessorKeys()) {
            newBundle.setUnitaryPostProcessor(this.chainFactory.buildPostProcessorChain(definition.getUnitaryPostProcessorKeys()));
        }
        if (null != definition.getIeConditionalExpression()) {
            newBundle.setExplorerConditionalExpression(definition.getIeConditionalExpression());
        }
        if (null != definition.getAlternateProductionURL()) {
            newBundle.setAlternateProductionURL(definition.getAlternateProductionURL());
        }
        if (null != definition.getDebugURL()) {
            newBundle.setDebugURL(definition.getDebugURL());
        }
        if (null != definition.getDependencies() && !definition.getDependencies().isEmpty()) {
            this.bundleDefinitionsWithDependencies.add(definition);
        }
        return newBundle;
    }

    private void validateBundleId(ResourceBundleDefinition definition) {
        String bundleId = definition.getBundleId();
        if (bundleId != null) {
            if (!bundleId.endsWith(this.fileExtension)) {
                throw new BundlingProcessException("The extension of the bundle " + definition.getBundleName() + " - " + bundleId + " doesn't match the allowed extension : '" + this.fileExtension + "'. Please update your bundle definition.");
            }
            if (bundleId.startsWith("/WEB-INF/") || bundleId.startsWith("/META-INF/")) {
                throw new BundlingProcessException("For the bundle " + definition.getBundleName() + ", the bundle id '" + bundleId + "' is not allowed because it starts with \"/WEB-INF/\". Please update your bundle definition.");
            }
        }
    }

    private List<JoinableResourceBundle> getBundleDependencies(ResourceBundleDefinition definition, List<JoinableResourceBundle> bundles) throws BundleDependencyException {
        ArrayList<JoinableResourceBundle> dependencies = new ArrayList<JoinableResourceBundle>();
        ArrayList<String> processedBundles = new ArrayList<String>();
        if (definition.isGlobal() && definition.getDependencies() != null && !definition.getDependencies().isEmpty()) {
            throw new BundleDependencyException(definition.getBundleName(), "The dependencies property is not allowed for global bundles. Please use the order property to define the import order.");
        }
        this.initBundleDependencies(definition.getBundleName(), definition, dependencies, processedBundles, bundles);
        return dependencies;
    }

    private void initBundleDependencies(String rootBundleDefinition, ResourceBundleDefinition definition, List<JoinableResourceBundle> bundleDependencies, List<String> processedBundles, List<JoinableResourceBundle> bundles) throws BundleDependencyException {
        List<String> bundleDefDependencies = definition.getDependencies();
        if (definition.isGlobal()) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("The global bundle '" + definition.getBundleName() + "' belongs to the dependencies of '" + rootBundleDefinition + "'." + "As it's a global bundle, it will not be defined as part of the dependencies.");
            }
            return;
        }
        if (bundleDefDependencies != null && !bundleDefDependencies.isEmpty()) {
            if (processedBundles.contains(definition.getBundleName())) {
                throw new BundleDependencyException(rootBundleDefinition, "There is a circular dependency. The bundle in conflict is '" + definition.getBundleName() + "'");
            }
            processedBundles.add(definition.getBundleName());
            for (String dependency : bundleDefDependencies) {
                for (ResourceBundleDefinition dependencyBundle : this.bundleDefinitions) {
                    String dependencyBundleName = dependencyBundle.getBundleName();
                    if (!dependencyBundleName.equals(dependency)) continue;
                    if (!this.bundleListContains(bundleDependencies, dependencyBundleName)) {
                        if (!processedBundles.contains(dependencyBundleName)) {
                            this.initBundleDependencies(rootBundleDefinition, dependencyBundle, bundleDependencies, processedBundles, bundles);
                            bundleDependencies.add(this.getBundleFromName(dependencyBundleName, bundles));
                            continue;
                        }
                        throw new BundleDependencyException(rootBundleDefinition, "There is a circular dependency. The bundle in conflict is '" + dependencyBundleName + "'");
                    }
                    if (!LOGGER.isInfoEnabled()) continue;
                    LOGGER.info("The bundle '" + dependencyBundle.getBundleId() + "' occurs multiple time in the dependencies hierarchy of the bundle '" + rootBundleDefinition + "'.");
                }
            }
        }
    }

    private boolean bundleListContains(List<JoinableResourceBundle> bundles, String bundleName) {
        boolean contains = false;
        for (JoinableResourceBundle bundle : bundles) {
            if (!bundle.getName().equals(bundleName)) continue;
            contains = true;
            break;
        }
        return contains;
    }

    private JoinableResourceBundle buildDirMappedResourceBundle(String bundleId, String pathMapping) {
        List<String> path = Collections.singletonList(pathMapping);
        JoinableResourceBundleImpl newBundle = new JoinableResourceBundleImpl(bundleId, this.generateBundleNameFromBundleId(bundleId), null, this.fileExtension, new InclusionPattern(), path, this.resourceReaderHandler, this.jawrConfig.getGeneratorRegistry());
        return newBundle;
    }

    private String generateBundleNameFromBundleId(String bundleId) {
        int idxExtension;
        String bundleName = bundleId;
        if (bundleName.startsWith("/")) {
            bundleName = bundleName.substring(1);
        }
        if ((idxExtension = FileNameUtils.indexOfExtension(bundleName)) != -1) {
            bundleName = bundleName.substring(0, idxExtension);
        }
        return bundleName.replaceAll("(/|\\.|:)", "_");
    }

    private JoinableResourceBundle buildOrphansResourceBundle(String bundleId, List<String> orphanPaths) {
        JoinableResourceBundleImpl newBundle = new JoinableResourceBundleImpl(bundleId, this.generateBundleNameFromBundleId(bundleId), null, this.fileExtension, new InclusionPattern(), orphanPaths, this.resourceReaderHandler, this.jawrConfig.getGeneratorRegistry());
        return newBundle;
    }

    private JoinableResourceBundle buildOrphanResourceBundle(String orphanPath) {
        String mapping = orphanPath;
        List<String> paths = Collections.singletonList(mapping);
        JoinableResourceBundleImpl newBundle = new JoinableResourceBundleImpl(orphanPath, this.generateBundleNameFromBundleId(orphanPath), null, this.fileExtension, new InclusionPattern(), paths, this.resourceReaderHandler, this.jawrConfig.getGeneratorRegistry());
        return newBundle;
    }

    public void setBundlesType(String resourceType) {
        this.resourceType = resourceType;
        this.fileExtension = "." + resourceType.toLowerCase();
        this.resourceTypePreprocessorChainFactory = new BasicGlobalPreprocessorChainFactory();
        this.resourceTypePostprocessorChainFactory = new BasicGlobalPostprocessorChainFactory();
        this.chainFactory = "js".equals(resourceType) ? new JSPostProcessorChainFactory() : new CSSPostProcessorChainFactory();
    }

    public void setBundleDefinitions(Set<ResourceBundleDefinition> bundleDefinitions) {
        this.bundleDefinitions = bundleDefinitions;
    }

    public void setBaseDir(String baseDir) {
        this.baseDir = baseDir;
    }

    public void setGlobalPostProcessorKeys(String globalPostProcessorKeys) {
        this.globalPostProcessorKeys = globalPostProcessorKeys;
    }

    public void setUnitPostProcessorKeys(String unitPostProcessorKeys) {
        this.unitPostProcessorKeys = unitPostProcessorKeys;
    }

    public void setGlobalCompositePostProcessorKeys(String globalCompositePostProcessorKeys) {
        this.globalCompositePostProcessorKeys = globalCompositePostProcessorKeys;
    }

    public void setUnitCompositePostProcessorKeys(String unitCompositePostProcessorKeys) {
        this.unitCompositePostProcessorKeys = unitCompositePostProcessorKeys;
    }

    public void setResourceTypePreprocessorKeys(String resourceTypePreprocessorKeys) {
        this.resourceTypePreprocessorKeys = resourceTypePreprocessorKeys;
    }

    public void setResourceTypePostprocessorKeys(String resourceTypePostprocessorKeys) {
        this.resourceTypePostprocessorKeys = resourceTypePostprocessorKeys;
    }

    public void setResourceReaderHandler(ResourceReaderHandler rsHandler) {
        this.resourceReaderHandler = rsHandler;
    }

    public void setResourceBundleHandler(ResourceBundleHandler rsBundleHandler) {
        this.resourceBundleHandler = rsBundleHandler;
    }

    public void setUseSingleResourceFactory(boolean useSingleResourceFactory) {
        this.useSingleResourceFactory = useSingleResourceFactory;
    }

    public void setSingleFileBundleName(String singleFileBundleName) {
        if (null != singleFileBundleName) {
            this.singleFileBundleName = PathNormalizer.normalizePath(singleFileBundleName);
        }
    }

    public void setUseDirMapperFactory(boolean useDirMapperFactory) {
        this.useDirMapperFactory = useDirMapperFactory;
    }

    public void setUseCacheManager(boolean useCacheManager) {
        this.useCacheManager = useCacheManager;
    }

    public void setExludedDirMapperDirs(Set<String> exludedDirMapperDirs) {
        if (null != exludedDirMapperDirs) {
            this.excludedDirMapperDirs = PathNormalizer.normalizePaths(exludedDirMapperDirs);
        }
    }

    public void setCustomPostprocessors(Map<String, String> customPostprocessors) {
        this.customPostprocessors = customPostprocessors;
    }

    public void setCustomGlobalPreprocessors(Map<String, String> customGlobalPreprocessors) {
        this.customGlobalPreprocessors = customGlobalPreprocessors;
    }

    public void setCustomGlobalPostprocessors(Map<String, String> customGlobalPostprocessors) {
        this.customGlobalPostprocessors = customGlobalPostprocessors;
    }

    public void setScanForOrphans(boolean scanForOrphans) {
        this.scanForOrphans = scanForOrphans;
    }
}

