/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle.factory;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import net.jawr.web.resource.bundle.CompositeResourceBundle;
import net.jawr.web.resource.bundle.DebugInclusion;
import net.jawr.web.resource.bundle.InclusionPattern;
import net.jawr.web.resource.bundle.JoinableResourceBundle;
import net.jawr.web.resource.bundle.JoinableResourceBundleImpl;
import net.jawr.web.resource.bundle.factory.postprocessor.PostProcessorChainFactory;
import net.jawr.web.resource.bundle.factory.util.PropertiesConfigHelper;
import net.jawr.web.resource.bundle.generator.GeneratorRegistry;
import net.jawr.web.resource.bundle.mappings.FilePathMapping;
import net.jawr.web.resource.bundle.variant.VariantSet;
import net.jawr.web.resource.bundle.variant.VariantUtils;
import net.jawr.web.resource.handler.reader.ResourceReaderHandler;
import net.jawr.web.util.StringUtils;

public class FullMappingPropertiesBasedBundlesHandlerFactory {
    private final PostProcessorChainFactory chainFactory;
    private final String resourceType;
    private final ResourceReaderHandler rsReaderHandler;
    private final GeneratorRegistry generatorRegistry;

    public FullMappingPropertiesBasedBundlesHandlerFactory(String resourceType, ResourceReaderHandler rsHandler, GeneratorRegistry generatorRegistry, PostProcessorChainFactory chainFactory) {
        this.resourceType = resourceType;
        this.chainFactory = chainFactory;
        this.rsReaderHandler = rsHandler;
        this.generatorRegistry = generatorRegistry;
    }

    public List<JoinableResourceBundle> getResourceBundles(Properties properties) {
        PropertiesConfigHelper props = new PropertiesConfigHelper(properties, this.resourceType);
        String fileExtension = "." + this.resourceType;
        ArrayList<JoinableResourceBundle> customBundles = new ArrayList<JoinableResourceBundle>();
        if (null != props.getProperty("bundle.names")) {
            StringTokenizer tk = new StringTokenizer(props.getProperty("bundle.names"), ",");
            while (tk.hasMoreTokens()) {
                customBundles.add(this.buildJoinableResourceBundle(props, tk.nextToken().trim(), fileExtension, this.rsReaderHandler));
            }
        } else {
            Iterator<String> bundleNames = props.getPropertyBundleNameSet().iterator();
            while (bundleNames.hasNext()) {
                customBundles.add(this.buildJoinableResourceBundle(props, bundleNames.next(), fileExtension, this.rsReaderHandler));
            }
        }
        for (String bundleName : props.getPropertyBundleNameSet()) {
            List<String> bundleNameDependencies = props.getCustomBundlePropertyAsList(bundleName, ".dependencies");
            if (bundleNameDependencies.isEmpty()) continue;
            JoinableResourceBundle bundle = this.getBundleFromName(bundleName, customBundles);
            List<JoinableResourceBundle> bundleDependencies = this.getBundlesFromName(bundleNameDependencies, customBundles);
            bundle.setDependencies(bundleDependencies);
        }
        return customBundles;
    }

    private JoinableResourceBundle getBundleFromName(String bundleName, List<JoinableResourceBundle> bundles) {
        JoinableResourceBundle bundle = null;
        ArrayList<String> names = new ArrayList<String>();
        names.add(bundleName);
        List<JoinableResourceBundle> result = this.getBundlesFromName(names, bundles);
        if (!result.isEmpty()) {
            bundle = result.get(0);
        }
        return bundle;
    }

    private List<JoinableResourceBundle> getBundlesFromName(List<String> names, List<JoinableResourceBundle> bundles) {
        ArrayList<JoinableResourceBundle> resultBundles = new ArrayList<JoinableResourceBundle>();
        for (String name : names) {
            for (JoinableResourceBundle bundle : bundles) {
                if (!bundle.getName().equals(name)) continue;
                resultBundles.add(bundle);
            }
        }
        return resultBundles;
    }

    private JoinableResourceBundle buildJoinableResourceBundle(PropertiesConfigHelper props, String bundleName, String fileExtension, ResourceReaderHandler rsHandler) {
        Set<String> licencePathList;
        String alternateProductionURL;
        String explorerConditionalCondition;
        String unitaryPostProcessors;
        String bundleId = props.getCustomBundleProperty(bundleName, ".id");
        String bundlePrefix = props.getCustomBundleProperty(bundleName, ".bundle.prefix");
        boolean isComposite = props.getCustomBundleBooleanProperty(bundleName, ".composite");
        InclusionPattern inclusionPattern = this.getInclusionPattern(props, bundleName);
        JoinableResourceBundleImpl bundle = null;
        if (isComposite) {
            ArrayList<JoinableResourceBundle> nestedBundles = new ArrayList<JoinableResourceBundle>();
            List<String> nestedBundleNames = props.getCustomBundlePropertyAsList(bundleName, ".child.names");
            for (String nestedBundleName : nestedBundleNames) {
                JoinableResourceBundle nestedBundle = this.buildJoinableResourceBundle(props, nestedBundleName, fileExtension, rsHandler);
                nestedBundles.add(nestedBundle);
            }
            bundle = new CompositeResourceBundle(bundleId, bundleName, nestedBundles, inclusionPattern, rsHandler, bundlePrefix, fileExtension, this.generatorRegistry);
        } else {
            bundle = new JoinableResourceBundleImpl(bundleId, bundleName, bundlePrefix, fileExtension, inclusionPattern, rsHandler, this.generatorRegistry);
        }
        String bundlePostProcessors = props.getCustomBundleProperty(bundleName, ".bundlepostprocessors");
        if (StringUtils.isNotEmpty(bundlePostProcessors)) {
            bundle.setBundlePostProcessor(this.chainFactory.buildPostProcessorChain(bundlePostProcessors));
        }
        if (StringUtils.isNotEmpty(unitaryPostProcessors = props.getCustomBundleProperty(bundleName, ".filepostprocessors"))) {
            bundle.setUnitaryPostProcessor(this.chainFactory.buildPostProcessorChain(unitaryPostProcessors));
        }
        if (StringUtils.isNotEmpty(explorerConditionalCondition = props.getCustomBundleProperty(bundleName, ".ieonly.condition"))) {
            bundle.setExplorerConditionalExpression(explorerConditionalCondition);
        }
        if (StringUtils.isNotEmpty(alternateProductionURL = props.getCustomBundleProperty(bundleName, ".productionURL"))) {
            bundle.setAlternateProductionURL(props.getCustomBundleProperty(bundleName, ".productionURL"));
        }
        boolean hasDebugURL = false;
        if (null != props.getCustomBundleProperty(bundleName, ".debugURL")) {
            bundle.setDebugURL(props.getCustomBundleProperty(bundleName, ".debugURL"));
            hasDebugURL = true;
            if (StringUtils.isEmpty(bundle.getAlternateProductionURL())) {
                throw new IllegalArgumentException("The bundle '" + bundleName + "', which use a static external resource in debug mode, must use an external resource in Production mode.\n" + "Please check your configuration. ");
            }
            if (StringUtils.isNotEmpty(props.getCustomBundleProperty(bundleName, ".mappings"))) {
                throw new IllegalArgumentException("The bundle '" + bundleName + "', which use a static external resource in debug mode, can't have a bundle mapping.\n" + "Please check your configuration. ");
            }
        }
        if (!(licencePathList = props.getCustomBundlePropertyAsSet(bundleName, ".licencePathList")).isEmpty()) {
            bundle.setLicensesPathList(licencePathList);
        }
        List<String> mappings = props.getCustomBundlePropertyAsList(bundleName, ".mappings");
        if (!hasDebugURL && mappings.isEmpty() && !bundle.isComposite()) {
            throw new IllegalArgumentException("No mappings were defined for the bundle with name: " + bundleName + ". Please specify at least one in configuration. ");
        }
        if (!hasDebugURL) {
            bundle.setMappings(mappings);
            Map<String, VariantSet> variants = props.getCustomBundleVariantSets(bundleName);
            bundle.setVariants(variants);
            this.verifyIfBundleIsModified(bundle, mappings, props);
            if (!bundle.isDirty()) {
                for (String variantKey : bundle.getVariantKeys()) {
                    if (!StringUtils.isNotEmpty(variantKey)) continue;
                    String hashcode = props.getCustomBundleProperty(bundleName, ".bundleHashcode." + variantKey);
                    bundle.setBundleDataHashCode(variantKey, hashcode);
                }
                String hashcode = props.getCustomBundleProperty(bundleName, ".bundleHashcode");
                bundle.setBundleDataHashCode(null, hashcode);
            }
        }
        return bundle;
    }

    private void verifyIfBundleIsModified(JoinableResourceBundleImpl bundle, List<String> mappings, PropertiesConfigHelper props) {
        Map<String, VariantSet> variants = new TreeMap<String, VariantSet>();
        for (String mapping : mappings) {
            variants = VariantUtils.concatVariants(variants, this.generatorRegistry.getAvailableVariants(mapping));
        }
        if (!variants.equals(bundle.getVariants())) {
            bundle.setVariants(variants);
            bundle.setDirty(true);
        } else {
            String bundleName = bundle.getName();
            List<String> fileMappings = props.getCustomBundlePropertyAsList(bundleName, ".mappings.files");
            if (fileMappings != null) {
                List<FilePathMapping> bundleFileMappings = bundle.getFilePathMappings();
                if (bundleFileMappings.size() != fileMappings.size()) {
                    bundle.setDirty(true);
                } else {
                    HashSet<FilePathMapping> storedFilePathMapping = new HashSet<FilePathMapping>();
                    for (String filePathWithTimeStamp : fileMappings) {
                        String[] tmp = filePathWithTimeStamp.split("#");
                        String filePath = tmp[0];
                        long storedLastModified = Long.parseLong(tmp[1]);
                        storedFilePathMapping.add(new FilePathMapping((JoinableResourceBundle)bundle, filePath, storedLastModified));
                    }
                    HashSet<FilePathMapping> bundleFilePathMappingSet = new HashSet<FilePathMapping>(bundleFileMappings);
                    if (!bundleFilePathMappingSet.equals(storedFilePathMapping)) {
                        bundle.setDirty(true);
                    }
                }
            }
            fileMappings = props.getCustomBundlePropertyAsList(bundleName, ".mappings.linked.files");
            for (String filePathWithTimeStamp : fileMappings) {
                int idx = filePathWithTimeStamp.lastIndexOf("#");
                if (idx == -1) continue;
                String filePath = filePathWithTimeStamp.substring(0, idx);
                long storedLastModified = Long.parseLong(filePathWithTimeStamp.substring(idx + 1));
                long currentLastModified = this.rsReaderHandler.getLastModified(filePath);
                FilePathMapping fPathMapping = new FilePathMapping((JoinableResourceBundle)bundle, filePath, currentLastModified);
                bundle.getLinkedFilePathMappings().add(fPathMapping);
                if (storedLastModified == currentLastModified) continue;
                bundle.setDirty(true);
            }
        }
    }

    private InclusionPattern getInclusionPattern(PropertiesConfigHelper props, String bundleName) {
        boolean isGlobal = Boolean.parseBoolean(props.getCustomBundleProperty(bundleName, ".global", "false"));
        int order = 0;
        if (isGlobal) {
            order = Integer.parseInt(props.getCustomBundleProperty(bundleName, ".order", "0"));
        }
        boolean isDebugOnly = Boolean.parseBoolean(props.getCustomBundleProperty(bundleName, ".debugonly", "false"));
        boolean isDebugNever = Boolean.parseBoolean(props.getCustomBundleProperty(bundleName, ".debugnever", "false"));
        return new InclusionPattern(isGlobal, order, DebugInclusion.get(isDebugOnly, isDebugNever));
    }
}

