/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle.factory;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import net.jawr.web.config.JawrConfig;
import net.jawr.web.exception.BundleDependencyException;
import net.jawr.web.exception.DuplicateBundlePathException;
import net.jawr.web.resource.bundle.factory.BundlesHandlerFactory;
import net.jawr.web.resource.bundle.factory.util.PropertiesConfigHelper;
import net.jawr.web.resource.bundle.factory.util.ResourceBundleDefinition;
import net.jawr.web.resource.bundle.generator.GeneratorRegistry;
import net.jawr.web.resource.bundle.handler.ResourceBundlesHandler;
import net.jawr.web.resource.handler.bundle.ResourceBundleHandler;
import net.jawr.web.resource.handler.reader.ResourceReaderHandler;
import net.jawr.web.util.StringUtils;

public class PropertiesBasedBundlesHandlerFactory {
    private PropertiesConfigHelper props;
    private BundlesHandlerFactory factory;

    protected PropertiesBasedBundlesHandlerFactory() {
    }

    public PropertiesBasedBundlesHandlerFactory(Properties properties, String resourceType, ResourceReaderHandler rsHandler, ResourceBundleHandler rsBundleHandler, JawrConfig jawrConfig) {
        this.props = new PropertiesConfigHelper(properties, resourceType);
        this.factory = new BundlesHandlerFactory(jawrConfig);
        this.factory.setResourceReaderHandler(rsHandler);
        this.factory.setResourceBundleHandler(rsBundleHandler);
        this.factory.setBundlesType(resourceType);
        this.factory.setBaseDir(this.props.getProperty("bundle.basedir", "/"));
        this.factory.setUseCacheManager(Boolean.parseBoolean(this.props.getProperty("use.cache", "true")));
        this.factory.setGlobalPostProcessorKeys(this.props.getProperty("bundle.factory.bundlepostprocessors"));
        this.factory.setUnitPostProcessorKeys(this.props.getProperty("bundle.factory.filepostprocessors"));
        this.factory.setGlobalCompositePostProcessorKeys(this.props.getProperty("bundle.factory.composite.bundlepostprocessors"));
        this.factory.setUnitCompositePostProcessorKeys(this.props.getProperty("bundle.factory.composite.filepostprocessors"));
        this.factory.setResourceTypePreprocessorKeys(this.props.getProperty("bundle.factory.global.preprocessors"));
        this.factory.setResourceTypePostprocessorKeys(this.props.getProperty("bundle.factory.global.postprocessors"));
        this.factory.setUseSingleResourceFactory(Boolean.parseBoolean(this.props.getProperty("factory.use.singlebundle", "false")));
        this.factory.setSingleFileBundleName(this.props.getProperty("factory.singlebundle.bundlename"));
        this.factory.setScanForOrphans(Boolean.parseBoolean(this.props.getCommonProperty("factory.use.orphans.mapper", "true")));
        this.factory.setUseDirMapperFactory(Boolean.parseBoolean(this.props.getProperty("factory.use.dirmapper", "false")));
        this.factory.setExludedDirMapperDirs(this.props.getPropertyAsSet("factory.dirmapper.excluded"));
        Iterator<String> generators = this.props.getCommonPropertyAsSet("custom.generators").iterator();
        GeneratorRegistry generatorRegistry = jawrConfig.getGeneratorRegistry();
        while (generators.hasNext()) {
            String generatorClass = generators.next();
            generatorRegistry.registerGenerator(generatorClass);
        }
        for (String resolverClass : this.props.getCommonPropertyAsSet("custom.resolvers")) {
            generatorRegistry.registerVariantResolver(resolverClass);
        }
        HashSet<ResourceBundleDefinition> customBundles = new HashSet<ResourceBundleDefinition>();
        if (null != this.props.getProperty("bundle.names")) {
            StringTokenizer tk = new StringTokenizer(this.props.getProperty("bundle.names"), ",");
            while (tk.hasMoreTokens()) {
                customBundles.add(this.buildCustomBundleDefinition(tk.nextToken().trim(), false));
            }
        } else {
            Iterator<String> bundleNames = this.props.getPropertyBundleNameSet().iterator();
            while (bundleNames.hasNext()) {
                customBundles.add(this.buildCustomBundleDefinition(bundleNames.next(), false));
            }
        }
        this.factory.setBundleDefinitions(customBundles);
        this.factory.setCustomGlobalPreprocessors(this.props.getCustomGlobalPreprocessorMap());
        this.factory.setCustomGlobalPostprocessors(this.props.getCustomGlobalPostprocessorMap());
        this.factory.setCustomPostprocessors(this.props.getCustomPostProcessorMap());
    }

    public ResourceBundlesHandler buildResourceBundlesHandler() throws DuplicateBundlePathException, BundleDependencyException {
        return this.factory.buildResourceBundlesHandler();
    }

    private ResourceBundleDefinition buildCustomBundleDefinition(String bundleName, boolean isChildBundle) {
        String bundleId = this.props.getCustomBundleProperty(bundleName, ".id");
        if (null == bundleId && !isChildBundle) {
            throw new IllegalArgumentException("No id defined for the bundle with name:" + bundleName + ". Please specify one in configuration. ");
        }
        boolean isComposite = Boolean.parseBoolean(this.props.getCustomBundleProperty(bundleName, ".composite", "false"));
        ResourceBundleDefinition bundle = new ResourceBundleDefinition();
        bundle.setBundleId(bundleId);
        bundle.setBundleName(bundleName);
        bundle.setBundlePrefix(this.props.getCustomBundleProperty(bundleName, ".bundle.prefix"));
        boolean isGlobal = Boolean.parseBoolean(this.props.getCustomBundleProperty(bundleName, ".global", "false"));
        bundle.setGlobal(isGlobal);
        if (isGlobal) {
            int order = Integer.parseInt(this.props.getCustomBundleProperty(bundleName, ".order", "0"));
            bundle.setInclusionOrder(order);
        }
        if (null != this.props.getCustomBundleProperty(bundleName, ".bundlepostprocessors")) {
            bundle.setBundlePostProcessorKeys(this.props.getCustomBundleProperty(bundleName, ".bundlepostprocessors"));
        }
        if (null != this.props.getCustomBundleProperty(bundleName, ".filepostprocessors")) {
            bundle.setUnitaryPostProcessorKeys(this.props.getCustomBundleProperty(bundleName, ".filepostprocessors"));
        }
        boolean isDebugOnly = Boolean.parseBoolean(this.props.getCustomBundleProperty(bundleName, ".debugonly", "false"));
        bundle.setDebugOnly(isDebugOnly);
        boolean isDebugNever = Boolean.parseBoolean(this.props.getCustomBundleProperty(bundleName, ".debugnever", "false"));
        bundle.setDebugNever(isDebugNever);
        if (null != this.props.getCustomBundleProperty(bundleName, ".ieonly.condition")) {
            bundle.setIeConditionalExpression(this.props.getCustomBundleProperty(bundleName, ".ieonly.condition"));
        }
        if (null != this.props.getCustomBundleProperty(bundleName, ".productionURL")) {
            bundle.setAlternateProductionURL(this.props.getCustomBundleProperty(bundleName, ".productionURL"));
        }
        boolean hasDebugURL = false;
        if (null != this.props.getCustomBundleProperty(bundleName, ".debugURL")) {
            bundle.setDebugURL(this.props.getCustomBundleProperty(bundleName, ".debugURL"));
            hasDebugURL = true;
            if (StringUtils.isEmpty(bundle.getAlternateProductionURL())) {
                throw new IllegalArgumentException("The bundle '" + bundleName + "', which use a static external resource in debug mode, must use an external resource in Production mode.\n" + "Please check your configuration. ");
            }
            if (isComposite) {
                throw new IllegalArgumentException("The bundle '" + bundleName + "', which use a static external resource in debug mode, can't be part of a composite bundle.\n" + "Please check your configuration. ");
            }
            if (StringUtils.isNotEmpty(this.props.getCustomBundleProperty(bundleName, ".mappings"))) {
                throw new IllegalArgumentException("The bundle '" + bundleName + "', which use a static external resource in debug mode, can't have a bundle mapping.\n" + "Please check your configuration. ");
            }
        }
        if (isComposite) {
            String childBundlesProperty = this.props.getCustomBundleProperty(bundleName, ".child.names");
            if (null == childBundlesProperty) {
                throw new IllegalArgumentException("No child bundle names were defined for the composite bundle with name:" + bundleName + ". Please specify at least one in configuration. ");
            }
            bundle.setComposite(true);
            ArrayList<ResourceBundleDefinition> children = new ArrayList<ResourceBundleDefinition>();
            StringTokenizer tk = new StringTokenizer(childBundlesProperty, ",");
            while (tk.hasMoreTokens()) {
                ResourceBundleDefinition childDef = this.buildCustomBundleDefinition(tk.nextToken().trim(), true);
                childDef.setBundleId(bundleId);
                if (StringUtils.isEmpty(childDef.getDebugURL())) {
                    children.add(childDef);
                    continue;
                }
                throw new IllegalArgumentException("The external bundle '" + childDef.getBundleName() + "' can't be a child of the composite bundle '" + bundleName + "'. Please check your configuration. ");
            }
            bundle.setChildren(children);
        } else {
            String mappingsProperty = this.props.getCustomBundleProperty(bundleName, ".mappings");
            if (!hasDebugURL) {
                if (null == mappingsProperty) {
                    throw new IllegalArgumentException("No mappings were defined for the bundle with name:" + bundleName + ". Please specify at least one in configuration. ");
                }
                ArrayList<String> mappings = new ArrayList<String>();
                StringTokenizer tk = new StringTokenizer(mappingsProperty, ",");
                while (tk.hasMoreTokens()) {
                    String mapping = tk.nextToken().trim();
                    mappings.add(mapping);
                }
                bundle.setMappings(mappings);
            }
        }
        List<String> dependencies = this.props.getCustomBundlePropertyAsList(bundleName, ".dependencies");
        bundle.setDependencies(dependencies);
        return bundle;
    }
}

