/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle.factory.postprocessor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import net.jawr.web.resource.bundle.factory.postprocessor.PostProcessorChainFactory;
import net.jawr.web.resource.bundle.factory.util.ClassLoaderResourceUtils;
import net.jawr.web.resource.bundle.lifecycle.BundlingProcessLifeCycleListener;
import net.jawr.web.resource.bundle.postprocess.AbstractChainedResourceBundlePostProcessor;
import net.jawr.web.resource.bundle.postprocess.ChainedResourceBundlePostProcessor;
import net.jawr.web.resource.bundle.postprocess.EmptyResourceBundlePostProcessor;
import net.jawr.web.resource.bundle.postprocess.ResourceBundlePostProcessor;
import net.jawr.web.resource.bundle.postprocess.VariantPostProcessor;
import net.jawr.web.resource.bundle.postprocess.impl.CustomPostProcessorChainWrapper;
import net.jawr.web.resource.bundle.postprocess.impl.LicensesIncluderPostProcessor;

public abstract class AbstractPostProcessorChainFactory
implements PostProcessorChainFactory {
    private final Map<String, ChainedResourceBundlePostProcessor> customPostProcessors;
    private final List<BundlingProcessLifeCycleListener> listeners = new ArrayList<BundlingProcessLifeCycleListener>();

    public AbstractPostProcessorChainFactory() {
        this.customPostProcessors = new HashMap<String, ChainedResourceBundlePostProcessor>();
    }

    @Override
    public ResourceBundlePostProcessor buildDefaultCompositeProcessorChain() {
        return new EmptyResourceBundlePostProcessor();
    }

    @Override
    public ResourceBundlePostProcessor buildDefaultUnitCompositeProcessorChain() {
        return new EmptyResourceBundlePostProcessor();
    }

    @Override
    public ResourceBundlePostProcessor buildPostProcessorChain(String processorKeys) {
        if (null == processorKeys) {
            return null;
        }
        if ("none".equals(processorKeys)) {
            return new EmptyResourceBundlePostProcessor();
        }
        StringTokenizer tk = new StringTokenizer(processorKeys, ",");
        AbstractChainedResourceBundlePostProcessor chain = null;
        while (tk.hasMoreTokens()) {
            chain = this.addOrCreateChain(chain, tk.nextToken().trim());
        }
        return chain;
    }

    private AbstractChainedResourceBundlePostProcessor addOrCreateChain(AbstractChainedResourceBundlePostProcessor chain, String key) {
        AbstractChainedResourceBundlePostProcessor toAdd;
        if (this.customPostProcessors.get(key) == null) {
            toAdd = this.buildProcessorByKey(key);
            if (toAdd instanceof BundlingProcessLifeCycleListener && !this.listeners.contains(toAdd)) {
                this.listeners.add((BundlingProcessLifeCycleListener)((Object)toAdd));
            }
        } else {
            toAdd = (AbstractChainedResourceBundlePostProcessor)this.customPostProcessors.get(key);
        }
        AbstractChainedResourceBundlePostProcessor newChainResult = null;
        if (chain == null) {
            newChainResult = toAdd;
        } else {
            chain.addNextProcessor(toAdd);
            newChainResult = chain;
        }
        return newChainResult;
    }

    protected abstract AbstractChainedResourceBundlePostProcessor buildProcessorByKey(String var1);

    protected LicensesIncluderPostProcessor buildLicensesProcessor() {
        return new LicensesIncluderPostProcessor();
    }

    @Override
    public void setCustomPostprocessors(Map<String, String> keysClassNames) {
        for (Map.Entry<String, String> entry : keysClassNames.entrySet()) {
            boolean isVariantPostProcessor;
            ResourceBundlePostProcessor customProcessor = (ResourceBundlePostProcessor)ClassLoaderResourceUtils.buildObjectInstance(entry.getValue());
            boolean bl = isVariantPostProcessor = customProcessor.getClass().getAnnotation(VariantPostProcessor.class) != null;
            if (customProcessor instanceof BundlingProcessLifeCycleListener) {
                this.listeners.add((BundlingProcessLifeCycleListener)((Object)customProcessor));
            }
            String key = entry.getKey();
            this.customPostProcessors.put(key, this.getCustomProcessorWrapper(customProcessor, key, isVariantPostProcessor));
        }
    }

    protected ChainedResourceBundlePostProcessor getCustomProcessorWrapper(ResourceBundlePostProcessor customProcessor, String key, boolean isVariantPostProcessor) {
        return new CustomPostProcessorChainWrapper(key, customProcessor, isVariantPostProcessor);
    }

    @Override
    public List<BundlingProcessLifeCycleListener> getBundlingProcessLifeCycleListeners() {
        return this.listeners;
    }
}

