/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle.factory.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import net.jawr.web.config.jmx.JmxUtils;
import net.jawr.web.context.ThreadLocalJawrContext;
import net.jawr.web.exception.BundlingProcessException;
import net.jawr.web.exception.ResourceNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassLoaderResourceUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClassLoaderResourceUtils.class);

    public static InputStream getResourceAsStream(String resourcePath, Object source) throws FileNotFoundException {
        ObjectName name;
        MBeanServer mbs;
        ClassLoader cl;
        InputStream is = source.getClass().getResourceAsStream(resourcePath);
        if (null == is && null != (cl = source.getClass().getClassLoader())) {
            is = cl.getResourceAsStream(resourcePath);
        }
        if (null == is) {
            is = Thread.currentThread().getContextClassLoader().getResourceAsStream(resourcePath);
        }
        if (null == is && (mbs = JmxUtils.getMBeanServer()) != null && (name = ThreadLocalJawrContext.getJawrConfigMgrObjectName()) != null) {
            try {
                ClassLoader cl2 = mbs.getClassLoaderFor(name);
                is = cl2.getResourceAsStream(resourcePath);
            }
            catch (Exception e) {
                LOGGER.error("Unable to instanciate the Jawr MBean '" + name.getCanonicalName() + "'", (Throwable)e);
            }
        }
        if (null == is) {
            try {
                URL url = ClassLoaderResourceUtils.getResourceURL(resourcePath, source);
                is = new FileInputStream(new File(url.getFile()));
            }
            catch (IOException | ResourceNotFoundException e) {
                throw new FileNotFoundException(resourcePath + " could not be found. ");
            }
        }
        return is;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static URL getResourceURL(String resourcePath, Object source) throws ResourceNotFoundException {
        ClassLoader cl;
        URL url = source.getClass().getResource(resourcePath);
        if (null == url && null != (cl = source.getClass().getClassLoader())) {
            url = cl.getResource(resourcePath);
        }
        if (null == url) {
            url = Thread.currentThread().getContextClassLoader().getResource(resourcePath);
            if (null == url) {
                ClassLoader threadClassLoader = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(source.getClass().getClassLoader());
                    if (Thread.currentThread().getContextClassLoader() != null) {
                        url = Thread.currentThread().getContextClassLoader().getResource(resourcePath);
                    }
                }
                finally {
                    Thread.currentThread().setContextClassLoader(threadClassLoader);
                }
            }
            if (null == url) {
                throw new ResourceNotFoundException(resourcePath + " could not be found. ");
            }
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Enumeration<URL> getResources(String resourcePath, Object source) {
        Enumeration<URL> urls;
        block8: {
            urls = null;
            ClassLoader cl = source.getClass().getClassLoader();
            try {
                if (null != cl) {
                    urls = cl.getResources(resourcePath);
                }
                if (null == urls) {
                    urls = Thread.currentThread().getContextClassLoader().getResources(resourcePath);
                }
                if (null != urls) break block8;
                ClassLoader threadClassLoader = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(source.getClass().getClassLoader());
                    if (Thread.currentThread().getContextClassLoader() != null) {
                        urls = Thread.currentThread().getContextClassLoader().getResources(resourcePath);
                    }
                }
                finally {
                    Thread.currentThread().setContextClassLoader(threadClassLoader);
                }
            }
            catch (IOException e) {
                LOGGER.warn("Unable to load " + resourcePath, (Throwable)e);
            }
        }
        return urls;
    }

    public static Object buildObjectInstance(String classname) {
        Class<?> clazz = ClassLoaderResourceUtils.getClass(classname);
        return ClassLoaderResourceUtils.buildObjectInstance(clazz);
    }

    public static Object buildObjectInstance(Class<?> clazz) {
        Object rets = null;
        try {
            rets = clazz.newInstance();
        }
        catch (Exception e) {
            throw new BundlingProcessException(e.getMessage() + " [The custom class " + clazz.getName() + " could not be instantiated, check wether it is available on the classpath and" + " verify that it has a zero-arg constructor].\n" + " The specific error message is: " + e.getClass().getName() + ":" + e.getMessage(), e);
        }
        return rets;
    }

    public static boolean isClassPresent(String classname) {
        try {
            Class.forName(classname);
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public static Class<?> getClass(String classname) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(classname);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (null == clazz) {
            Exception classNotFoundEx = null;
            try {
                clazz = Class.forName(classname, true, new ClassLoaderResourceUtils().getClass().getClassLoader());
            }
            catch (Exception e) {
                classNotFoundEx = e;
            }
            if (null == clazz) {
                ClassLoader threadClassLoader = Thread.currentThread().getContextClassLoader();
                if (null != threadClassLoader) {
                    try {
                        clazz = Class.forName(classname, true, threadClassLoader);
                    }
                    catch (Exception e) {
                        throw new BundlingProcessException(e.getMessage() + " [The custom class " + classname + " could not be instantiated, check wether it is available on the classpath and" + " verify that it has a zero-arg constructor].\n" + " The specific error message is: " + e.getClass().getName() + ":" + e.getMessage(), e);
                    }
                } else {
                    throw new BundlingProcessException(classNotFoundEx.getMessage() + " [The custom class " + classname + " could not be instantiated, check wether it is available on the classpath and" + " verify that it has a zero-arg constructor].\n" + " The specific error message is: " + classNotFoundEx.getClass().getName() + ":" + classNotFoundEx.getMessage(), classNotFoundEx);
                }
            }
        }
        return clazz;
    }

    public static Object buildObjectInstance(String classname, Object[] params) {
        Object rets = null;
        Class[] paramTypes = new Class[params.length];
        for (int x = 0; x < params.length; ++x) {
            paramTypes[x] = params[x].getClass();
        }
        try {
            Class<?> clazz = ClassLoaderResourceUtils.getClass(classname);
            rets = clazz.getConstructor(paramTypes).newInstance(params);
        }
        catch (Exception e) {
            throw new BundlingProcessException(e.getMessage() + " [The custom class " + classname + " could not be instantiated, check wether it is available on the classpath and" + " verify that it has a zero-arg constructor].\n" + " The specific error message is: " + e.getClass().getName() + ":" + e.getMessage(), e);
        }
        return rets;
    }
}

