/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle.factory.util;

import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import net.jawr.web.exception.InterruptBundlingProcessException;
import net.jawr.web.resource.bundle.factory.util.ConfigChangeListener;
import net.jawr.web.resource.bundle.factory.util.ConfigPropertiesSource;
import net.jawr.web.resource.bundle.handler.ResourceBundlesHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigChangeListenerThread
extends Thread
implements Serializable {
    private static final long serialVersionUID = -7816209592970823852L;
    private static final Logger LOGGER = LoggerFactory.getLogger((String)ConfigChangeListenerThread.class.getName());
    private final long waitMillis;
    private final ConfigPropertiesSource propertiesSource;
    private final Properties overriddenProperties;
    private ConfigChangeListener listener;
    private ResourceBundlesHandler bundlesHandler;
    private boolean continuePolling;

    public ConfigChangeListenerThread(String resourceType, ConfigPropertiesSource propertiesSource, Properties overriddenProperties, ConfigChangeListener listener, ResourceBundlesHandler bundlesHandler, long secondsToWait) {
        super(resourceType + " Config Change listener Thread");
        this.propertiesSource = propertiesSource;
        this.overriddenProperties = overriddenProperties;
        this.listener = listener;
        this.bundlesHandler = bundlesHandler;
        this.waitMillis = secondsToWait * 1000L;
        this.continuePolling = true;
    }

    @Override
    public void run() {
        boolean firstRun = true;
        while (this.continuePolling) {
            try {
                if (!firstRun) {
                    if (this.propertiesSource.configChanged()) {
                        Properties props = this.propertiesSource.getConfigProperties();
                        if (this.overriddenProperties != null) {
                            props.putAll((Map<?, ?>)this.overriddenProperties);
                        }
                        this.listener.configChanged(props);
                    } else if (this.bundlesHandler != null && this.bundlesHandler.bundlesNeedToBeRebuild()) {
                        this.listener.rebuildDirtyBundles();
                    }
                }
                ConfigChangeListenerThread.sleep(this.waitMillis);
                firstRun = false;
            }
            catch (InterruptedException e) {
            }
            catch (InterruptBundlingProcessException e) {
                if (!LOGGER.isInfoEnabled()) continue;
                LOGGER.info("Bundling processed stopped");
            }
        }
        this.bundlesHandler = null;
        this.listener = null;
    }

    public void stopPolling() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Stopping the configuration change polling");
        }
        this.continuePolling = false;
    }
}

