/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle.factory.util;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import net.jawr.web.exception.BundlingProcessException;
import net.jawr.web.resource.bundle.IOUtils;
import net.jawr.web.resource.bundle.factory.util.PropsFilePropertiesSource;

public class JsonPropertiesSource
extends PropsFilePropertiesSource {
    private static final String FIELD_NAME_SEPARATOR = ".";
    private static final String ARRAY_VALUE_SEPARATOR = ",";

    private void generateProperties(JsonNode node, String parentPrefix, Properties props) {
        Iterator fields = node.fields();
        while (fields.hasNext()) {
            String nodePrefix;
            Map.Entry entry = (Map.Entry)fields.next();
            String fieldName = (String)entry.getKey();
            JsonNode jsonNode = (JsonNode)entry.getValue();
            String string = nodePrefix = parentPrefix == null ? fieldName : parentPrefix + FIELD_NAME_SEPARATOR + fieldName;
            if (jsonNode.isTextual() || jsonNode.isBoolean()) {
                props.put(nodePrefix, jsonNode.asText());
            } else if (jsonNode.isNumber()) {
                props.put(nodePrefix, Integer.toString(jsonNode.asInt()));
            } else if (jsonNode.isArray()) {
                String arrayValue = this.convertToString(jsonNode);
                props.put(nodePrefix, arrayValue);
            }
            this.generateProperties(jsonNode, nodePrefix, props);
        }
    }

    @Override
    protected void loadConfig(Properties props, String path, InputStream is) {
        try {
            String jsonContent = IOUtils.toString(is);
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
            JsonNode node = mapper.readTree(jsonContent);
            this.generateProperties(node, null, props);
        }
        catch (JsonParseException e) {
            throw new BundlingProcessException("jawr configuration could not be loaded at " + path + FIELD_NAME_SEPARATOR, e);
        }
        catch (IOException e) {
            throw new BundlingProcessException("jawr configuration could not be loaded at " + path + FIELD_NAME_SEPARATOR, e);
        }
    }

    private String convertToString(JsonNode jsonArrayNode) {
        StringBuilder strBuilder = new StringBuilder();
        Iterator nodeIterator = jsonArrayNode.iterator();
        while (nodeIterator.hasNext()) {
            JsonNode jsonNode = (JsonNode)nodeIterator.next();
            strBuilder.append(jsonNode.asText());
            if (!nodeIterator.hasNext()) continue;
            strBuilder.append(ARRAY_VALUE_SEPARATOR);
        }
        return strBuilder.toString();
    }
}

