/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle.factory.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.jawr.web.resource.bundle.variant.VariantSet;
import net.jawr.web.util.StringUtils;

public class PropertiesConfigHelper {
    private final Properties props;
    private final String prefix;
    private final Pattern bundleNamePattern;
    private final Pattern postProcessorClassPattern = Pattern.compile("(jawr\\.custom\\.postprocessors\\.)([-_a-zA-Z0-9]+).class");
    private final Pattern globalPreProcessorClassPattern = Pattern.compile("(jawr\\.custom\\.global\\.preprocessor\\.)([-_a-zA-Z0-9]+).class");
    private final Pattern globalPostProcessorClassPattern = Pattern.compile("(jawr\\.custom\\.global\\.postprocessor\\.)([-_a-zA-Z0-9]+).class");

    public PropertiesConfigHelper(Properties props, String resourceType) {
        this.props = props;
        this.prefix = "jawr." + resourceType + ".";
        String bundle = this.prefix + "bundle.";
        String pattern = "(" + bundle.replaceAll("\\.", "\\\\.") + ")([-_a-zA-Z0-9]+)\\.id";
        this.bundleNamePattern = Pattern.compile(pattern);
    }

    public String getCommonProperty(String key, String defaultValue) {
        return this.props.getProperty("jawr." + key, defaultValue);
    }

    public String getCommonProperty(String key) {
        return this.props.getProperty("jawr." + key);
    }

    public Set<String> getCommonPropertyAsSet(String key) {
        HashSet<String> propertiesSet = new HashSet<String>();
        StringTokenizer tk = new StringTokenizer(this.props.getProperty("jawr." + key, ""), ",");
        while (tk.hasMoreTokens()) {
            propertiesSet.add(tk.nextToken().trim());
        }
        return propertiesSet;
    }

    public String getCustomBundleProperty(String bundleName, String key, String defaultValue) {
        return this.props.getProperty(this.prefix + "bundle." + bundleName + key, defaultValue);
    }

    public String getCustomBundleProperty(String bundleName, String key) {
        return this.props.getProperty(this.prefix + "bundle." + bundleName + key);
    }

    public boolean getCustomBundleBooleanProperty(String bundleName, String key) {
        return Boolean.parseBoolean(this.props.getProperty(this.prefix + "bundle." + bundleName + key, "false"));
    }

    public List<String> getCustomBundlePropertyAsList(String bundleName, String key) {
        ArrayList<String> propertiesList = new ArrayList<String>();
        StringTokenizer tk = new StringTokenizer(this.getCustomBundleProperty(bundleName, key, ""), ",");
        while (tk.hasMoreTokens()) {
            propertiesList.add(tk.nextToken().trim());
        }
        return propertiesList;
    }

    public Set<String> getCustomBundlePropertyAsSet(String bundleName, String key) {
        HashSet<String> propertiesSet = new HashSet<String>();
        StringTokenizer tk = new StringTokenizer(this.getCustomBundleProperty(bundleName, key, ""), ",");
        while (tk.hasMoreTokens()) {
            propertiesSet.add(tk.nextToken().trim());
        }
        return propertiesSet;
    }

    public Map<String, List<String>> getCustomBundlePropertyAsMap(String bundleName, String key) {
        HashMap<String, List<String>> propertiesMap = new HashMap<String, List<String>>();
        StringTokenizer tk = new StringTokenizer(this.getCustomBundleProperty(bundleName, key, ""), ";");
        while (tk.hasMoreTokens()) {
            String[] mapEntry = tk.nextToken().trim().split(":");
            String mapKey = mapEntry[0];
            String values = mapEntry[1];
            StringTokenizer valueTk = new StringTokenizer(values, ",");
            ArrayList<String> valueList = new ArrayList<String>();
            while (valueTk.hasMoreTokens()) {
                valueList.add(valueTk.nextToken().trim());
            }
            propertiesMap.put(mapKey, valueList);
        }
        return propertiesMap;
    }

    public Map<String, VariantSet> getCustomBundleVariantSets(String bundleName) {
        HashMap<String, VariantSet> variantSets = new HashMap<String, VariantSet>();
        StringTokenizer tk = new StringTokenizer(this.getCustomBundleProperty(bundleName, ".variants", ""), ";");
        while (tk.hasMoreTokens()) {
            String[] mapEntry = tk.nextToken().trim().split(":");
            String type = mapEntry[0];
            String defaultVariant = mapEntry[1];
            String values = mapEntry[2];
            String[] variantsArray = StringUtils.split(values, ",");
            ArrayList<String> variants = new ArrayList<String>();
            variants.addAll(Arrays.asList(variantsArray));
            VariantSet variantSet = new VariantSet(type, defaultVariant, variants);
            variantSets.put(type, variantSet);
        }
        return variantSets;
    }

    public Set<String> getPropertyAsSet(String key) {
        HashSet<String> propertiesSet = new HashSet<String>();
        StringTokenizer tk = new StringTokenizer(this.props.getProperty(this.prefix + key, ""), ",");
        while (tk.hasMoreTokens()) {
            propertiesSet.add(tk.nextToken().trim());
        }
        return propertiesSet;
    }

    public String getProperty(String key, String defaultValue) {
        return this.props.getProperty(this.prefix + key, defaultValue);
    }

    public Set<String> getPropertyBundleNameSet() {
        HashSet<String> bundleNameSet = new HashSet<String>();
        for (Object key : this.props.keySet()) {
            Matcher matcher = this.bundleNamePattern.matcher((String)key);
            if (!matcher.matches()) continue;
            String id = matcher.group(2);
            bundleNameSet.add(id);
        }
        return bundleNameSet;
    }

    public Map<String, String> getCustomPostProcessorMap() {
        return this.getCustomMap(this.postProcessorClassPattern);
    }

    public Map<String, String> getCustomGlobalPreprocessorMap() {
        return this.getCustomMap(this.globalPreProcessorClassPattern);
    }

    public Map<String, String> getCustomGlobalPostprocessorMap() {
        return this.getCustomMap(this.globalPostProcessorClassPattern);
    }

    private Map<String, String> getCustomMap(Pattern keyPattern) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String string : this.props.keySet()) {
            Matcher matcher = keyPattern.matcher(string);
            if (!matcher.matches()) continue;
            String id = matcher.group(2);
            String propertyValue = this.props.getProperty(string);
            map.put(id, propertyValue);
        }
        return map;
    }

    public String getProperty(String key) {
        return this.props.getProperty(this.prefix + key);
    }

    public static boolean getBooleanValue(Properties prop, String name, boolean defaultValue) {
        String strProp = prop.getProperty(name, Boolean.toString(defaultValue));
        return Boolean.valueOf(strProp);
    }
}

