/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle.generator;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import net.jawr.web.config.JawrConfig;
import net.jawr.web.exception.BundlingProcessException;
import net.jawr.web.resource.BinaryResourcesHandler;
import net.jawr.web.resource.bundle.IOUtils;
import net.jawr.web.resource.bundle.css.CssImageUrlRewriter;
import net.jawr.web.resource.bundle.factory.util.PathNormalizer;
import net.jawr.web.resource.bundle.generator.AbstractCachedGenerator;
import net.jawr.web.resource.bundle.generator.CssResourceGenerator;
import net.jawr.web.resource.bundle.generator.GeneratorContext;
import net.jawr.web.resource.bundle.generator.SpecificCDNDebugPathResourceGenerator;
import net.jawr.web.util.StringUtils;

public abstract class AbstractCSSGenerator
extends AbstractCachedGenerator
implements SpecificCDNDebugPathResourceGenerator,
CssResourceGenerator {
    private static final String JAWR_BINARY_SERVLET_MAPPING = "jawr.binary.servlet.mapping";
    private static final String JAWR_SERVLET_MAPPING = "jawr.servlet.mapping";

    @Override
    public String getDebugModeRequestPath() {
        return "/jawr_generator.css";
    }

    @Override
    public String getDebugModeBuildTimeGenerationPath(String path) {
        return path.replaceFirst(":", "/");
    }

    @Override
    protected Reader generateResourceForDebug(Reader rd, GeneratorContext context) {
        StringWriter writer = new StringWriter();
        try {
            IOUtils.copy(rd, (Writer)writer);
            String content = this.rewriteUrl(context, writer.toString());
            rd = new StringReader(content);
        }
        catch (IOException e) {
            throw new BundlingProcessException(e);
        }
        return rd;
    }

    protected String rewriteUrl(GeneratorContext context, String content) throws IOException {
        JawrConfig jawrConfig = context.getConfig();
        CssImageUrlRewriter rewriter = new CssImageUrlRewriter(jawrConfig);
        String bundlePath = PathNormalizer.joinPaths(jawrConfig.getServletMapping(), "/jawr_generator.css");
        StringBuffer result = rewriter.rewriteUrl(context.getPath(), bundlePath, content);
        return result.toString();
    }

    @Override
    public boolean isHandlingCssImage() {
        return false;
    }

    @Override
    protected void resetCache() {
        super.resetCache();
        this.cacheProperties.put(JAWR_SERVLET_MAPPING, this.config.getServletMapping());
        String binaryServletMapping = this.getBinaryServletMapping();
        if (binaryServletMapping != null) {
            this.cacheProperties.put(JAWR_BINARY_SERVLET_MAPPING, binaryServletMapping);
        } else {
            this.cacheProperties.remove(JAWR_BINARY_SERVLET_MAPPING);
        }
        this.cacheProperties.put("jawr.css.classpath.handle.image", Boolean.toString(this.config.isCssClasspathImageHandledByClasspathCss()));
        this.cacheProperties.put("jawr.binary.hash.algorithm", this.config.getBinaryHashAlgorithm());
    }

    @Override
    protected boolean isCacheValid() {
        boolean isValid = false;
        String servletMapping = this.config.getServletMapping();
        String binaryServletMapping = this.getBinaryServletMapping();
        if (super.isCacheValid() && StringUtils.equals(servletMapping, this.cacheProperties.getProperty(JAWR_SERVLET_MAPPING)) && StringUtils.equals(binaryServletMapping, this.cacheProperties.getProperty(JAWR_BINARY_SERVLET_MAPPING)) && StringUtils.equals(Boolean.toString(this.config.isCssClasspathImageHandledByClasspathCss()), this.cacheProperties.getProperty("jawr.css.classpath.handle.image")) && StringUtils.equals(this.cacheProperties.getProperty("jawr.binary.hash.algorithm"), this.config.getBinaryHashAlgorithm())) {
            isValid = true;
        }
        return isValid;
    }

    private String getBinaryServletMapping() {
        String binaryServletMapping = null;
        BinaryResourcesHandler binaryRsHandler = (BinaryResourcesHandler)this.config.getContext().getAttribute("net.jawr.web.resource.bundle.BINARY_CONTEXT_ATTRIBUTE");
        if (binaryRsHandler != null) {
            binaryServletMapping = binaryRsHandler.getConfig().getServletMapping();
        }
        return binaryServletMapping;
    }
}

