/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle.generator;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import net.jawr.web.config.JawrConfig;
import net.jawr.web.exception.BundlingProcessException;
import net.jawr.web.resource.bundle.IOUtils;
import net.jawr.web.resource.bundle.JoinableResourceBundle;
import net.jawr.web.resource.bundle.generator.CachedGenerator;
import net.jawr.web.resource.bundle.generator.ConfigurationAwareResourceGenerator;
import net.jawr.web.resource.bundle.generator.GeneratorContext;
import net.jawr.web.resource.bundle.generator.PostInitializationAwareResourceGenerator;
import net.jawr.web.resource.bundle.generator.ResourceReaderHandlerAwareResourceGenerator;
import net.jawr.web.resource.bundle.generator.TextResourceGenerator;
import net.jawr.web.resource.bundle.lifecycle.BundlingProcessLifeCycleListener;
import net.jawr.web.resource.bundle.locale.LocaleUtils;
import net.jawr.web.resource.bundle.mappings.FilePathMapping;
import net.jawr.web.resource.handler.reader.ResourceReaderHandler;
import net.jawr.web.resource.handler.reader.WorkingDirectoryLocationAware;
import net.jawr.web.util.StopWatch;
import net.jawr.web.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCachedGenerator
implements TextResourceGenerator,
ConfigurationAwareResourceGenerator,
PostInitializationAwareResourceGenerator,
WorkingDirectoryLocationAware,
ResourceReaderHandlerAwareResourceGenerator,
BundlingProcessLifeCycleListener {
    private static final Logger PERF_LOGGER = LoggerFactory.getLogger((String)"net.jawr.perf.processing");
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractCachedGenerator.class);
    private static final String SEMICOLON = ";";
    private static final String MAPPING_TIMESTAMP_SEPARATOR = "#";
    private static final String JAWR_MAPPING_PREFIX = "jawr.cache.mapping.";
    protected ResourceReaderHandler rsHandler;
    protected String workingDir;
    protected String name;
    protected String cacheMappingFileName;
    protected String cacheDirectory;
    protected boolean useCache = false;
    protected CachedGenerator.CacheMode cacheMode;
    protected Properties cacheProperties = new Properties();
    protected JawrConfig config;
    protected Map<String, List<FilePathMapping>> linkedResourceMap = new ConcurrentHashMap<String, List<FilePathMapping>>();

    @Override
    public void setWorkingDirectory(String workingDir) {
        this.workingDir = workingDir;
        if (!this.workingDir.endsWith("/")) {
            this.workingDir = this.workingDir + "/";
        }
    }

    @Override
    public void setConfig(JawrConfig config) {
        this.config = config;
    }

    protected String getGeneratorWorkingDir() {
        return this.workingDir + "generatorCache" + "/";
    }

    @Override
    public void afterPropertiesSet() {
        CachedGenerator annotation;
        if (this.config.isUseGeneratorCache() && (annotation = this.getClass().getAnnotation(CachedGenerator.class)) != null) {
            this.useCache = true;
            this.name = annotation.name();
            this.cacheMappingFileName = annotation.mappingFileName();
            this.cacheDirectory = annotation.cacheDirectory();
            if (!this.cacheDirectory.endsWith("/")) {
                this.cacheDirectory = this.cacheDirectory + "/";
            }
            this.cacheMode = annotation.mode();
            this.loadCacheMapping();
            if (!this.isCacheValid()) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Cache of " + this.getName() + " generator is invalid. Reset cache...");
                }
                this.resetCache();
            }
        }
    }

    @Override
    public void setResourceReaderHandler(ResourceReaderHandler rsHandler) {
        this.rsHandler = rsHandler;
    }

    protected String getTempFilePath(GeneratorContext context, CachedGenerator.CacheMode cacheMode) {
        return this.getTempDirectory() + (Object)((Object)cacheMode) + "/" + this.getResourceCacheKey(context.getPath(), context);
    }

    protected String getTempDirectory() {
        return this.workingDir + "generatorCache" + "/" + this.cacheDirectory + "/";
    }

    protected String getName() {
        return this.name != null ? this.name : this.getClass().getSimpleName();
    }

    @Override
    public Reader createResource(GeneratorContext context) {
        List<FilePathMapping> fMappings;
        String path = context.getPath();
        StopWatch stopWatch = null;
        if (PERF_LOGGER.isDebugEnabled()) {
            stopWatch = new StopWatch("Generating resource '" + path + "' with " + this.getName() + " generator");
            stopWatch.start();
        }
        Reader rd = null;
        if (this.useCache && (fMappings = this.linkedResourceMap.get(this.getResourceCacheKey(path, context))) != null && !this.checkResourcesModified(context, fMappings)) {
            if (context.isProcessingBundle()) {
                if (this.cacheMode.equals((Object)CachedGenerator.CacheMode.PROD) || this.cacheMode.equals((Object)CachedGenerator.CacheMode.ALL)) {
                    rd = this.retrieveFromCache(path, context, CachedGenerator.CacheMode.PROD);
                }
            } else if (this.cacheMode.equals((Object)CachedGenerator.CacheMode.DEBUG) || this.cacheMode.equals((Object)CachedGenerator.CacheMode.ALL)) {
                rd = this.retrieveFromCache(path, context, CachedGenerator.CacheMode.DEBUG);
            }
        }
        if (rd == null) {
            rd = this.generateResource(path, context);
            if (this.useCache && rd != null && (this.cacheMode.equals((Object)CachedGenerator.CacheMode.PROD) || this.cacheMode.equals((Object)CachedGenerator.CacheMode.ALL))) {
                rd = this.createTempResource(context, CachedGenerator.CacheMode.PROD, rd);
            }
            if (context.isProcessingBundle()) {
                if (this.useCache && (this.cacheMode.equals((Object)CachedGenerator.CacheMode.DEBUG) || this.cacheMode.equals((Object)CachedGenerator.CacheMode.ALL))) {
                    String content = null;
                    try {
                        content = IOUtils.toString(rd);
                    }
                    catch (IOException e) {
                        throw new BundlingProcessException(e);
                    }
                    Reader dRd = this.generateResourceForDebug(new StringReader(content), context);
                    this.createTempResource(context, CachedGenerator.CacheMode.DEBUG, dRd);
                    rd = new StringReader(content);
                }
            } else {
                rd = this.generateResourceForDebug(rd, context);
                if (this.useCache && (this.cacheMode.equals((Object)CachedGenerator.CacheMode.DEBUG) || this.cacheMode.equals((Object)CachedGenerator.CacheMode.ALL))) {
                    rd = this.createTempResource(context, CachedGenerator.CacheMode.DEBUG, rd);
                }
            }
        }
        if (PERF_LOGGER.isDebugEnabled()) {
            stopWatch.stop();
            PERF_LOGGER.debug(stopWatch.shortSummary());
        }
        return rd;
    }

    protected String getResourceCacheKey(String path, GeneratorContext context) {
        StringBuilder strbCacheKey = new StringBuilder(path);
        if (StringUtils.isNotEmpty(context.getBracketsParam())) {
            strbCacheKey.append("_").append(context.getBracketsParam());
        }
        if (StringUtils.isNotEmpty(context.getParenthesesParam())) {
            strbCacheKey.append("_").append(context.getParenthesesParam());
        }
        String cacheKey = strbCacheKey.toString();
        Locale locale = context.getLocale();
        if (locale != null) {
            cacheKey = LocaleUtils.toBundleName(strbCacheKey.toString(), locale);
        }
        cacheKey = cacheKey.replaceAll("[^\\w\\.\\-]", "_");
        return cacheKey;
    }

    protected void addLinkedResources(String path, GeneratorContext context, FilePathMapping fMapping) {
        this.addLinkedResources(path, context, Arrays.asList(fMapping));
    }

    protected void addLinkedResources(String path, GeneratorContext context, List<FilePathMapping> fMappings) {
        this.linkedResourceMap.put(this.getResourceCacheKey(path, context), new CopyOnWriteArrayList<FilePathMapping>(fMappings));
        JoinableResourceBundle bundle = context.getBundle();
        if (bundle != null) {
            List<FilePathMapping> bundleFMappings = bundle.getLinkedFilePathMappings();
            for (FilePathMapping fMapping : fMappings) {
                FilePathMapping fm = new FilePathMapping(bundle, fMapping.getPath(), fMapping.getLastModified());
                if (bundleFMappings.contains(fm)) continue;
                bundleFMappings.add(fm);
            }
        }
    }

    protected Reader generateResourceForDebug(Reader rd, GeneratorContext context) {
        return rd;
    }

    protected Reader generateResource(String path, GeneratorContext context) {
        throw new BundlingProcessException("Please override the method if you're using the generator cache feature.");
    }

    protected boolean checkResourcesModified(GeneratorContext context, List<FilePathMapping> fMappings) {
        boolean resourceModified = false;
        Iterator<FilePathMapping> iter = fMappings.iterator();
        while (iter.hasNext() && !resourceModified) {
            FilePathMapping fMapping = iter.next();
            resourceModified = fMapping.getLastModified() != this.rsHandler.getLastModified(fMapping.getPath());
        }
        return resourceModified;
    }

    protected Reader retrieveFromCache(String path, GeneratorContext context, CachedGenerator.CacheMode cacheMode) {
        Reader rd = null;
        String filePath = this.getTempFilePath(context, cacheMode);
        FileInputStream fis = null;
        File file = new File(filePath);
        if (file.exists()) {
            try {
                fis = new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
                throw new BundlingProcessException("An error occured while creating temporary resource for " + filePath, e);
            }
            FileChannel inchannel = fis.getChannel();
            rd = Channels.newReader(inchannel, context.getConfig().getResourceCharset().newDecoder(), -1);
            context.setRetrievedFromCache(true);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(this.getName() + " resource '" + path + "' retrieved from cache");
            }
        }
        return rd;
    }

    protected Reader createTempResource(GeneratorContext context, CachedGenerator.CacheMode cacheMode, Reader rd) {
        String filePath = this.getTempFilePath(context, cacheMode);
        Writer wr = null;
        FileOutputStream fos = null;
        try {
            File f = new File(filePath);
            if (!f.getParentFile().exists()) {
                f.getParentFile().mkdirs();
            }
            String content = IOUtils.toString(rd);
            fos = new FileOutputStream(f);
            FileChannel channel = fos.getChannel();
            wr = Channels.newWriter(channel, this.config.getResourceCharset().newEncoder(), -1);
            wr.write(content);
            rd = new StringReader(content);
        }
        catch (IOException e) {
            try {
                throw new BundlingProcessException("Unable to create temporary resource for '" + context.getPath() + "'", e);
            }
            catch (Throwable throwable) {
                IOUtils.close(wr);
                IOUtils.close(fos);
                throw throwable;
            }
        }
        IOUtils.close(wr);
        IOUtils.close(fos);
        return rd;
    }

    protected void resetCache() {
        this.cacheProperties.clear();
        this.linkedResourceMap.clear();
        this.cacheProperties.put("jawr.charset.name", this.config.getResourceCharset().name());
    }

    protected boolean isCacheValid() {
        return StringUtils.equals(this.cacheProperties.getProperty("jawr.charset.name"), this.config.getResourceCharset().name());
    }

    protected synchronized void serializeCacheMapping() {
        for (Map.Entry<String, List<FilePathMapping>> entry : this.linkedResourceMap.entrySet()) {
            StringBuilder strb = new StringBuilder();
            Iterator<FilePathMapping> iter = entry.getValue().iterator();
            if (!iter.hasNext()) continue;
            while (iter.hasNext()) {
                FilePathMapping fMapping = iter.next();
                strb.append(fMapping.getPath()).append(MAPPING_TIMESTAMP_SEPARATOR).append(fMapping.getLastModified());
                if (!iter.hasNext()) continue;
                strb.append(SEMICOLON);
            }
            this.cacheProperties.put(JAWR_MAPPING_PREFIX + entry.getKey(), strb.toString());
        }
        File f = new File(this.getCacheFilePath());
        if (!f.getParentFile().exists()) {
            f.getParentFile().mkdirs();
        }
        FileWriter fw = null;
        try {
            fw = new FileWriter(f);
            this.cacheProperties.store(fw, "Cache properties of " + this.getName() + " generator");
        }
        catch (IOException e) {
            try {
                throw new BundlingProcessException("Unable to save cache file mapping ", e);
            }
            catch (Throwable throwable) {
                IOUtils.close(fw);
                throw throwable;
            }
        }
        IOUtils.close(fw);
    }

    protected String getCacheFilePath() {
        return this.getTempDirectory() + this.getCacheFileName();
    }

    protected String getCacheFileName() {
        return this.cacheMappingFileName;
    }

    protected void loadCacheMapping() {
        File f = new File(this.getCacheFilePath());
        if (f.exists()) {
            try (FileInputStream is = new FileInputStream(f);
                 BufferedReader rd = new BufferedReader(new FileReader(f));){
                this.cacheProperties.load(is);
                Enumeration<?> properyNames = this.cacheProperties.propertyNames();
                while (properyNames.hasMoreElements()) {
                    String propName = (String)properyNames.nextElement();
                    if (!propName.startsWith(JAWR_MAPPING_PREFIX)) continue;
                    String value = this.cacheProperties.getProperty(propName);
                    String resourceMapping = propName.substring(JAWR_MAPPING_PREFIX.length());
                    String[] mappings = value.split(SEMICOLON);
                    CopyOnWriteArrayList<FilePathMapping> fMappings = new CopyOnWriteArrayList<FilePathMapping>();
                    boolean mappingModified = true;
                    for (String fmapping : mappings) {
                        String[] mapping = fmapping.split(MAPPING_TIMESTAMP_SEPARATOR);
                        long lastModified = Long.parseLong(mapping[1]);
                        String filePath = mapping[0];
                        if (this.rsHandler.getLastModified(filePath) != lastModified) {
                            mappingModified = false;
                            break;
                        }
                        FilePathMapping fmap = new FilePathMapping(filePath, lastModified);
                        fMappings.add(fmap);
                    }
                    if (!mappingModified) continue;
                    this.linkedResourceMap.put(resourceMapping, fMappings);
                }
            }
            catch (IOException e) {
                throw new BundlingProcessException("Unable to initialize " + this.getName() + " Generator cache", e);
            }
        }
    }

    @Override
    public void beforeBundlingProcess() {
    }

    @Override
    public void afterBundlingProcess() {
        if (this.useCache) {
            this.serializeCacheMapping();
        }
    }
}

