/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle.generator;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GeneratorMappingHelper {
    private static final Pattern PARENFINDER_REGEXP = Pattern.compile("(?<!\\\\)\\(([^\\)]*)(?<!\\\\)\\)");
    private static final Pattern BRACKFINDER_REGEXP = Pattern.compile("(?<!\\\\)\\[([^\\]]*)(?<!\\\\)\\]");
    private static final Pattern ESCAPE_STRINGS_REGEXP = Pattern.compile("\\\\(\\(|\\)|\\[|\\])");
    private String path;
    private String parenthesesParam;
    private String bracketsParam;

    public GeneratorMappingHelper(String resourceMapping) {
        this.path = resourceMapping;
        Matcher m = PARENFINDER_REGEXP.matcher(this.path);
        if (m.find()) {
            this.parenthesesParam = m.group(1);
            this.path = m.replaceFirst("");
        }
        if ((m = BRACKFINDER_REGEXP.matcher(this.path)).find()) {
            this.bracketsParam = m.group(1);
            this.path = m.replaceFirst("");
        }
        if ((m = ESCAPE_STRINGS_REGEXP.matcher(this.path)).find()) {
            this.path = m.replaceAll("$1");
        }
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getParenthesesParam() {
        return this.parenthesesParam;
    }

    public void setParenthesesParam(String parenthesesParam) {
        this.parenthesesParam = parenthesesParam;
    }

    public String getBracketsParam() {
        return this.bracketsParam;
    }

    public void setBracketsParam(String bracketsParam) {
        this.bracketsParam = bracketsParam;
    }
}

