/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle.generator;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import net.jawr.web.config.JawrConfig;
import net.jawr.web.exception.BundlingProcessException;
import net.jawr.web.resource.bundle.JoinableResourceBundle;
import net.jawr.web.resource.bundle.factory.util.ClassLoaderResourceUtils;
import net.jawr.web.resource.bundle.generator.ConfigurationAwareResourceGenerator;
import net.jawr.web.resource.bundle.generator.CssResourceGenerator;
import net.jawr.web.resource.bundle.generator.GeneratorComparator;
import net.jawr.web.resource.bundle.generator.IECssBundleGenerator;
import net.jawr.web.resource.bundle.generator.InitializingResourceGenerator;
import net.jawr.web.resource.bundle.generator.LocaleAwareResourceGenerator;
import net.jawr.web.resource.bundle.generator.PathMappingProvider;
import net.jawr.web.resource.bundle.generator.PostInitializationAwareResourceGenerator;
import net.jawr.web.resource.bundle.generator.ResourceGenerator;
import net.jawr.web.resource.bundle.generator.ResourceGeneratorReaderProxyFactory;
import net.jawr.web.resource.bundle.generator.ResourceReaderHandlerAwareResourceGenerator;
import net.jawr.web.resource.bundle.generator.SkinSwitcherJsGenerator;
import net.jawr.web.resource.bundle.generator.SpecificCDNDebugPathResourceGenerator;
import net.jawr.web.resource.bundle.generator.StreamResourceGenerator;
import net.jawr.web.resource.bundle.generator.TypeAwareResourceGenerator;
import net.jawr.web.resource.bundle.generator.classpath.ClassPathBinaryResourceGenerator;
import net.jawr.web.resource.bundle.generator.classpath.ClassPathCSSGenerator;
import net.jawr.web.resource.bundle.generator.classpath.ClasspathJSGenerator;
import net.jawr.web.resource.bundle.generator.classpath.webjars.WebJarsBinaryResourceGenerator;
import net.jawr.web.resource.bundle.generator.classpath.webjars.WebJarsCssGenerator;
import net.jawr.web.resource.bundle.generator.classpath.webjars.WebJarsJSGenerator;
import net.jawr.web.resource.bundle.generator.classpath.webjars.WebJarsLocatorBinaryResourceGenerator;
import net.jawr.web.resource.bundle.generator.classpath.webjars.WebJarsLocatorCssGenerator;
import net.jawr.web.resource.bundle.generator.classpath.webjars.WebJarsLocatorJSGenerator;
import net.jawr.web.resource.bundle.generator.css.less.LessCssGenerator;
import net.jawr.web.resource.bundle.generator.css.sass.ruby.SassRubyGenerator;
import net.jawr.web.resource.bundle.generator.css.sass.vaadin.SassVaadinGenerator;
import net.jawr.web.resource.bundle.generator.img.SpriteGenerator;
import net.jawr.web.resource.bundle.generator.js.coffee.CoffeeScriptGenerator;
import net.jawr.web.resource.bundle.generator.resolver.PrefixedPathResolver;
import net.jawr.web.resource.bundle.generator.resolver.ResourceGeneratorResolver;
import net.jawr.web.resource.bundle.generator.resolver.ResourceGeneratorResolverWrapper;
import net.jawr.web.resource.bundle.generator.resolver.SuffixedPathResolver;
import net.jawr.web.resource.bundle.generator.validator.CommonsValidatorGenerator;
import net.jawr.web.resource.bundle.generator.variant.VariantResourceGenerator;
import net.jawr.web.resource.bundle.generator.variant.css.CssSkinGenerator;
import net.jawr.web.resource.bundle.lifecycle.BundlingProcessLifeCycleListener;
import net.jawr.web.resource.bundle.locale.ResourceBundleMessagesGenerator;
import net.jawr.web.resource.bundle.mappings.PathMapping;
import net.jawr.web.resource.bundle.variant.VariantResolver;
import net.jawr.web.resource.bundle.variant.VariantSet;
import net.jawr.web.resource.handler.reader.ResourceReader;
import net.jawr.web.resource.handler.reader.ResourceReaderHandler;
import net.jawr.web.resource.handler.reader.WorkingDirectoryLocationAware;
import net.jawr.web.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneratorRegistry
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(GeneratorRegistry.class);
    private static final long serialVersionUID = -7988265144352433701L;
    public static final String MESSAGE_BUNDLE_PREFIX = "messages";
    public static final String CLASSPATH_RESOURCE_BUNDLE_PREFIX = "jar";
    public static final String WEBJARS_GENERATOR_PREFIX = "webjars";
    public static final String WEBJARS_LOCATOR_CLASSNAME = "org.webjars.WebJarAssetLocator";
    public static final String COMMONS_VALIDATOR_PREFIX = "acv";
    public static final String IE_CSS_GENERATOR_PREFIX = "ieCssGen";
    public static final String SPRITE_GENERATOR_PREFIX = "sprite";
    public static final String SKIN_GENERATOR_PREFIX = "skin";
    public static final String SKIN_SWTICHER_GENERATOR_PREFIX = "skinSwitcher";
    public static final String COFEESCRIPT_GENERATOR_SUFFIX = "coffee";
    public static final String LESS_GENERATOR_SUFFIX = "less";
    public static final String SASS_GENERATOR_SUFFIX = "scss";
    public static final String PREFIX_SEPARATOR = ":";
    private final Map<ResourceGeneratorResolver, Class<?>> commonGenerators = new ConcurrentHashMap();
    private final List<ResourceGeneratorResolverWrapper> resolverRegistry = new ArrayList<ResourceGeneratorResolverWrapper>();
    private final List<ResourceGenerator> cssImageResourceGeneratorRegistry = new ArrayList<ResourceGenerator>();
    private final List<ResourceGenerator> binaryResourceGeneratorRegistry = new ArrayList<ResourceGenerator>();
    private final List<BundlingProcessLifeCycleListener> bundlingProcesslifeCycleListeners = new ArrayList<BundlingProcessLifeCycleListener>();
    private String resourceType;
    private JawrConfig config;
    private ResourceReaderHandler rsHandler;
    private final Map<String, VariantResolver> variantResolvers = new ConcurrentHashMap<String, VariantResolver>();
    public static final String WEBJARS_GENERATOR_HELPER_PREFIX = "/META-INF/resources/webjars/";

    public GeneratorRegistry() {
        this("js");
    }

    public GeneratorRegistry(String resourceType) {
        this.resourceType = resourceType;
    }

    protected void initCommonGenerators() {
        this.commonGenerators.put(new PrefixedPathResolver(MESSAGE_BUNDLE_PREFIX), ResourceBundleMessagesGenerator.class);
        Class classPathGeneratorClass = null;
        Class webJarsGeneratorClass = null;
        boolean isWebJarsLocatorPresent = ClassLoaderResourceUtils.isClassPresent(WEBJARS_LOCATOR_CLASSNAME);
        if (this.resourceType.equals("js")) {
            classPathGeneratorClass = ClasspathJSGenerator.class;
            webJarsGeneratorClass = isWebJarsLocatorPresent ? WebJarsLocatorJSGenerator.class : WebJarsJSGenerator.class;
        } else if (this.resourceType.equals("css")) {
            classPathGeneratorClass = ClassPathCSSGenerator.class;
            webJarsGeneratorClass = isWebJarsLocatorPresent ? WebJarsLocatorCssGenerator.class : WebJarsCssGenerator.class;
        } else {
            classPathGeneratorClass = ClassPathBinaryResourceGenerator.class;
            webJarsGeneratorClass = isWebJarsLocatorPresent ? WebJarsLocatorBinaryResourceGenerator.class : WebJarsBinaryResourceGenerator.class;
        }
        this.commonGenerators.put(new PrefixedPathResolver(CLASSPATH_RESOURCE_BUNDLE_PREFIX), classPathGeneratorClass);
        this.commonGenerators.put(new PrefixedPathResolver(WEBJARS_GENERATOR_PREFIX), webJarsGeneratorClass);
        if (this.resourceType.equals("js")) {
            this.commonGenerators.put(new PrefixedPathResolver(COMMONS_VALIDATOR_PREFIX), CommonsValidatorGenerator.class);
            this.commonGenerators.put(new PrefixedPathResolver(SKIN_SWTICHER_GENERATOR_PREFIX), SkinSwitcherJsGenerator.class);
            this.commonGenerators.put(new SuffixedPathResolver(COFEESCRIPT_GENERATOR_SUFFIX), CoffeeScriptGenerator.class);
        }
        if (this.resourceType.equals("css")) {
            this.commonGenerators.put(new PrefixedPathResolver(IE_CSS_GENERATOR_PREFIX), IECssBundleGenerator.class);
            this.commonGenerators.put(new PrefixedPathResolver(SKIN_GENERATOR_PREFIX), CssSkinGenerator.class);
            this.commonGenerators.put(new SuffixedPathResolver(LESS_GENERATOR_SUFFIX), LessCssGenerator.class);
            String sassGenerator = this.config.getProperty("jawr.css.sass.generator", "vaadin");
            if (!sassGenerator.equals("vaadin") && !sassGenerator.equals("ruby")) {
                throw new BundlingProcessException("The value '" + sassGenerator + "' is not allowed for property '" + "jawr.css.sass.generator" + "'. Please check your configuration.");
            }
            if (sassGenerator.equals("vaadin")) {
                this.commonGenerators.put(new SuffixedPathResolver(SASS_GENERATOR_SUFFIX), SassVaadinGenerator.class);
            } else {
                this.commonGenerators.put(new SuffixedPathResolver(SASS_GENERATOR_SUFFIX), SassRubyGenerator.class);
            }
        }
        if (this.resourceType.equals("css") || this.resourceType.equals("binary")) {
            this.commonGenerators.put(new PrefixedPathResolver(SPRITE_GENERATOR_PREFIX), SpriteGenerator.class);
        }
    }

    public void setConfig(JawrConfig config) {
        this.config = config;
        this.initCommonGenerators();
    }

    public void setResourceReaderHandler(ResourceReaderHandler rsHandler) {
        this.rsHandler = rsHandler;
    }

    private ResourceGenerator loadCommonGenerator(String resourcePath) {
        ResourceGenerator generator = null;
        for (Map.Entry<ResourceGeneratorResolver, Class<?>> entry : this.commonGenerators.entrySet()) {
            ResourceGeneratorResolver resolver = entry.getKey();
            if (!resolver.matchPath(resourcePath)) continue;
            generator = (ResourceGenerator)ClassLoaderResourceUtils.buildObjectInstance(entry.getValue());
            if (!generator.getResolver().isSameAs(resolver)) {
                throw new BundlingProcessException("The resolver defined for " + generator.getClass().getName() + " is different from the one expected by Jawr.");
            }
            if (!resolver.getType().equals((Object)ResourceGeneratorResolver.ResolverType.PREFIXED)) continue;
            this.loadGeneratorIfNeeded(resolver.getResourcePath(resourcePath));
        }
        if (generator != null) {
            this.initGenerator(generator);
        }
        return generator;
    }

    private void initGenerator(ResourceGenerator generator) {
        this.initializeGeneratorProperties(generator);
        this.updateRegistries(generator);
        ResourceReader proxy = ResourceGeneratorReaderProxyFactory.getResourceReaderProxy(generator, this.rsHandler, this.config);
        this.rsHandler.addResourceReader(proxy);
    }

    private void updateRegistries(ResourceGenerator generator) {
        this.resolverRegistry.add(new ResourceGeneratorResolverWrapper(generator, generator.getResolver()));
        GeneratorComparator genComparator = new GeneratorComparator();
        Collections.sort(this.resolverRegistry);
        if (generator instanceof StreamResourceGenerator) {
            this.binaryResourceGeneratorRegistry.add(generator);
            Collections.sort(this.binaryResourceGeneratorRegistry, genComparator);
        }
        if (generator instanceof CssResourceGenerator && ((CssResourceGenerator)generator).isHandlingCssImage()) {
            this.cssImageResourceGeneratorRegistry.add(generator);
            Collections.sort(this.cssImageResourceGeneratorRegistry, genComparator);
        }
        if (generator instanceof BundlingProcessLifeCycleListener) {
            this.bundlingProcesslifeCycleListeners.add((BundlingProcessLifeCycleListener)((Object)generator));
        }
    }

    public void registerVariantResolver(String clazz) {
        VariantResolver resolver = (VariantResolver)ClassLoaderResourceUtils.buildObjectInstance(clazz);
        this.registerVariantResolver(resolver);
    }

    public void registerVariantResolver(VariantResolver resolver) {
        for (VariantResolver variantResolver : this.variantResolvers.values()) {
            if (StringUtils.isEmpty(resolver.getVariantType())) {
                throw new IllegalStateException("The getVariantType() method must return something at " + resolver.getClass());
            }
            if (!resolver.getVariantType().equals(variantResolver.getVariantType())) continue;
            throw new IllegalStateException("There are 2 resolvers defined for the variant type '" + resolver.getVariantType() + "' : " + variantResolver.getClass() + ";" + resolver.getClass());
        }
        this.variantResolvers.put(resolver.getVariantType(), resolver);
    }

    public VariantResolver getVariantResolver(String variantType) {
        return this.variantResolvers.get(variantType);
    }

    public void registerGenerator(String clazz) {
        ResourceGenerator generator = (ResourceGenerator)ClassLoaderResourceUtils.buildObjectInstance(clazz);
        if (null == generator.getResolver()) {
            throw new IllegalStateException("The getResolver() method must return something at " + clazz);
        }
        ResourceGeneratorResolver resolver = generator.getResolver();
        for (ResourceGeneratorResolver resourceGeneratorResolver : this.resolverRegistry) {
            String generatorName;
            if (!resourceGeneratorResolver.isSameAs(resolver) || clazz.equals(generatorName = generator.getClass().getName())) continue;
            String errorMsg = "Cannot register the generator of class " + generator.getClass().getName() + " since the same resolver is being used by " + generatorName + ". Please specify a different resolver in the getResolver() method.";
            throw new IllegalStateException(errorMsg);
        }
        Set<ResourceGeneratorResolver> commonResolvers = this.commonGenerators.keySet();
        for (ResourceGeneratorResolver commonGeneratorResolver : commonResolvers) {
            if (!commonGeneratorResolver.isSameAs(resolver)) continue;
            String generatorName = generator.getClass().getName();
            LOGGER.warn("The custom generator '" + generatorName + "' override a built-in generator");
        }
        this.initGenerator(generator);
    }

    private void initializeGeneratorProperties(ResourceGenerator generator) {
        if (generator instanceof InitializingResourceGenerator) {
            if (generator instanceof ConfigurationAwareResourceGenerator) {
                ((ConfigurationAwareResourceGenerator)generator).setConfig(this.config);
            }
            if (generator instanceof TypeAwareResourceGenerator) {
                ((TypeAwareResourceGenerator)generator).setResourceType(this.resourceType);
            }
            if (generator instanceof ResourceReaderHandlerAwareResourceGenerator) {
                ((ResourceReaderHandlerAwareResourceGenerator)generator).setResourceReaderHandler(this.rsHandler);
            }
            if (generator instanceof WorkingDirectoryLocationAware) {
                ((WorkingDirectoryLocationAware)((Object)generator)).setWorkingDirectory(this.rsHandler.getWorkingDirectory());
            }
            if (generator instanceof PostInitializationAwareResourceGenerator) {
                ((PostInitializationAwareResourceGenerator)generator).afterPropertiesSet();
            }
        }
    }

    public boolean isPathGenerated(String path) {
        return null != this.resolveResourceGenerator(path);
    }

    public String getDebugModeGenerationPath(String path) {
        ResourceGenerator resourceGenerator = this.resolveResourceGenerator(path);
        return resourceGenerator.getDebugModeRequestPath();
    }

    public String getDebugModeBuildTimeGenerationPath(String path) {
        int idx = path.indexOf("?");
        String debugModeGeneratorPath = path.substring(0, idx);
        debugModeGeneratorPath = debugModeGeneratorPath.replaceAll("\\.", "/");
        int jawrGenerationParamIdx = path.indexOf("generationConfigParam");
        String parameter = path.substring(jawrGenerationParamIdx + "generationConfigParam".length() + 1);
        ResourceGenerator resourceGenerator = this.resolveResourceGenerator(parameter);
        String suffixPath = null;
        suffixPath = resourceGenerator instanceof SpecificCDNDebugPathResourceGenerator ? ((SpecificCDNDebugPathResourceGenerator)resourceGenerator).getDebugModeBuildTimeGenerationPath(parameter) : parameter.replaceFirst(PREFIX_SEPARATOR, "/");
        return debugModeGeneratorPath + "/" + suffixPath;
    }

    private ResourceGenerator resolveResourceGenerator(String path) {
        ResourceGenerator resourceGenerator = null;
        for (ResourceGeneratorResolverWrapper resolver : this.resolverRegistry) {
            if (!resolver.matchPath(path)) continue;
            resourceGenerator = resolver.getResourceGenerator();
            if (!resolver.getType().equals((Object)ResourceGeneratorResolver.ResolverType.PREFIXED)) break;
            this.loadGeneratorIfNeeded(resolver.getResourcePath(path));
            break;
        }
        if (resourceGenerator == null) {
            resourceGenerator = this.loadCommonGenerator(path);
        }
        return resourceGenerator;
    }

    public ResourceGenerator getResourceGenerator(String path) {
        ResourceGenerator resourceGenerator = null;
        for (ResourceGeneratorResolverWrapper resolver : this.resolverRegistry) {
            if (!resolver.matchPath(path)) continue;
            resourceGenerator = resolver.getResourceGenerator();
            if (!resolver.getType().equals((Object)ResourceGeneratorResolver.ResolverType.PREFIXED)) break;
            this.loadGeneratorIfNeeded(resolver.getResourcePath(path));
            break;
        }
        if (resourceGenerator == null) {
            throw new BundlingProcessException("No ResourceGenerator found for the path :" + path);
        }
        return resourceGenerator;
    }

    public void loadGeneratorIfNeeded(String path) {
        this.resolveResourceGenerator(path);
    }

    public Map<String, VariantSet> getAvailableVariants(String path) {
        Map<String, VariantSet> availableVariants = new TreeMap<String, VariantSet>();
        ResourceGenerator generator = this.resolveResourceGenerator(path);
        if (generator != null) {
            List<String> availableLocales;
            if (generator instanceof VariantResourceGenerator) {
                Map<String, VariantSet> tempResult = ((VariantResourceGenerator)generator).getAvailableVariants(generator.getResolver().getResourcePath(path));
                if (tempResult != null) {
                    availableVariants = tempResult;
                }
            } else if (generator instanceof LocaleAwareResourceGenerator && (availableLocales = ((LocaleAwareResourceGenerator)generator).getAvailableLocales(generator.getResolver().getResourcePath(path))) != null) {
                VariantSet variantSet = new VariantSet("locale", "", availableLocales);
                availableVariants.put("locale", variantSet);
            }
        }
        return availableVariants;
    }

    public Set<String> getGeneratedResourceVariantTypes(String path) {
        Set<String> variantTypes = new HashSet<String>();
        ResourceGenerator generator = this.resolveResourceGenerator(path);
        if (generator != null) {
            if (generator instanceof VariantResourceGenerator) {
                Set<String> tempResult = ((VariantResourceGenerator)generator).getAvailableVariants(generator.getResolver().getResourcePath(path)).keySet();
                if (tempResult != null) {
                    variantTypes = tempResult;
                }
            } else if (generator instanceof LocaleAwareResourceGenerator) {
                variantTypes = new HashSet();
                variantTypes.add("locale");
            }
        }
        return variantTypes;
    }

    public boolean isHandlingCssImage(String cssResourcePath) {
        boolean isHandlingCssImage = false;
        ResourceGenerator generator = this.resolveResourceGenerator(cssResourcePath);
        if (generator != null && this.cssImageResourceGeneratorRegistry.contains(generator)) {
            isHandlingCssImage = true;
        }
        return isHandlingCssImage;
    }

    public boolean isGeneratedBinaryResource(String resourcePath) {
        boolean isGeneratedImage = false;
        ResourceGenerator generator = this.resolveResourceGenerator(resourcePath);
        if (generator != null && this.binaryResourceGeneratorRegistry.contains(generator)) {
            isGeneratedImage = true;
        }
        return isGeneratedImage;
    }

    public Map<String, String> resolveVariants(HttpServletRequest request) {
        TreeMap<String, String> variants = new TreeMap<String, String>();
        for (VariantResolver resolver : this.variantResolvers.values()) {
            String value = resolver.resolveVariant(request);
            if (value == null) continue;
            variants.put(resolver.getVariantType(), value);
        }
        return variants;
    }

    public Map<String, String> getAvailableVariantMap(Map<String, VariantSet> variants, Map<String, String> curVariants) {
        HashMap<String, String> availableVariantMap = new HashMap<String, String>();
        for (Map.Entry<String, VariantSet> entry : variants.entrySet()) {
            String variantType = entry.getKey();
            VariantSet variantSet = entry.getValue();
            String variant = variantSet.getDefaultVariant();
            if (curVariants.containsKey(variantType)) {
                String curVariant = curVariants.get(variantType);
                VariantResolver resolver = this.variantResolvers.get(variantType);
                if (resolver != null) {
                    variant = resolver.getAvailableVariant(curVariant, variants.get(variantType));
                    if (variant == null) {
                        variant = variants.get(variantType).getDefaultVariant();
                    }
                } else {
                    throw new BundlingProcessException("Unable to find variant resolver for variant type '" + variantType + "'");
                }
            }
            availableVariantMap.put(variantType, variant);
        }
        return availableVariantMap;
    }

    public List<BundlingProcessLifeCycleListener> getBundlingProcessLifeCycleListeners() {
        return this.bundlingProcesslifeCycleListeners;
    }

    public List<PathMapping> getGeneratedPathMappings(JoinableResourceBundle bundle, String path, ResourceReaderHandler rsReader) {
        List<PathMapping> pathMappings = null;
        ResourceGenerator resourceGenerator = this.getResourceGenerator(path);
        if (resourceGenerator instanceof PathMappingProvider) {
            pathMappings = ((PathMappingProvider)((Object)resourceGenerator)).getPathMappings(bundle, path, rsReader);
        }
        return pathMappings;
    }
}

