/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle.generator;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.jawr.web.exception.BundlingProcessException;
import net.jawr.web.exception.ResourceNotFoundException;
import net.jawr.web.resource.bundle.IOUtils;
import net.jawr.web.resource.bundle.JoinableResourceBundle;
import net.jawr.web.resource.bundle.JoinableResourceBundleImpl;
import net.jawr.web.resource.bundle.factory.util.PathNormalizer;
import net.jawr.web.resource.bundle.generator.AbstractCSSGenerator;
import net.jawr.web.resource.bundle.generator.GeneratorContext;
import net.jawr.web.resource.bundle.generator.resolver.ResourceGeneratorResolver;
import net.jawr.web.resource.bundle.generator.resolver.ResourceGeneratorResolverFactory;
import net.jawr.web.resource.bundle.handler.ResourceBundlesHandler;
import net.jawr.web.resource.bundle.iterator.BundlePath;
import net.jawr.web.resource.bundle.iterator.ConditionalCommentCallbackHandler;
import net.jawr.web.resource.bundle.iterator.ResourceBundlePathsIterator;
import net.jawr.web.resource.bundle.postprocess.BundleProcessingStatus;
import net.jawr.web.resource.bundle.postprocess.impl.CSSURLPathRewriterPostProcessor;
import net.jawr.web.resource.bundle.renderer.ConditionalCommentRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IECssBundleGenerator
extends AbstractCSSGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(IECssBundleGenerator.class);
    private final ResourceGeneratorResolver resolver = ResourceGeneratorResolverFactory.createPrefixResolver("ieCssGen");

    @Override
    public ResourceGeneratorResolver getResolver() {
        return this.resolver;
    }

    @Override
    public Reader createResource(GeneratorContext context) {
        return this.generateResource(context.getPath(), context);
    }

    @Override
    protected Reader generateResource(String path, GeneratorContext context) {
        ResourceBundlesHandler bundlesHandler = (ResourceBundlesHandler)context.getServletContext().getAttribute("net.jawr.web.resource.bundle.CSS_CONTEXT_ATTRIBUTE");
        String contextPath = context.getPath();
        String bundlePath = this.getBundlePath(contextPath);
        Map<String, String> variants = this.getVariantMap(bundlesHandler, contextPath, bundlePath);
        String result = this.generateContent(context, bundlesHandler, bundlePath, variants);
        return new StringReader(result);
    }

    /*
     * Loose catch block
     */
    private String generateContent(GeneratorContext context, ResourceBundlesHandler bundlesHandler, String bundlePath, Map<String, String> variants) {
        String cssGeneratorBundlePath = PathNormalizer.joinPaths(context.getConfig().getServletMapping(), "/jawr_generator.css");
        JoinableResourceBundleImpl tempBundle = new JoinableResourceBundleImpl(cssGeneratorBundlePath, null, null, "css", null, null, context.getConfig().getGeneratorRegistry());
        BundleProcessingStatus tempStatus = new BundleProcessingStatus("bundle", tempBundle, context.getResourceReaderHandler(), context.getConfig());
        CSSURLPathRewriterPostProcessor postProcessor = new CSSURLPathRewriterPostProcessor();
        ResourceBundlePathsIterator it = null;
        StringWriter resultWriter = new StringWriter();
        StringBuffer result = resultWriter.getBuffer();
        ConditionalCommentRenderer callbackHandler = new ConditionalCommentRenderer(resultWriter);
        it = bundlesHandler.isGlobalResourceBundle(bundlePath) ? bundlesHandler.getGlobalResourceBundlePaths(bundlePath, (ConditionalCommentCallbackHandler)callbackHandler, variants) : bundlesHandler.getBundlePaths(bundlePath, callbackHandler, variants);
        while (it.hasNext()) {
            Reader cssReader;
            block7: {
                BundlePath resourcePath = it.nextPath();
                if (resourcePath == null) continue;
                tempStatus.setLastPathAdded(resourcePath.getPath());
                cssReader = null;
                try {
                    JoinableResourceBundle bundle = context.getBundle();
                    cssReader = context.getResourceReaderHandler().getResource(bundle, resourcePath.getPath(), true);
                    StringWriter writer = new StringWriter();
                    IOUtils.copy(cssReader, writer, true);
                    StringBuffer resourceData = postProcessor.postProcessBundle(tempStatus, writer.getBuffer());
                    result.append("/** CSS resource : ").append(resourcePath.getPath()).append(" **/\n");
                    result.append(resourceData);
                    if (!it.hasNext()) break block7;
                    result.append("\n\n");
                }
                catch (ResourceNotFoundException e) {
                    LOGGER.debug("The resource '" + resourcePath.getPath() + "' was not found");
                    IOUtils.close(cssReader);
                    continue;
                }
                catch (IOException e2) {
                    throw new BundlingProcessException(e2);
                    {
                        catch (Throwable throwable) {
                            IOUtils.close(cssReader);
                            throw throwable;
                        }
                    }
                }
            }
            IOUtils.close(cssReader);
        }
        return result.toString();
    }

    private Map<String, String> getVariantMap(ResourceBundlesHandler bundlesHandler, String contextPath, String bundlePath) {
        JoinableResourceBundle bundle = bundlesHandler.resolveBundleForPath(bundlePath);
        Set<String> variantTypes = bundle.getVariants().keySet();
        String variantKey = this.getVariantKey(contextPath);
        String[] variantValues = new String[]{};
        if (variantKey.length() > 0) {
            variantValues = variantKey.length() == 1 ? new String[]{"", ""} : variantKey.split(String.valueOf('@'));
        }
        HashMap<String, String> variants = new HashMap<String, String>();
        if (variantTypes.size() != variantValues.length) {
            throw new BundlingProcessException("For the resource '" + contextPath + "', the number variant types for the bundle don't match the variant values.");
        }
        int i = 0;
        for (String variantType : variantTypes) {
            variants.put(variantType, variantValues[i++]);
        }
        return variants;
    }

    private String getBundlePath(String contextPath) {
        String bundlePath = contextPath;
        int idx = -1;
        idx = bundlePath.startsWith("/") ? bundlePath.indexOf("/", 1) : bundlePath.indexOf("/", 1);
        if (idx != -1) {
            bundlePath = bundlePath.substring(idx);
        }
        return bundlePath;
    }

    private String getVariantKey(String contextPath) {
        String resultPath = contextPath.substring(1);
        String variantKey = "";
        String prefix = resultPath.substring(0, resultPath.indexOf("/"));
        if (prefix.indexOf(46) != -1) {
            variantKey = prefix.substring(prefix.indexOf(46) + 1);
        }
        return variantKey.trim();
    }
}

