/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle.generator;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import net.jawr.web.config.JawrConfig;
import net.jawr.web.exception.BundlingProcessException;
import net.jawr.web.resource.bundle.IOUtils;
import net.jawr.web.resource.bundle.factory.util.ClassLoaderResourceUtils;
import net.jawr.web.resource.bundle.generator.AbstractJavascriptGenerator;
import net.jawr.web.resource.bundle.generator.GeneratorContext;
import net.jawr.web.resource.bundle.generator.resolver.ResourceGeneratorResolver;
import net.jawr.web.resource.bundle.generator.resolver.ResourceGeneratorResolverFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class SkinSwitcherJsGenerator
extends AbstractJavascriptGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(SkinSwitcherJsGenerator.class);
    private static final String SCRIPT_TEMPLATE = "/net/jawr/web/resource/bundle/skin/skinSwitcher.js";
    private final ResourceGeneratorResolver resolver = ResourceGeneratorResolverFactory.createPrefixResolver("skinSwitcher");

    @Override
    public ResourceGeneratorResolver getResolver() {
        return this.resolver;
    }

    @Override
    public Reader generateResource(String path, GeneratorContext context) {
        JawrConfig ctxConfig = context.getConfig();
        String skinCookieName = ctxConfig.getSkinCookieName();
        String script = this.createScript(skinCookieName);
        return new StringReader(script);
    }

    private String createScript(String skinCookieName) {
        StringWriter sw = new StringWriter();
        try (InputStream is = ClassLoaderResourceUtils.getResourceAsStream(SCRIPT_TEMPLATE, this);){
            IOUtils.copy(is, (Writer)sw);
        }
        catch (IOException e) {
            Marker fatal = MarkerFactory.getMarker((String)"FATAL");
            LOGGER.error(fatal, "a serious error occurred when initializing ThemeSwitcherJsGenerator");
            throw new BundlingProcessException("Classloading issues prevent loading the themeSwitcher template to be loaded. ", e);
        }
        return sw.getBuffer().toString().replaceAll("\\{JAWR_SKIN_COOKIE_NAME\\}", skinCookieName);
    }
}

