/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle.generator.classpath;

import java.io.InputStream;
import java.util.Set;
import net.jawr.web.resource.FileNameUtils;
import net.jawr.web.resource.bundle.generator.GeneratorContext;
import net.jawr.web.resource.bundle.generator.StreamResourceGenerator;
import net.jawr.web.resource.bundle.generator.classpath.ClassPathGeneratorHelper;
import net.jawr.web.resource.bundle.generator.resolver.ResourceGeneratorResolver;
import net.jawr.web.resource.bundle.generator.resolver.ResourceGeneratorResolverFactory;
import net.jawr.web.resource.handler.reader.ResourceBrowser;

public class ClassPathBinaryResourceGenerator
implements ResourceBrowser,
StreamResourceGenerator {
    private static final String CLASSPATH_GENERATOR_HELPER_PREFIX = "";
    protected ResourceGeneratorResolver resolver;
    private final ClassPathGeneratorHelper helper = new ClassPathGeneratorHelper(this.getClassPathGeneratorHelperPrefix());

    public ClassPathBinaryResourceGenerator() {
        this.resolver = this.createResolver(this.getGeneratorPrefix());
    }

    protected ResourceGeneratorResolver createResolver(String generatorPrefix) {
        return ResourceGeneratorResolverFactory.createPrefixResolver(generatorPrefix);
    }

    protected String getGeneratorPrefix() {
        return "jar";
    }

    protected String getClassPathGeneratorHelperPrefix() {
        return CLASSPATH_GENERATOR_HELPER_PREFIX;
    }

    @Override
    public ResourceGeneratorResolver getResolver() {
        return this.resolver;
    }

    @Override
    public String getDebugModeRequestPath() {
        return "/jawr_generator.jpg";
    }

    @Override
    public InputStream createResourceAsStream(GeneratorContext context) {
        InputStream is = null;
        if (FileNameUtils.hasImageExtension(context.getPath())) {
            is = this.helper.createStreamResource(context);
        }
        return is;
    }

    @Override
    public Set<String> getResourceNames(String path) {
        return this.helper.getResourceNames(this.resolver.getResourcePath(path));
    }

    @Override
    public boolean isDirectory(String path) {
        return this.helper.isDirectory(path);
    }

    @Override
    public String getFilePath(String resourcePath) {
        return this.helper.getFilePath(resourcePath);
    }
}

