/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle.generator.classpath;

import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.Set;
import net.jawr.web.config.JawrConfig;
import net.jawr.web.resource.bundle.JoinableResourceBundleImpl;
import net.jawr.web.resource.bundle.generator.AbstractCSSGenerator;
import net.jawr.web.resource.bundle.generator.CachedGenerator;
import net.jawr.web.resource.bundle.generator.GeneratorContext;
import net.jawr.web.resource.bundle.generator.classpath.ClassPathGeneratorHelper;
import net.jawr.web.resource.bundle.generator.resolver.ResourceGeneratorResolver;
import net.jawr.web.resource.bundle.generator.resolver.ResourceGeneratorResolverFactory;
import net.jawr.web.resource.bundle.mappings.FilePathMapping;
import net.jawr.web.resource.bundle.postprocess.BundleProcessingStatus;
import net.jawr.web.resource.bundle.postprocess.impl.CSSURLPathRewriterPostProcessor;
import net.jawr.web.resource.handler.reader.ResourceBrowser;

@CachedGenerator(name="Classpath CSS", cacheDirectory="cssClasspath", mappingFileName="cssClasspathMapping.txt")
public class ClassPathCSSGenerator
extends AbstractCSSGenerator
implements ResourceBrowser {
    private static final String CLASSPATH_GENERATOR_HELPER_PREFIX = "";
    protected ResourceGeneratorResolver resolver;
    private final ClassPathGeneratorHelper helper = new ClassPathGeneratorHelper(this.getClassPathGeneratorHelperPrefix());
    private boolean isHandlingCssImage;

    public ClassPathCSSGenerator() {
        this.resolver = this.createResolver(this.getGeneratorPrefix());
    }

    protected ResourceGeneratorResolver createResolver(String generatorPrefix) {
        return ResourceGeneratorResolverFactory.createPrefixResolver(generatorPrefix);
    }

    protected String getClassPathGeneratorHelperPrefix() {
        return CLASSPATH_GENERATOR_HELPER_PREFIX;
    }

    protected String getGeneratorPrefix() {
        return "jar";
    }

    @Override
    public void setConfig(JawrConfig config) {
        super.setConfig(config);
        this.isHandlingCssImage = config.isCssClasspathImageHandledByClasspathCss();
    }

    @Override
    public ResourceGeneratorResolver getResolver() {
        return this.resolver;
    }

    @Override
    public boolean isHandlingCssImage() {
        return this.isHandlingCssImage;
    }

    @Override
    protected Reader generateResource(String path, GeneratorContext context) {
        Reader reader = this.helper.createResource(context);
        String filePath = this.helper.getFilePath(path);
        if (filePath != null) {
            long lastModified = this.rsHandler.getLastModified(filePath);
            FilePathMapping fMapping = new FilePathMapping(filePath, lastModified);
            this.addLinkedResources(path, context, Arrays.asList(fMapping));
        }
        return reader;
    }

    @Override
    protected String rewriteUrl(GeneratorContext context, String content) throws IOException {
        JoinableResourceBundleImpl tempBundle = new JoinableResourceBundleImpl("/jawr_generator.css", null, null, null, null, null, context.getConfig().getGeneratorRegistry());
        BundleProcessingStatus tempStatus = new BundleProcessingStatus("file", tempBundle, context.getResourceReaderHandler(), context.getConfig());
        CSSURLPathRewriterPostProcessor postProcessor = new CSSURLPathRewriterPostProcessor();
        String resourcePath = context.getPath();
        tempStatus.setLastPathAdded(this.getGeneratorPrefix() + ":" + resourcePath);
        StringBuffer resourceData = postProcessor.postProcessBundle(tempStatus, new StringBuffer(content));
        return resourceData.toString();
    }

    @Override
    protected Reader generateResourceForDebug(Reader rd, GeneratorContext context) {
        if (context.getConfig().isCssClasspathImageHandledByClasspathCss()) {
            rd = super.generateResourceForDebug(rd, context);
        }
        return rd;
    }

    @Override
    public Set<String> getResourceNames(String path) {
        return this.helper.getResourceNames(this.resolver.getResourcePath(path));
    }

    @Override
    public boolean isDirectory(String path) {
        return this.helper.isDirectory(path);
    }

    @Override
    public String getFilePath(String resourcePath) {
        return this.helper.getFilePath(this.resolver.getResourcePath(resourcePath));
    }
}

