/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle.generator.classpath;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import net.jawr.web.exception.BundlingProcessException;
import net.jawr.web.exception.ResourceNotFoundException;
import net.jawr.web.resource.bundle.factory.util.ClassLoaderResourceUtils;
import net.jawr.web.resource.bundle.factory.util.PathNormalizer;
import net.jawr.web.resource.bundle.generator.GeneratorContext;
import net.jawr.web.resource.handler.reader.ResourceBrowser;
import net.jawr.web.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassPathGeneratorHelper
implements ResourceBrowser {
    private static Logger LOGGER = LoggerFactory.getLogger(ClassPathGeneratorHelper.class);
    private final String classpathPrefix;

    public ClassPathGeneratorHelper() {
        this("");
    }

    public ClassPathGeneratorHelper(String classpathPrefix) {
        this.classpathPrefix = classpathPrefix;
    }

    public Reader createResource(GeneratorContext context) {
        InputStream is = this.createStreamResource(context);
        ReadableByteChannel chan = Channels.newChannel(is);
        return Channels.newReader(chan, context.getCharset().newDecoder(), -1);
    }

    public InputStream createStreamResource(GeneratorContext context) {
        InputStream is = null;
        try {
            String resourcePath = context.getPath();
            String path = this.getCompletePath(resourcePath);
            is = ClassLoaderResourceUtils.getResourceAsStream(path, this);
        }
        catch (FileNotFoundException e) {
            throw new BundlingProcessException(e);
        }
        return is;
    }

    private String getCompletePath(String resourcePath) {
        String path = PathNormalizer.normalizePath(this.classpathPrefix + resourcePath);
        return path;
    }

    @Override
    public Set<String> getResourceNames(String path) {
        Set<String> resources = null;
        URL resourceURL = null;
        try {
            resourceURL = ClassLoaderResourceUtils.getResourceURL(this.getCompletePath(path), this);
            if (resourceURL.toString().startsWith("jar:")) {
                resources = this.getResourceNamesFromJar(path, resourceURL);
            } else if (resourceURL.toString().startsWith("file:")) {
                String dirPath = resourceURL.getFile();
                File dir = new File(dirPath);
                resources = FileUtils.getResourceNames(dir);
            }
        }
        catch (ResourceNotFoundException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Unable to find resources name for path '" + path + "'", (Throwable)e);
            }
            resources = Collections.emptySet();
        }
        return resources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getResourceNamesFromJar(String path, URL resourceURL) {
        String rootEntryPath;
        JarFile jarFile;
        URLConnection con = null;
        try {
            if (resourceURL.toString().startsWith("jar:")) {
                con = resourceURL.openConnection();
            }
        }
        catch (IOException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Unable to find resources name for path '" + path + "'", (Throwable)e);
            }
            return Collections.emptySet();
        }
        boolean newJarFile = false;
        try {
            if (con instanceof JarURLConnection) {
                JarURLConnection jarCon = (JarURLConnection)con;
                jarCon.setUseCaches(true);
                jarFile = jarCon.getJarFile();
                JarEntry jarEntry = jarCon.getJarEntry();
                rootEntryPath = jarEntry != null ? jarEntry.getName() : "";
            } else {
                String urlFile = resourceURL.getFile();
                int separatorIndex = urlFile.indexOf("!/");
                if (separatorIndex != -1) {
                    String jarFileUrl = urlFile.substring(0, separatorIndex);
                    rootEntryPath = urlFile.substring(separatorIndex + "!/".length());
                    jarFile = this.getJarFile(jarFileUrl);
                } else {
                    jarFile = new JarFile(urlFile);
                    rootEntryPath = "";
                }
                newJarFile = true;
            }
        }
        catch (IOException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Unable to find resources name for path '" + path + "'", (Throwable)e);
            }
            return Collections.emptySet();
        }
        try {
            if (!"".equals(rootEntryPath) && !rootEntryPath.endsWith("/")) {
                rootEntryPath = rootEntryPath + "/";
            }
            LinkedHashSet<String> result = new LinkedHashSet<String>(8);
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String entryPath = entry.getName();
                if (!this.isDirectChildPath(rootEntryPath, entryPath)) continue;
                String relativePath = entryPath.substring(rootEntryPath.length());
                result.add(relativePath);
            }
            LinkedHashSet<String> linkedHashSet = result;
            return linkedHashSet;
        }
        finally {
            if (newJarFile) {
                try {
                    jarFile.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private boolean isDirectChildPath(String rootEntryPath, String entryPath) {
        boolean result = false;
        if (entryPath.length() > rootEntryPath.length() && entryPath.startsWith(rootEntryPath)) {
            int idx = entryPath.indexOf("/", rootEntryPath.length());
            if (idx == -1) {
                result = true;
            } else if (entryPath.length() == idx + 1) {
                result = true;
            }
        }
        return result;
    }

    @Override
    public boolean isDirectory(String path) {
        return path.endsWith("/");
    }

    @Override
    public String getFilePath(String resourcePath) {
        String filePath = null;
        String path = this.getCompletePath(resourcePath);
        URL url = null;
        try {
            url = ClassLoaderResourceUtils.getResourceURL(path, this);
            String strURL = url.toString();
            if (strURL.startsWith("file:")) {
                filePath = new File(url.getFile()).getAbsolutePath();
            } else if (strURL.startsWith("jar:file:")) {
                String tmp = strURL.substring("jar:file:".length());
                int idxJarContentSeparator = tmp.indexOf("!");
                if (idxJarContentSeparator != -1) {
                    tmp = tmp.substring(0, idxJarContentSeparator);
                }
                filePath = new File(tmp).getAbsolutePath();
            }
        }
        catch (ResourceNotFoundException e) {
            filePath = null;
        }
        return filePath;
    }

    protected JarFile getJarFile(String jarFileUrl) throws IOException {
        if (jarFileUrl.startsWith("file:")) {
            try {
                return new JarFile(ClassPathGeneratorHelper.toURI(jarFileUrl).getSchemeSpecificPart());
            }
            catch (URISyntaxException ex) {
                return new JarFile(jarFileUrl.substring("file:".length()));
            }
        }
        return new JarFile(jarFileUrl);
    }

    public static URI toURI(URL url) throws URISyntaxException {
        return ClassPathGeneratorHelper.toURI(url.toString());
    }

    public static URI toURI(String location) throws URISyntaxException {
        return new URI(location.replace(" ", "%20"));
    }
}

