/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle.generator.classpath;

import java.io.Reader;
import java.util.Set;
import net.jawr.web.resource.FileNameUtils;
import net.jawr.web.resource.bundle.generator.AbstractJavascriptGenerator;
import net.jawr.web.resource.bundle.generator.CachedGenerator;
import net.jawr.web.resource.bundle.generator.GeneratorContext;
import net.jawr.web.resource.bundle.generator.classpath.ClassPathGeneratorHelper;
import net.jawr.web.resource.bundle.generator.resolver.ResourceGeneratorResolver;
import net.jawr.web.resource.bundle.generator.resolver.ResourceGeneratorResolverFactory;
import net.jawr.web.resource.bundle.mappings.FilePathMapping;
import net.jawr.web.resource.handler.reader.ResourceBrowser;

@CachedGenerator(name="Classpath JS", cacheDirectory="jsClasspath", mappingFileName="jsClasspathMapping.txt")
public class ClasspathJSGenerator
extends AbstractJavascriptGenerator
implements ResourceBrowser {
    private static final String CLASSPATH_GENERATOR_HELPER_PREFIX = "";
    protected ClassPathGeneratorHelper helper = new ClassPathGeneratorHelper(this.getClassPathGeneratorHelperPrefix());
    protected ResourceGeneratorResolver resolver = this.createResolver(this.getGeneratorPrefix());

    protected ResourceGeneratorResolver createResolver(String generatorPrefix) {
        return ResourceGeneratorResolverFactory.createPrefixResolver(generatorPrefix);
    }

    protected String getClassPathGeneratorHelperPrefix() {
        return CLASSPATH_GENERATOR_HELPER_PREFIX;
    }

    protected String getGeneratorPrefix() {
        return "jar";
    }

    @Override
    public ResourceGeneratorResolver getResolver() {
        return this.resolver;
    }

    @Override
    protected Reader generateResource(String path, GeneratorContext context) {
        Reader rd = null;
        if (FileNameUtils.isExtension(path, "js")) {
            rd = this.helper.createResource(context);
            String filePath = this.helper.getFilePath(path);
            if (filePath != null) {
                long lastModified = this.rsHandler.getLastModified(filePath);
                FilePathMapping fMapping = new FilePathMapping(filePath, lastModified);
                this.addLinkedResources(path, context, fMapping);
            }
        }
        return rd;
    }

    @Override
    public Set<String> getResourceNames(String path) {
        return this.helper.getResourceNames(this.resolver.getResourcePath(path));
    }

    @Override
    public boolean isDirectory(String path) {
        return this.helper.isDirectory(this.resolver.getResourcePath(path));
    }

    @Override
    public String getFilePath(String resourcePath) {
        return this.helper.getFilePath(this.resolver.getResourcePath(resourcePath));
    }
}

