/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle.generator.css.less;

import com.github.sommeri.less4j.LessSource;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import net.jawr.web.exception.BundlingProcessException;
import net.jawr.web.exception.ResourceNotFoundException;
import net.jawr.web.resource.bundle.IOUtils;
import net.jawr.web.resource.bundle.JoinableResourceBundle;
import net.jawr.web.resource.bundle.factory.util.PathNormalizer;
import net.jawr.web.resource.bundle.generator.css.less.ILessCssResourceGenerator;
import net.jawr.web.resource.bundle.mappings.FilePathMapping;
import net.jawr.web.resource.bundle.mappings.FilePathMappingUtils;
import net.jawr.web.resource.handler.reader.ResourceReaderHandler;

public class JawrLessSource
extends LessSource.StringSource {
    private ResourceReaderHandler rsReaderHandler;
    private JoinableResourceBundle bundle;
    private JawrLessSource parent;
    private List<FilePathMapping> linkedResources;

    public JawrLessSource(JoinableResourceBundle bundle, String content, String name, ResourceReaderHandler rsReaderHandler) {
        this(bundle, content, name, null, rsReaderHandler);
    }

    public JawrLessSource(JoinableResourceBundle bundle, String content, String name, JawrLessSource parent, ResourceReaderHandler rsReaderHandler) {
        super(content, name);
        this.bundle = bundle;
        this.parent = parent;
        this.rsReaderHandler = rsReaderHandler;
        this.linkedResources = new ArrayList<FilePathMapping>();
        FilePathMapping fMapping = FilePathMappingUtils.buildFilePathMapping(name, this.rsReaderHandler);
        if (fMapping != null) {
            this.linkedResources.add(fMapping);
        }
    }

    public LessSource relativeSource(String resource) throws LessSource.StringSourceException {
        String result = null;
        if (!resource.startsWith("/")) {
            resource = PathNormalizer.concatWebPath(this.getName(), resource);
        }
        try (Reader rd = this.getResourceReader(resource);){
            result = IOUtils.toString(rd);
            FilePathMapping linkedResource = FilePathMappingUtils.buildFilePathMapping(resource, this.rsReaderHandler);
            if (linkedResource != null) {
                this.addLinkedResource(linkedResource);
                if (this.bundle != null) {
                    this.bundle.getFilePathMappings().add(new FilePathMapping(this.bundle, linkedResource.getPath(), linkedResource.getLastModified()));
                }
            }
        }
        catch (IOException | ResourceNotFoundException e) {
            throw new BundlingProcessException(e);
        }
        return new JawrLessSource(this.bundle, result, resource, this, this.rsReaderHandler);
    }

    private void addLinkedResource(FilePathMapping linkedResource) {
        this.linkedResources.add(linkedResource);
        if (this.parent != null) {
            this.parent.addLinkedResource(linkedResource);
        }
    }

    private Reader getResourceReader(String resource) throws ResourceNotFoundException {
        ArrayList excluded = new ArrayList();
        excluded.add(ILessCssResourceGenerator.class);
        return this.rsReaderHandler.getResource(this.bundle, resource, false, excluded);
    }

    public List<FilePathMapping> getLinkedResources() {
        return this.linkedResources;
    }
}

