/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle.generator.css.less;

import com.github.sommeri.less4j.Less4jException;
import com.github.sommeri.less4j.LessCompiler;
import com.github.sommeri.less4j.LessSource;
import com.github.sommeri.less4j.core.DefaultLessCompiler;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import net.jawr.web.exception.BundlingProcessException;
import net.jawr.web.exception.ResourceNotFoundException;
import net.jawr.web.resource.bundle.IOUtils;
import net.jawr.web.resource.bundle.JoinableResourceBundle;
import net.jawr.web.resource.bundle.generator.AbstractCSSGenerator;
import net.jawr.web.resource.bundle.generator.CachedGenerator;
import net.jawr.web.resource.bundle.generator.GeneratorContext;
import net.jawr.web.resource.bundle.generator.css.less.ILessCssResourceGenerator;
import net.jawr.web.resource.bundle.generator.css.less.JawrLessSource;
import net.jawr.web.resource.bundle.generator.resolver.ResourceGeneratorResolver;
import net.jawr.web.resource.bundle.generator.resolver.ResourceGeneratorResolverFactory;

@CachedGenerator(name="less", cacheDirectory="lessCss", mappingFileName="lessGeneratorCache.txt")
public class LessCssGenerator
extends AbstractCSSGenerator
implements ILessCssResourceGenerator {
    private final ResourceGeneratorResolver resolver = ResourceGeneratorResolverFactory.createSuffixResolver("less");
    private LessCompiler compiler;
    private LessCompiler.Configuration lessConfig;

    @Override
    public ResourceGeneratorResolver getResolver() {
        return this.resolver;
    }

    @Override
    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        this.compiler = new DefaultLessCompiler();
        this.lessConfig = new LessCompiler.Configuration();
        this.lessConfig.getSourceMapConfiguration().setLinkSourceMap(false);
    }

    @Override
    protected Reader generateResource(String path, GeneratorContext context) {
        Reader rd = null;
        try {
            ArrayList excluded = new ArrayList();
            excluded.add(ILessCssResourceGenerator.class);
            JoinableResourceBundle bundle = context.getBundle();
            rd = context.getResourceReaderHandler().getResource(bundle, path, false, excluded);
            if (rd == null) {
                throw new ResourceNotFoundException(path);
            }
            String content = IOUtils.toString(rd);
            String result = this.compile(bundle, content, path, context);
            rd = new StringReader(result);
        }
        catch (IOException | ResourceNotFoundException e) {
            throw new BundlingProcessException("Unable to generate content for resource path : '" + path + "'", e);
        }
        return rd;
    }

    public String compile(JoinableResourceBundle bundle, String content, String path, GeneratorContext context) {
        JawrLessSource source = new JawrLessSource(bundle, content, path, this.rsHandler);
        try {
            LessCompiler.CompilationResult result = this.compiler.compile((LessSource)source, this.lessConfig);
            this.addLinkedResources(path, context, source.getLinkedResources());
            return result.getCss();
        }
        catch (Less4jException e) {
            throw new BundlingProcessException("Unable to generate content for resource path : '" + path + "'", e);
        }
    }
}

