/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle.generator.css.sass.ruby;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import net.jawr.web.exception.ResourceNotFoundException;
import net.jawr.web.resource.bundle.IOUtils;
import net.jawr.web.resource.bundle.JoinableResourceBundle;
import net.jawr.web.resource.bundle.css.CssImageUrlRewriter;
import net.jawr.web.resource.bundle.factory.util.PathNormalizer;
import net.jawr.web.resource.bundle.generator.css.sass.ISassResourceGenerator;
import net.jawr.web.resource.bundle.generator.css.sass.ruby.SassRubyUtils;
import net.jawr.web.resource.bundle.mappings.FilePathMapping;
import net.jawr.web.resource.bundle.mappings.FilePathMappingUtils;
import net.jawr.web.resource.handler.reader.ResourceReaderHandler;

public class JawrSassResolver {
    private final ResourceReaderHandler rsHandler;
    private final JoinableResourceBundle bundle;
    private final String scssPath;
    private final boolean useAbsoluteUrl;
    private final List<FilePathMapping> linkedResources = new ArrayList<FilePathMapping>();

    public JawrSassResolver(JoinableResourceBundle bundle, String path, ResourceReaderHandler rsHandler, boolean useAbsoluteUrl) {
        this.bundle = bundle;
        this.scssPath = path;
        this.rsHandler = rsHandler;
        this.useAbsoluteUrl = useAbsoluteUrl;
        this.addLinkedResource(path);
    }

    public List<FilePathMapping> getLinkedResources() {
        return this.linkedResources;
    }

    public String getPath(String base, String uri) throws ResourceNotFoundException, IOException {
        String fileName = uri;
        if (!fileName.endsWith(".scss")) {
            fileName = fileName + ".scss";
        }
        String parentPath = base.replace('\\', '/');
        fileName = fileName.replace('\\', '/');
        return PathNormalizer.concatWebPath(parentPath, fileName);
    }

    public String findRelative(String base, String uri) throws ResourceNotFoundException, IOException {
        String path = this.getPath(base, uri);
        String source = this.resolveAndNormalize(path);
        if (source != null) {
            return source;
        }
        source = this.resolveAndNormalize(path = PathNormalizer.getParentPath(path) + "_" + PathNormalizer.getPathName(path));
        if (source != null) {
            return source;
        }
        return this.resolveAndNormalize(uri);
    }

    protected String resolveAndNormalize(String path) throws ResourceNotFoundException, IOException {
        ArrayList excluded = new ArrayList();
        excluded.add(ISassResourceGenerator.class);
        Reader rd = null;
        try {
            rd = this.rsHandler.getResource(this.bundle, path, false, excluded);
            this.addLinkedResource(path);
        }
        catch (ResourceNotFoundException e) {
            // empty catch block
        }
        String content = null;
        if (rd != null) {
            content = IOUtils.toString(rd);
            if (!this.useAbsoluteUrl) {
                CssImageUrlRewriter rewriter = new CssImageUrlRewriter();
                content = rewriter.rewriteUrl(path, this.scssPath, content).toString();
            }
            content = SassRubyUtils.normalizeMultiByteString(content);
        }
        return content;
    }

    protected void addLinkedResource(String path) {
        FilePathMapping linkedResource = this.getFilePathMapping(path);
        if (linkedResource != null) {
            this.addLinkedResource(linkedResource);
            if (this.bundle != null) {
                this.bundle.getLinkedFilePathMappings().add(new FilePathMapping(this.bundle, linkedResource.getPath(), linkedResource.getLastModified()));
            }
        }
    }

    public FilePathMapping getFilePathMapping(String fileName) {
        return FilePathMappingUtils.buildFilePathMapping(fileName, this.rsHandler);
    }

    private void addLinkedResource(FilePathMapping linkedResource) {
        this.linkedResources.add(linkedResource);
    }
}

