/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle.generator.css.sass.ruby;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import net.jawr.web.config.JawrConfig;
import net.jawr.web.exception.BundlingProcessException;
import net.jawr.web.exception.ResourceNotFoundException;
import net.jawr.web.resource.bundle.IOUtils;
import net.jawr.web.resource.bundle.JoinableResourceBundle;
import net.jawr.web.resource.bundle.factory.util.ClassLoaderResourceUtils;
import net.jawr.web.resource.bundle.generator.AbstractCSSGenerator;
import net.jawr.web.resource.bundle.generator.CachedGenerator;
import net.jawr.web.resource.bundle.generator.GeneratorContext;
import net.jawr.web.resource.bundle.generator.css.sass.ISassResourceGenerator;
import net.jawr.web.resource.bundle.generator.css.sass.ruby.JawrSassResolver;
import net.jawr.web.resource.bundle.generator.css.sass.ruby.SassRubyUtils;
import net.jawr.web.resource.bundle.generator.resolver.ResourceGeneratorResolver;
import net.jawr.web.resource.bundle.generator.resolver.ResourceGeneratorResolverFactory;
import net.jawr.web.util.StringUtils;

@CachedGenerator(name="sass", cacheDirectory="sassRubyCss", mappingFileName="sassGeneratorCache.txt")
public class SassRubyGenerator
extends AbstractCSSGenerator
implements ISassResourceGenerator {
    private static final String JAWR_IMPORTER_RB = "/net/jawr/web/resource/bundle/generator/css/sass/jawr-sass.rb";
    private static final String JAWR_RESOLVER_VAR = "@jawrResolver";
    public static final String SASS_GENERATOR_DEFAULT_URL_MODE = "absolute";
    private final ResourceGeneratorResolver resolver;
    private final ScriptEngine rubyEngine;
    private boolean useAbsoluteURL = false;

    public SassRubyGenerator() {
        System.setProperty("org.jruby.embed.compat.version", "JRuby1.9");
        System.setProperty("org.jruby.embed.localvariable.behavior", "transient");
        this.resolver = ResourceGeneratorResolverFactory.createSuffixResolver("scss");
        this.rubyEngine = new ScriptEngineManager().getEngineByName("jruby");
    }

    @Override
    public ResourceGeneratorResolver getResolver() {
        return this.resolver;
    }

    @Override
    public void setConfig(JawrConfig config) {
        super.setConfig(config);
        String value = this.config.getProperty("jawr.css.sass.generator.urlMode", SASS_GENERATOR_DEFAULT_URL_MODE);
        if (!value.equalsIgnoreCase(SASS_GENERATOR_DEFAULT_URL_MODE) && !value.equalsIgnoreCase("relative")) {
            throw new BundlingProcessException("The value '" + value + "' is not allowed for '" + "jawr.css.sass.generator.urlMode" + "' in the Saas Ruby generator");
        }
        this.useAbsoluteURL = value.equalsIgnoreCase(SASS_GENERATOR_DEFAULT_URL_MODE);
    }

    @Override
    protected void resetCache() {
        super.resetCache();
        this.cacheProperties.put("jawr.css.sass.generator.urlMode", this.useAbsoluteURL ? SASS_GENERATOR_DEFAULT_URL_MODE : "relative");
    }

    @Override
    protected boolean isCacheValid() {
        String cachedUrlMode = this.cacheProperties.getProperty("jawr.css.sass.generator.urlMode");
        return super.isCacheValid() && StringUtils.equals(cachedUrlMode, this.config.getProperty("jawr.css.sass.generator.urlMode", SASS_GENERATOR_DEFAULT_URL_MODE));
    }

    @Override
    protected Reader generateResource(String path, GeneratorContext context) {
        Reader rd = null;
        try {
            ArrayList excluded = new ArrayList();
            excluded.add(ISassResourceGenerator.class);
            JoinableResourceBundle bundle = context.getBundle();
            rd = context.getResourceReaderHandler().getResource(bundle, path, false, excluded);
            if (rd == null) {
                throw new ResourceNotFoundException(path);
            }
            String content = IOUtils.toString(rd);
            String result = this.compile(bundle, content, path, context);
            rd = new StringReader(result);
        }
        catch (IOException | ScriptException | ResourceNotFoundException e) {
            throw new BundlingProcessException("Unable to generate content for resource path : '" + path + "'", e);
        }
        return rd;
    }

    private String compile(JoinableResourceBundle bundle, String content, String path, GeneratorContext ctx) throws ScriptException, IOException {
        try (InputStream is = this.getResourceInputStream(JAWR_IMPORTER_RB);){
            String script = IOUtils.toString(is);
            this.rubyEngine.eval(script);
        }
        SimpleBindings bindings = new SimpleBindings();
        JawrSassResolver scssResolver = new JawrSassResolver(bundle, path, this.rsHandler, this.useAbsoluteURL);
        bindings.put(JAWR_RESOLVER_VAR, (Object)scssResolver);
        String compiledScss = this.rubyEngine.eval(this.buildScript(path, content), (Bindings)bindings).toString();
        this.addLinkedResources(path, ctx, scssResolver.getLinkedResources());
        return compiledScss;
    }

    private String buildScript(String path, String content) {
        StringBuilder script = new StringBuilder();
        script.append("require 'rubygems'\nrequire 'sass/plugin'\nrequire 'sass/engine'\n");
        content = SassRubyUtils.normalizeMultiByteString(content);
        script.append(String.format("customImporter = Sass::Importers::JawrImporter.new(@jawrResolver) \nname = \"%s\"\nresult = Sass::Engine.new(\"%s\", {:importer => customImporter, :filename => name, :syntax => :scss, :cache => false}).render", path, content.replace("\"", "\\\"").replace("#", "\\#")));
        return script.toString();
    }

    private InputStream getResourceInputStream(String path) {
        InputStream is = this.config.getContext().getResourceAsStream(path);
        if (is == null) {
            try {
                is = ClassLoaderResourceUtils.getResourceAsStream(path, this);
            }
            catch (FileNotFoundException e) {
                throw new BundlingProcessException(e);
            }
        }
        return is;
    }
}

