/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle.generator.css.sass.vaadin;

import com.vaadin.sass.internal.ScssStylesheet;
import com.vaadin.sass.internal.resolver.AbstractResolver;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import net.jawr.web.exception.ResourceNotFoundException;
import net.jawr.web.resource.bundle.JoinableResourceBundle;
import net.jawr.web.resource.bundle.factory.util.PathNormalizer;
import net.jawr.web.resource.bundle.generator.css.sass.ISassResourceGenerator;
import net.jawr.web.resource.bundle.mappings.FilePathMapping;
import net.jawr.web.resource.bundle.mappings.FilePathMappingUtils;
import net.jawr.web.resource.handler.reader.ResourceReaderHandler;
import org.w3c.css.sac.InputSource;

public class JawrScssResolver
extends AbstractResolver {
    private static final long serialVersionUID = -6883663899372194879L;
    private final ResourceReaderHandler rsHandler;
    private final JoinableResourceBundle bundle;
    private final List<FilePathMapping> linkedResources = new ArrayList<FilePathMapping>();

    public JawrScssResolver(JoinableResourceBundle bundle, ResourceReaderHandler rsHandler) {
        this.bundle = bundle;
        this.rsHandler = rsHandler;
    }

    public InputSource resolve(ScssStylesheet parentStylesheet, String identifier) {
        identifier = identifier.replaceFirst(".scss$", "");
        String parentPath = parentStylesheet.getFileName().replace('\\', '/');
        String path = PathNormalizer.concatWebPath(parentPath, identifier);
        InputSource source = this.resolveNormalized(path);
        if (source != null) {
            return source;
        }
        source = this.normalizeAndResolve(path = PathNormalizer.getParentPath(path) + "_" + PathNormalizer.getPathName(path));
        if (source != null) {
            return source;
        }
        return this.normalizeAndResolve(identifier);
    }

    public InputSource resolveNormalized(String identifier) {
        String fileName = identifier;
        if (!fileName.endsWith(".css")) {
            fileName = fileName + ".scss";
        }
        ArrayList excluded = new ArrayList();
        excluded.add(ISassResourceGenerator.class);
        Reader rd = null;
        try {
            rd = this.rsHandler.getResource(this.bundle, fileName, false, excluded);
            FilePathMapping linkedResource = this.getFilePathMapping(fileName);
            if (linkedResource != null) {
                this.addLinkedResource(linkedResource);
                if (this.bundle != null) {
                    this.bundle.getLinkedFilePathMappings().add(new FilePathMapping(this.bundle, linkedResource.getPath(), linkedResource.getLastModified()));
                }
            }
        }
        catch (ResourceNotFoundException e) {
            // empty catch block
        }
        if (rd != null) {
            InputSource source = new InputSource();
            source.setCharacterStream(rd);
            source.setURI(fileName);
            return source;
        }
        return null;
    }

    public FilePathMapping getFilePathMapping(String fileName) {
        return FilePathMappingUtils.buildFilePathMapping(fileName, this.rsHandler);
    }

    public List<FilePathMapping> getLinkedResources() {
        return this.linkedResources;
    }

    public void addLinkedResource(FilePathMapping linkedResource) {
        this.linkedResources.add(linkedResource);
    }
}

