/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle.generator.css.sass.vaadin;

import com.vaadin.sass.internal.ScssStylesheet;
import com.vaadin.sass.internal.handler.SCSSDocumentHandlerImpl;
import com.vaadin.sass.internal.handler.SCSSErrorHandler;
import com.vaadin.sass.internal.parser.ParseException;
import com.vaadin.sass.internal.parser.Parser;
import com.vaadin.sass.internal.parser.SCSSParseException;
import com.vaadin.sass.internal.resolver.ScssStylesheetResolver;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.Arrays;
import net.jawr.web.resource.bundle.JoinableResourceBundle;
import net.jawr.web.resource.bundle.generator.css.sass.vaadin.JawrScssResolver;
import net.jawr.web.resource.bundle.mappings.FilePathMapping;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.DocumentHandler;
import org.w3c.css.sac.ErrorHandler;
import org.w3c.css.sac.InputSource;

public class JawrScssStylesheet
extends ScssStylesheet {
    private static final long serialVersionUID = 933939723158980010L;
    private String path;
    private ScssStylesheetResolver resolver;

    public JawrScssStylesheet(JoinableResourceBundle bundle, String content, String path, JawrScssResolver scssResolver, Charset charset) throws CSSException, IOException {
        this.path = path;
        this.addSourceUris(Arrays.asList(path));
        this.addResolver((ScssStylesheetResolver)scssResolver);
        InputSource source = new InputSource((Reader)new StringReader(content));
        Parser parser = new Parser();
        parser.setErrorHandler((ErrorHandler)new SCSSErrorHandler());
        SCSSDocumentHandlerImpl docHandler = new SCSSDocumentHandlerImpl((ScssStylesheet)this);
        parser.setDocumentHandler((DocumentHandler)docHandler);
        FilePathMapping fMapping = scssResolver.getFilePathMapping(path);
        if (fMapping != null) {
            scssResolver.addLinkedResource(fMapping);
            if (bundle != null) {
                bundle.getFilePathMappings().add(new FilePathMapping(bundle, fMapping.getPath(), fMapping.getLastModified()));
            }
        }
        try {
            parser.parseStyleSheet(source);
        }
        catch (ParseException e) {
            throw new SCSSParseException(e, path);
        }
        this.setCharset(charset.toString());
    }

    public InputSource resolveStylesheet(String identifier, ScssStylesheet parentStylesheet) {
        return this.resolver.resolve(parentStylesheet, identifier);
    }

    public String getFileName() {
        return this.path;
    }
}

