/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle.generator.css.sass.vaadin;

import com.vaadin.sass.internal.ScssContext;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import net.jawr.web.config.JawrConfig;
import net.jawr.web.exception.BundlingProcessException;
import net.jawr.web.exception.ResourceNotFoundException;
import net.jawr.web.resource.bundle.IOUtils;
import net.jawr.web.resource.bundle.JoinableResourceBundle;
import net.jawr.web.resource.bundle.generator.AbstractCSSGenerator;
import net.jawr.web.resource.bundle.generator.CachedGenerator;
import net.jawr.web.resource.bundle.generator.GeneratorContext;
import net.jawr.web.resource.bundle.generator.css.sass.ISassResourceGenerator;
import net.jawr.web.resource.bundle.generator.css.sass.vaadin.JawrScssResolver;
import net.jawr.web.resource.bundle.generator.css.sass.vaadin.JawrScssStylesheet;
import net.jawr.web.resource.bundle.generator.resolver.ResourceGeneratorResolver;
import net.jawr.web.resource.bundle.generator.resolver.ResourceGeneratorResolverFactory;
import net.jawr.web.util.StringUtils;

@CachedGenerator(name="sass", cacheDirectory="sassVaadinCss", mappingFileName="sassGeneratorCache.txt")
public class SassVaadinGenerator
extends AbstractCSSGenerator
implements ISassResourceGenerator {
    public static final String SASS_GENERATOR_DEFAULT_URL_MODE = "MIXED";
    private final ResourceGeneratorResolver resolver = ResourceGeneratorResolverFactory.createSuffixResolver("scss");
    private ScssContext.UrlMode urlMode;

    @Override
    public ResourceGeneratorResolver getResolver() {
        return this.resolver;
    }

    @Override
    public void setConfig(JawrConfig config) {
        super.setConfig(config);
        String value = this.config.getProperty("jawr.css.sass.generator.urlMode", SASS_GENERATOR_DEFAULT_URL_MODE);
        this.urlMode = ScssContext.UrlMode.valueOf((String)value.toUpperCase());
    }

    @Override
    protected Reader generateResource(String path, GeneratorContext context) {
        Reader rd = null;
        try {
            ArrayList excluded = new ArrayList();
            excluded.add(ISassResourceGenerator.class);
            JoinableResourceBundle bundle = context.getBundle();
            rd = context.getResourceReaderHandler().getResource(bundle, path, false, excluded);
            if (rd == null) {
                throw new ResourceNotFoundException(path);
            }
            String content = IOUtils.toString(rd);
            String result = this.compile(bundle, content, path, context);
            rd = new StringReader(result);
        }
        catch (IOException | ResourceNotFoundException e) {
            throw new BundlingProcessException("Unable to generate content for resource path : '" + path + "'", e);
        }
        return rd;
    }

    @Override
    protected void resetCache() {
        super.resetCache();
        this.cacheProperties.put("jawr.css.sass.generator.urlMode", this.urlMode.toString());
    }

    @Override
    protected boolean isCacheValid() {
        String cachedUrlMode = this.cacheProperties.getProperty("jawr.css.sass.generator.urlMode");
        return super.isCacheValid() && StringUtils.equals(cachedUrlMode, this.config.getProperty("jawr.css.sass.generator.urlMode", SASS_GENERATOR_DEFAULT_URL_MODE));
    }

    protected String compile(JoinableResourceBundle bundle, String content, String path, GeneratorContext context) {
        try {
            JawrScssResolver scssResolver = new JawrScssResolver(bundle, this.rsHandler);
            JawrScssStylesheet sheet = new JawrScssStylesheet(bundle, content, path, scssResolver, context.getCharset());
            sheet.compile(this.urlMode);
            String parsedScss = sheet.printState();
            this.addLinkedResources(path, context, scssResolver.getLinkedResources());
            return parsedScss;
        }
        catch (Exception e) {
            throw new BundlingProcessException("Unable to generate content for resource path : '" + path + "'", e);
        }
    }
}

