/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle.generator.js.coffee;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import javax.script.ScriptException;
import net.jawr.web.exception.BundlingProcessException;
import net.jawr.web.exception.ResourceNotFoundException;
import net.jawr.web.resource.bundle.IOUtils;
import net.jawr.web.resource.bundle.JoinableResourceBundle;
import net.jawr.web.resource.bundle.factory.util.ClassLoaderResourceUtils;
import net.jawr.web.resource.bundle.generator.AbstractJavascriptGenerator;
import net.jawr.web.resource.bundle.generator.CachedGenerator;
import net.jawr.web.resource.bundle.generator.GeneratorContext;
import net.jawr.web.resource.bundle.generator.js.coffee.ICoffeeScriptGenerator;
import net.jawr.web.resource.bundle.generator.resolver.ResourceGeneratorResolver;
import net.jawr.web.resource.bundle.generator.resolver.ResourceGeneratorResolverFactory;
import net.jawr.web.resource.bundle.mappings.FilePathMapping;
import net.jawr.web.resource.bundle.mappings.FilePathMappingUtils;
import net.jawr.web.util.StopWatch;
import net.jawr.web.util.StringUtils;
import net.jawr.web.util.js.JavascriptEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@CachedGenerator(name="Coffee", cacheDirectory="coffeeJS", mappingFileName="coffeeCache.txt", mode=CachedGenerator.CacheMode.ALL)
public class CoffeeScriptGenerator
extends AbstractJavascriptGenerator
implements ICoffeeScriptGenerator {
    private static final Logger PERF_LOGGER = LoggerFactory.getLogger((String)"net.jawr.perf.processing");
    private static final String COFFEE_SCRIPT_DEFAULT_OPTIONS = "";
    private static final String COFFEE_SCRIPT_SUFFIX = "coffee";
    private static final String JAWR_JS_GENERATOR_COFFEE_SCRIPT_JS_ENGINE = "jawr.js.generator.coffee.script.js.engine";
    private static final String JAWR_JS_GENERATOR_COFFEE_SCRIPT_OPTIONS = "jawr.js.generator.coffee.script.options";
    private static final String JAWR_JS_GENERATOR_COFFEE_SCRIPT_LOCATION = "jawr.js.generator.coffee.script.location";
    private static final String DEFAULT_COFFEE_SCRIPT_JS_LOCATION = "/net/jawr/web/resource/bundle/generator/js/coffee/coffee-script.js";
    private final ResourceGeneratorResolver resolver = ResourceGeneratorResolverFactory.createSuffixResolver("coffee");
    private Object coffeeScript;
    private Object options;
    private JavascriptEngine jsEngine;

    @Override
    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        StopWatch stopWatch = new StopWatch("initializing JS engine for Coffeescript");
        stopWatch.start();
        String script = this.config.getProperty(JAWR_JS_GENERATOR_COFFEE_SCRIPT_LOCATION, DEFAULT_COFFEE_SCRIPT_JS_LOCATION);
        this.jsEngine = new JavascriptEngine(this.config.getJavascriptEngineName(JAWR_JS_GENERATOR_COFFEE_SCRIPT_JS_ENGINE));
        try (InputStream inputStream = this.getResourceInputStream(script);){
            this.jsEngine.evaluate("coffee-script.js", inputStream);
        }
        catch (IOException e) {
            throw new BundlingProcessException(e);
        }
        String strOptions = this.config.getProperty(JAWR_JS_GENERATOR_COFFEE_SCRIPT_OPTIONS, COFFEE_SCRIPT_DEFAULT_OPTIONS);
        this.options = this.jsEngine.execEval(strOptions);
        this.coffeeScript = this.jsEngine.execEval("CoffeeScript");
        stopWatch.stop();
        if (PERF_LOGGER.isDebugEnabled()) {
            PERF_LOGGER.debug(stopWatch.shortSummary());
        }
    }

    private InputStream getResourceInputStream(String path) {
        InputStream is = this.config.getContext().getResourceAsStream(path);
        if (is == null) {
            try {
                is = ClassLoaderResourceUtils.getResourceAsStream(path, this);
            }
            catch (FileNotFoundException e) {
                throw new BundlingProcessException(e);
            }
        }
        return is;
    }

    @Override
    public ResourceGeneratorResolver getResolver() {
        return this.resolver;
    }

    @Override
    public Reader generateResource(String path, GeneratorContext context) {
        Reader rd = null;
        try {
            ArrayList excluded = new ArrayList();
            excluded.add(ICoffeeScriptGenerator.class);
            JoinableResourceBundle bundle = context.getBundle();
            rd = this.rsHandler.getResource(bundle, path, false, excluded);
            StringWriter swr = new StringWriter();
            IOUtils.copy(rd, (Writer)swr);
            String result = this.compile(path, swr.toString());
            rd = new StringReader(result);
            FilePathMapping fMapping = FilePathMappingUtils.buildFilePathMapping(path, this.rsHandler);
            if (fMapping != null) {
                this.addLinkedResources(path, context, fMapping);
            }
        }
        catch (IOException | ResourceNotFoundException e) {
            throw new BundlingProcessException(e);
        }
        return rd;
    }

    @Override
    protected void resetCache() {
        super.resetCache();
        this.cacheProperties.put(JAWR_JS_GENERATOR_COFFEE_SCRIPT_LOCATION, this.config.getProperty(JAWR_JS_GENERATOR_COFFEE_SCRIPT_LOCATION, DEFAULT_COFFEE_SCRIPT_JS_LOCATION));
        this.cacheProperties.put(JAWR_JS_GENERATOR_COFFEE_SCRIPT_OPTIONS, this.config.getProperty(JAWR_JS_GENERATOR_COFFEE_SCRIPT_OPTIONS, COFFEE_SCRIPT_DEFAULT_OPTIONS));
        this.cacheProperties.put(JAWR_JS_GENERATOR_COFFEE_SCRIPT_JS_ENGINE, this.config.getJavascriptEngineName(JAWR_JS_GENERATOR_COFFEE_SCRIPT_JS_ENGINE));
    }

    @Override
    protected boolean isCacheValid() {
        return super.isCacheValid() && StringUtils.equals(this.cacheProperties.getProperty(JAWR_JS_GENERATOR_COFFEE_SCRIPT_LOCATION), this.config.getProperty(JAWR_JS_GENERATOR_COFFEE_SCRIPT_LOCATION, DEFAULT_COFFEE_SCRIPT_JS_LOCATION)) && StringUtils.equals(this.cacheProperties.getProperty(JAWR_JS_GENERATOR_COFFEE_SCRIPT_OPTIONS), this.config.getProperty(JAWR_JS_GENERATOR_COFFEE_SCRIPT_OPTIONS, COFFEE_SCRIPT_DEFAULT_OPTIONS)) && StringUtils.equals(this.cacheProperties.getProperty(JAWR_JS_GENERATOR_COFFEE_SCRIPT_JS_ENGINE), this.config.getJavascriptEngineName(JAWR_JS_GENERATOR_COFFEE_SCRIPT_JS_ENGINE));
    }

    public String compile(String resourcePath, String coffeeScriptSource) {
        String result = null;
        try {
            result = (String)this.jsEngine.invokeMethod(this.coffeeScript, "compile", coffeeScriptSource, this.options);
        }
        catch (NoSuchMethodException | ScriptException e) {
            throw new BundlingProcessException(e);
        }
        return result;
    }
}

