/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle.generator.resolver;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.jawr.web.resource.bundle.generator.GeneratorMappingHelper;
import net.jawr.web.resource.bundle.generator.classpath.webjars.WebJarsLocatorCssGenerator;
import net.jawr.web.resource.bundle.generator.resolver.PrefixedPathResolver;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webjars.WebJarAssetLocator;

public class WebJarsLocatorPathResolver
extends PrefixedPathResolver {
    private static Logger LOGGER = LoggerFactory.getLogger(WebJarsLocatorCssGenerator.class);
    private static final String WEBJARS_RESOURCE_PREFIX = "META-INF/resources/webjars";
    private static Pattern WEBJARS_PREFIX_PATTERN = Pattern.compile("META-INF/resources/webjars(/[^/]*/[^/]*)");
    private final WebJarAssetLocator locator = new WebJarAssetLocator();
    private final boolean checkResourcePathForInfo;
    private final boolean checkResourcePathForWarning;
    private List<String> pathsChecked;

    public WebJarsLocatorPathResolver(String prefix) {
        this(prefix, false, false);
    }

    public WebJarsLocatorPathResolver(String prefix, boolean checkResourcePathForInfo, boolean checkResourcePathForWarning) {
        super(prefix);
        this.checkResourcePathForInfo = checkResourcePathForInfo;
        this.checkResourcePathForWarning = checkResourcePathForWarning;
        this.pathsChecked = new ArrayList<String>();
    }

    @Override
    public String getResourcePath(String requestedPath) {
        String resourcePath = super.getResourcePath(requestedPath);
        GeneratorMappingHelper helper = new GeneratorMappingHelper(resourcePath);
        String fullPath = null;
        fullPath = StringUtils.isNotEmpty((CharSequence)helper.getBracketsParam()) ? this.locator.getFullPath(helper.getBracketsParam(), helper.getPath()) : this.locator.getFullPath(resourcePath);
        if (this.checkResourcePathForInfo || this.checkResourcePathForWarning) {
            this.checkResourcePath(resourcePath, fullPath);
        }
        return fullPath.substring("/META-INF/resources/webjars/".length() - 2);
    }

    public Set<String> getResourceNames(String folder) {
        String path = super.getResourcePath(folder);
        Set assets = this.locator.listAssets(path);
        HashSet<String> resourceNames = new HashSet<String>();
        for (String asset : assets) {
            int idx = asset.indexOf(path);
            if (idx == -1) continue;
            String name = asset.substring(idx + path.length());
            if ((idx = name.indexOf("/")) != -1) {
                name = name.substring(0, idx + 1);
            }
            resourceNames.add(name);
        }
        return resourceNames;
    }

    private void checkResourcePath(String path, String fullPath) {
        if (!this.pathsChecked.contains(path)) {
            String shortPath;
            Matcher matcher;
            String pathToCheck;
            this.pathsChecked.add(path);
            if (this.checkResourcePathForInfo && (path.equals(pathToCheck = fullPath.substring(WEBJARS_RESOURCE_PREFIX.length())) || ("/" + path).equals(pathToCheck)) && LOGGER.isInfoEnabled()) {
                Matcher matcher2 = WEBJARS_PREFIX_PATTERN.matcher(fullPath);
                String useCorrectPathMsg = "";
                if (matcher2.find()) {
                    String shortPath2 = fullPath.substring(matcher2.group().length());
                    useCorrectPathMsg = "In your case, you should reference the resource 'webjars:" + path + "' by '" + "webjars" + ":" + shortPath2 + "'";
                }
                LOGGER.info("\nThe resource 'webjars:" + path + "' is referenced with it's version number. If you change the version of your webjars package, you'll need to update your mapping.\n" + "A better way to reference your resource is to avoid using the version number reference.\n" + useCorrectPathMsg);
            }
            if (this.checkResourcePathForWarning && (matcher = WEBJARS_PREFIX_PATTERN.matcher(fullPath)).find() && !path.equals(shortPath = fullPath.substring(matcher.group().length())) && LOGGER.isWarnEnabled()) {
                LOGGER.warn("\nThe reference to the CSS resource '" + path + "' could lead to issues " + "in binary resources (image, fonts, ...) mappings for the generated CSS resource.\n" + "Please update your bundle mapping to use webjars reference path which start after the version number.\n" + "In your case, you should reference the resource '" + "webjars" + ":" + path + "' by '" + "webjars" + ":" + shortPath + "'");
            }
        }
    }
}

