/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle.generator.validator;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import net.jawr.web.config.JawrConfig;
import net.jawr.web.exception.BundlingProcessException;
import net.jawr.web.resource.bundle.factory.util.ClassLoaderResourceUtils;
import net.jawr.web.resource.bundle.generator.AbstractJavascriptGenerator;
import net.jawr.web.resource.bundle.generator.GeneratorContext;
import net.jawr.web.resource.bundle.generator.JavascriptStringUtil;
import net.jawr.web.resource.bundle.generator.resolver.ResourceGeneratorResolver;
import net.jawr.web.resource.bundle.generator.resolver.ResourceGeneratorResolverFactory;
import org.apache.commons.validator.Arg;
import org.apache.commons.validator.Field;
import org.apache.commons.validator.Form;
import org.apache.commons.validator.Msg;
import org.apache.commons.validator.ValidatorAction;
import org.apache.commons.validator.ValidatorResources;
import org.apache.commons.validator.Var;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class CommonsValidatorGenerator
extends AbstractJavascriptGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)CommonsValidatorGenerator.class.getName());
    private static final String STATIC_JAVASCRIPT_KEY = "_static";
    private Map<String, ValidatorResources> validatorResourcesMap = new HashMap<String, ValidatorResources>();
    private ResourceGeneratorResolver resolver = ResourceGeneratorResolverFactory.createPrefixResolver("acv");
    private static final Comparator<ValidatorAction> ACTION_COMPARATOR = new Comparator<ValidatorAction>(){

        @Override
        public int compare(ValidatorAction va1, ValidatorAction va2) {
            if (!(va1.getDepends() != null && va1.getDepends().length() != 0 || va2.getDepends() != null && va2.getDepends().length() != 0)) {
                return 0;
            }
            if (va1.getDepends() != null && va1.getDepends().length() > 0 && (va2.getDepends() == null || va2.getDepends().length() == 0)) {
                return 1;
            }
            if ((va1.getDepends() == null || va1.getDepends().length() == 0) && va2.getDepends() != null && va2.getDepends().length() > 0) {
                return -1;
            }
            return va1.getDependencyList().size() - va2.getDependencyList().size();
        }
    };

    @Override
    public Reader generateResource(String path, GeneratorContext context) {
        Locale locale = null == context.getLocale() ? Locale.getDefault() : context.getLocale();
        String validators = context.getPath();
        String validatorParams = context.getParenthesesParam();
        String messagesNS = "messages";
        boolean stopOnErrors = true;
        StringTokenizer valparams = new StringTokenizer(validatorParams, "|");
        String validatorMappingKey = valparams.nextToken();
        if (valparams.hasMoreTokens()) {
            messagesNS = valparams.nextToken();
        }
        if (valparams.hasMoreTokens()) {
            stopOnErrors = Boolean.valueOf(valparams.nextToken());
        }
        if (!this.validatorResourcesMap.containsKey(validatorMappingKey)) {
            this.createValidatorResources(validatorMappingKey, context.getConfig());
        }
        ValidatorResources validatorResources = this.validatorResourcesMap.get(validatorMappingKey);
        StringBuffer sb = new StringBuffer();
        StringTokenizer tk = new StringTokenizer(validators, "|");
        while (tk.hasMoreTokens()) {
            String validator = tk.nextToken();
            if (STATIC_JAVASCRIPT_KEY.equals(validator)) {
                sb.append(this.buildStaticJavascript(validatorResources));
                continue;
            }
            sb.append(this.buildFormJavascript(validatorResources, validator, locale, messagesNS, stopOnErrors));
        }
        return new StringReader(sb.toString());
    }

    @Override
    public ResourceGeneratorResolver getResolver() {
        return this.resolver;
    }

    private StringBuffer buildFormJavascript(ValidatorResources validatorResources, String formName, Locale locale, String messageNS, boolean stopOnErrors) {
        Form form = validatorResources.getForm(locale, formName);
        return this.createDynamicJavascript(validatorResources, form, messageNS, stopOnErrors);
    }

    private StringBuffer createDynamicJavascript(ValidatorResources resources, Form form, String messageNS, boolean stopOnErrors) {
        StringBuffer results = new StringBuffer();
        List<ValidatorAction> actions = this.createActionList(resources, form);
        String methods = this.createMethods(actions, stopOnErrors);
        String jsFormName = form.getName();
        results.append(this.getJavascriptBegin(jsFormName, methods));
        for (ValidatorAction va : actions) {
            int jscriptVar = 0;
            String functionName = null;
            functionName = va.getJsFunctionName() != null && va.getJsFunctionName().length() > 0 ? va.getJsFunctionName() : va.getName();
            results.append("    function " + jsFormName + "_" + functionName + " () { \n");
            for (Field field : form.getFields()) {
                if (field.isIndexed() || !field.isDependency(va.getName())) continue;
                String message = null;
                Msg msg = field.getMessage(va.getName());
                if (msg != null && !msg.isResource()) {
                    message = JavascriptStringUtil.quote(msg.toString());
                } else {
                    message = msg == null ? va.getMsg() : msg.getKey();
                    Arg[] args = field.getArgs(va.getName());
                    message = messageNS + "." + message + "(";
                    for (int a = 0; a < args.length; ++a) {
                        if (args[a] == null) continue;
                        message = args[a].isResource() ? message + messageNS + "." + args[a].getKey() + "()" : message + "\"" + args[a].getKey() + "\"";
                        message = message + ",";
                    }
                    message = message + "null)";
                }
                message = message != null ? message : "";
                results.append("     this.a" + jscriptVar++ + " = [\"" + field.getKey() + "\", " + message + ", ");
                results.append("function(varName){");
                Map vars = field.getVars();
                for (Map.Entry varEntry : vars.entrySet()) {
                    String varName = (String)varEntry.getKey();
                    Var var = (Var)varEntry.getValue();
                    String varValue = var.getValue();
                    varValue = var.isResource() ? messageNS + "." + varValue + "()" : "'" + varValue + "'";
                    String jsType = var.getJsType();
                    if (varName.startsWith("field")) continue;
                    String varValueEscaped = JavascriptStringUtil.escape(varValue);
                    if ("int".equalsIgnoreCase(jsType)) {
                        results.append("this." + varName + "=+" + varValueEscaped + "; ");
                        continue;
                    }
                    if ("regexp".equalsIgnoreCase(jsType)) {
                        results.append("this." + varName + "=eval('/'+" + varValueEscaped + "+'/'); ");
                        continue;
                    }
                    if ("string".equalsIgnoreCase(jsType)) {
                        results.append("this." + varName + "=" + varValueEscaped + "; ");
                        continue;
                    }
                    if ("mask".equalsIgnoreCase(varName)) {
                        results.append("this." + varName + "=eval('/'+" + varValueEscaped + "+'/'); ");
                        continue;
                    }
                    results.append("this." + varName + "=" + varValueEscaped + "; ");
                }
                results.append(" return this[varName];}];\n");
            }
            results.append("    } \n\n");
        }
        return results;
    }

    protected String getJavascriptBegin(String jsFormName, String methods) {
        StringBuffer sb = new StringBuffer();
        String name = jsFormName.replace('/', '_');
        name = jsFormName.substring(0, 1).toUpperCase() + jsFormName.substring(1, jsFormName.length());
        sb.append("\n    var bCancel = false; \n\n");
        sb.append("    function validate" + name + "(form) { \n");
        sb.append("        if (bCancel) { \n");
        sb.append("            return true; \n");
        sb.append("        } else { \n");
        if (methods == null || methods.length() == 0) {
            sb.append("            return true; \n");
        } else {
            sb.append("            var formValidationResult; \n");
            sb.append("            formValidationResult = " + methods + "; \n");
            if (methods.indexOf("&&") >= 0) {
                sb.append("            return (formValidationResult); \n");
            } else {
                sb.append("            return (formValidationResult == 1); \n");
            }
        }
        sb.append("        } \n");
        sb.append("    } \n\n");
        return sb.toString();
    }

    private List<ValidatorAction> createActionList(ValidatorResources resources, Form form) {
        ArrayList<String> actionMethods = new ArrayList<String>();
        for (Field field : form.getFields()) {
            for (String o : field.getDependencyList()) {
                if (o == null || actionMethods.contains(o)) continue;
                actionMethods.add(o);
            }
        }
        ArrayList<ValidatorAction> actions = new ArrayList<ValidatorAction>();
        Iterator iterator = actionMethods.iterator();
        while (iterator.hasNext()) {
            String depends = (String)iterator.next();
            ValidatorAction va = resources.getValidatorAction(depends);
            if (va == null) {
                throw new NullPointerException("Depends string \"" + depends + "\" was not found in validator-rules.xml.");
            }
            if (va.getJavascript() != null && va.getJavascript().length() > 0) {
                actions.add(va);
                continue;
            }
            iterator.remove();
        }
        Collections.sort(actions, ACTION_COMPARATOR);
        return actions;
    }

    private String createMethods(List<ValidatorAction> actions, boolean stopOnErrors) {
        StringBuffer methods = new StringBuffer();
        String methodOperator = stopOnErrors ? " && " : " & ";
        for (ValidatorAction va : actions) {
            if (methods.length() > 0) {
                methods.append(methodOperator);
            }
            methods.append(va.getMethod()).append("(form)");
        }
        return methods.toString();
    }

    private StringBuffer buildStaticJavascript(ValidatorResources validatorResources) {
        StringBuffer sb = new StringBuffer();
        for (ValidatorAction va : validatorResources.getValidatorActions().values()) {
            String javascript;
            if (va == null || (javascript = va.getJavascript()) == null || javascript.length() <= 0) continue;
            sb.append(javascript).append("\n");
        }
        return sb;
    }

    private void createValidatorResources(String path, JawrConfig config) {
        ValidatorResources validatorResources = null;
        String configPaths = config.getConfigProperties().getProperty(path);
        StringTokenizer st = new StringTokenizer(configPaths, ",");
        InputStream[] inputStreams = new InputStream[st.countTokens()];
        int pos = 0;
        try {
            while (st.hasMoreTokens()) {
                String validatorRules = st.nextToken().trim();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Validation rules file from '" + validatorRules + "'");
                }
                InputStream is = null;
                try {
                    is = ClassLoaderResourceUtils.getResourceAsStream(validatorRules, this);
                }
                catch (FileNotFoundException fos) {
                    is = config.getContext().getResourceAsStream(validatorRules);
                }
                inputStreams[pos] = is;
                ++pos;
            }
            validatorResources = new ValidatorResources(inputStreams);
        }
        catch (SAXException ex) {
            throw new BundlingProcessException(ex);
        }
        catch (IOException e) {
            throw new BundlingProcessException(e);
        }
        this.validatorResourcesMap.put(path, validatorResources);
    }
}

