/*
 * Decompiled with CFR 0.152.
 */
package net.jawr.web.resource.bundle.generator.variant.css;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import net.jawr.web.resource.bundle.generator.variant.css.AbstractCssSkinVariantResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CssSkinVariantResolver
extends AbstractCssSkinVariantResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(CssSkinVariantResolver.class);

    public CssSkinVariantResolver() {
    }

    public CssSkinVariantResolver(String defaultSkin, String skinCookieName) {
        super(defaultSkin, skinCookieName);
    }

    @Override
    public String resolveVariant(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        String skin = this.defaultSkin;
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(this.skinCookieName)) continue;
                skin = cookie.getValue();
            }
        }
        LOGGER.debug("Resolved skin " + skin);
        return skin;
    }
}

